/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAction
extends SAMLObject
implements Cloneable {
    public static final String SAML_ACTION_NAMESPACE_RWEDC = "urn:oasis:names:tc:SAML:1.0:action:rwedc";
    public static final String SAML_ACTION_NAMESPACE_RWEDC_NEG = "urn:oasis:names:tc:SAML:1.0:action:rwedc-negation";
    public static final String SAML_ACTION_NAMESPACE_GHPP = "urn:oasis:names:tc:SAML:1.0:action:ghpp";
    public static final String SAML_ACTION_NAMESPACE_UNIX = "urn:oasis:names:tc:SAML:1.0:action:unix";
    private String namespace = null;
    private String data = null;

    public SAMLAction() {
    }

    public SAMLAction(String namespace, String data) throws SAMLException {
        this.namespace = XML.assign(namespace);
        this.data = XML.assign(data);
    }

    public SAMLAction(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAction(InputStream in) throws SAMLException {
        this.fromDOM(SAMLAction.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "Action")) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAction() requires saml:Action at root");
        }
        this.namespace = XML.assign(e.getAttributeNS(null, "Namespace"));
        if (e.hasChildNodes()) {
            this.data = XML.assign(e.getFirstChild().getNodeValue());
        }
        this.checkValidity();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getData() {
        return this.data;
    }

    public void setNamespace(String namespace) {
        this.namespace = XML.assign(namespace);
        this.setDirty(true);
    }

    public void setData(String data) {
        if (XML.isEmpty(data)) {
            throw new IllegalArgumentException("data cannot be null or empty");
        }
        this.data = data;
        this.setDirty(true);
    }

    protected Element buildRoot(Document doc, boolean xmlns) {
        Element a = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Action");
        if (xmlns) {
            a.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return a;
    }

    public Node toDOM(Document doc, boolean xmlns) throws SAMLException {
        super.toDOM(doc, xmlns);
        if (this.dirty) {
            Element a = (Element)this.root;
            if (!XML.isEmpty(this.namespace)) {
                a.setAttributeNS(null, "Namespace", this.namespace);
            }
            a.appendChild(doc.createTextNode(this.data));
            this.setDirty(false);
        } else if (xmlns) {
            ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (XML.isEmpty(this.data)) {
            throw new MalformedException("Action is invalid, data must have a value");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

