/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAttributeDesignator
extends SAMLObject
implements Cloneable {
    protected String name = null;
    protected String namespace = null;

    public SAMLAttributeDesignator() {
    }

    public SAMLAttributeDesignator(String name, String namespace) throws SAMLException {
        this.name = XML.assign(name);
        this.namespace = XML.assign(namespace);
    }

    public SAMLAttributeDesignator(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAttributeDesignator(InputStream in) throws SAMLException {
        this.fromDOM(SAMLAttributeDesignator.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "AttributeDesignator")) {
            throw new MalformedException("SAMLAttributeDesignator.fromDOM() requires saml:AttributeDesignator at root");
        }
        this.name = XML.assign(e.getAttributeNS(null, "AttributeName"));
        this.namespace = XML.assign(e.getAttributeNS(null, "AttributeNamespace"));
        this.checkValidity();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (XML.isEmpty(name)) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name;
        this.setDirty(true);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        if (XML.isEmpty(namespace)) {
            throw new IllegalArgumentException("namespace cannot be null");
        }
        this.namespace = namespace;
        this.setDirty(true);
    }

    protected Element buildRoot(Document doc, boolean xmlns) {
        Element a = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeDesignator");
        if (xmlns) {
            a.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return a;
    }

    public Node toDOM(Document doc, boolean xmlns) throws SAMLException {
        super.toDOM(doc, xmlns);
        Element a = (Element)this.root;
        if (this.dirty) {
            a.setAttributeNS(null, "AttributeName", this.name);
            a.setAttributeNS(null, "AttributeNamespace", this.namespace);
            this.setDirty(false);
        } else if (xmlns) {
            a.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (XML.isEmpty(this.name) || XML.isEmpty(this.namespace)) {
            throw new MalformedException(SAMLException.RESPONDER, "AttributeDesignator invalid, requires name and namespace");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return (SAMLAttributeDesignator)super.clone();
    }
}

