/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.opensaml.MalformedException;
import org.opensaml.SAMLAttributeDesignator;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectQuery;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAttributeQuery
extends SAMLSubjectQuery
implements Cloneable {
    protected String resource = null;
    protected ArrayList designators = new ArrayList();

    public SAMLAttributeQuery() {
    }

    public SAMLAttributeQuery(SAMLSubject subject, String resource, Collection designators) throws SAMLException {
        super(subject);
        this.resource = XML.assign(resource);
        if (designators != null) {
            Iterator i = designators.iterator();
            while (i.hasNext()) {
                this.designators.add(((SAMLAttributeDesignator)i.next()).setParent(this));
            }
        }
    }

    public SAMLAttributeQuery(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAttributeQuery(InputStream in) throws SAMLException {
        this.fromDOM(SAMLAttributeQuery.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "AttributeQuery")) {
            QName q = XML.getQNameAttribute(e, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "Query") && XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "SubjectQuery") && q != null && "urn:oasis:names:tc:SAML:1.0:protocol".equals(q.getNamespaceURI()) && "AttributeQueryType".equals(q.getLocalPart()))) {
                throw new MalformedException(SAMLException.REQUESTER, "SAMLAttributeQuery() requires samlp:AttributeQuery at root");
            }
        }
        if (e.hasAttributeNS(null, "Resource")) {
            this.resource = XML.assign(e.getAttributeNS(null, "Resource"));
        }
        Element n = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "AttributeDesignator");
        while (n != null) {
            this.designators.add(new SAMLAttributeDesignator(n).setParent(this));
            n = XML.getNextSiblingElement(n, "urn:oasis:names:tc:SAML:1.0:assertion", "AttributeDesignator");
        }
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = XML.assign(resource);
        this.setDirty(true);
    }

    public Iterator getDesignators() {
        return this.designators.iterator();
    }

    public void setDesignators(Collection designators) throws SAMLException {
        this.designators.clear();
        if (designators != null) {
            Iterator i = designators.iterator();
            while (i.hasNext()) {
                this.designators.add(((SAMLAttributeDesignator)i.next()).setParent(this));
            }
        }
        this.setDirty(true);
    }

    public void addDesignator(SAMLAttributeDesignator designator) throws SAMLException {
        if (designator == null) {
            throw new IllegalArgumentException("designator cannot be null");
        }
        this.designators.add(designator.setParent(this));
        this.setDirty(true);
    }

    public void removeDesignator(int index) {
        this.designators.remove(index);
        this.setDirty(true);
    }

    protected Element buildRoot(Document doc, boolean xmlns) {
        Element q = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "AttributeQuery");
        if (xmlns) {
            q.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
        }
        return q;
    }

    public Node toDOM(Document doc, boolean xmlns) throws SAMLException {
        super.toDOM(doc, xmlns);
        Element q = (Element)this.root;
        if (this.dirty) {
            if (!XML.isEmpty(this.resource)) {
                q.setAttributeNS(null, "Resource", this.resource);
            }
            Iterator i = this.designators.iterator();
            while (i.hasNext()) {
                q.appendChild(((SAMLAttributeDesignator)i.next()).toDOM(doc));
            }
            this.setDirty(false);
        } else if (xmlns) {
            q.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
        }
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAttributeQuery dup = (SAMLAttributeQuery)super.clone();
        try {
            dup.designators = new ArrayList();
            Iterator i = this.designators.iterator();
            while (i.hasNext()) {
                dup.designators.add(((SAMLAttributeDesignator)((SAMLAttributeDesignator)i.next()).clone()).setParent(dup));
            }
        }
        catch (SAMLException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        return dup;
    }
}

