/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.opensaml.MalformedException;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectStatement;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAttributeStatement
extends SAMLSubjectStatement
implements Cloneable {
    protected ArrayList attrs = new ArrayList();

    public SAMLAttributeStatement() {
    }

    public SAMLAttributeStatement(SAMLSubject subject, Collection attrs) throws SAMLException {
        super(subject);
        Iterator i = attrs.iterator();
        while (i.hasNext()) {
            this.attrs.add(((SAMLAttribute)i.next()).setParent(this));
        }
    }

    public SAMLAttributeStatement(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAttributeStatement(InputStream in) throws SAMLException {
        this.fromDOM(SAMLAttributeStatement.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatement")) {
            QName q = XML.getQNameAttribute(e, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "Statement") && XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectStatement") && q != null && "urn:oasis:names:tc:SAML:1.0:assertion".equals(q.getNamespaceURI()) && "AttributeStatementType".equals(q.getLocalPart()))) {
                throw new MalformedException(SAMLException.REQUESTER, "SAMLAttributeStatement() requires saml:AttributeStatement at root");
            }
        }
        Element n = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "Attribute");
        while (n != null) {
            try {
                this.attrs.add(SAMLAttribute.getInstance(n).setParent(this));
            }
            catch (SAMLException ex) {
                this.log.warn((Object)("exception while instantiating a SAMLAttribute: " + ex.getMessage()));
            }
            n = XML.getNextSiblingElement(n, "urn:oasis:names:tc:SAML:1.0:assertion", "Attribute");
        }
    }

    public Iterator getAttributes() {
        return this.attrs.iterator();
    }

    public void setAttributes(Collection attributes) throws SAMLException {
        this.attrs.clear();
        if (attributes != null) {
            Iterator i = attributes.iterator();
            while (i.hasNext()) {
                this.attrs.add(((SAMLAttribute)i.next()).setParent(this));
            }
        }
        this.setDirty(true);
    }

    public void addAttribute(SAMLAttribute attribute) throws SAMLException {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute cannot be null");
        }
        this.attrs.add(attribute.setParent(this));
        this.setDirty(true);
    }

    public void removeAttribute(int index) {
        this.attrs.remove(index);
        this.setDirty(true);
    }

    protected Element buildRoot(Document doc, boolean xmlns) {
        Element s = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatement");
        if (xmlns) {
            s.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
            s.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            s.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        return s;
    }

    public Node toDOM(Document doc, boolean xmlns) throws SAMLException {
        super.toDOM(doc, xmlns);
        Element statement = (Element)this.root;
        if (this.dirty) {
            Iterator i = this.attrs.iterator();
            while (i.hasNext()) {
                statement.appendChild(((SAMLAttribute)i.next()).toDOM(doc, false));
            }
            this.setDirty(false);
        } else if (xmlns) {
            statement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
            statement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            statement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        super.checkValidity();
        if (this.attrs == null || this.attrs.size() == 0) {
            throw new MalformedException("AttributeStatement is invalid, requires at least one attribute");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAttributeStatement dup = (SAMLAttributeStatement)super.clone();
        try {
            dup.attrs = new ArrayList();
            Iterator i = this.attrs.iterator();
            while (i.hasNext()) {
                dup.attrs.add(((SAMLAttribute)((SAMLAttribute)i.next()).clone()).setParent(dup));
            }
        }
        catch (SAMLException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        return dup;
    }
}

