/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import javax.xml.namespace.QName;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectQuery;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAuthenticationQuery
extends SAMLSubjectQuery
implements Cloneable {
    protected String authMethod = null;

    public SAMLAuthenticationQuery() {
    }

    public SAMLAuthenticationQuery(SAMLSubject subject, String authMethod) throws SAMLException {
        super(subject);
        this.authMethod = XML.assign(authMethod);
    }

    public SAMLAuthenticationQuery(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAuthenticationQuery(InputStream in) throws SAMLException {
        this.fromDOM(SAMLAuthenticationQuery.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "AuthenticationQuery")) {
            QName q = XML.getQNameAttribute(e, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "Query") && XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "SubjectQuery") && q != null && "urn:oasis:names:tc:SAML:1.0:protocol".equals(q.getNamespaceURI()) && "AuthenticationQueryType".equals(q.getLocalPart()))) {
                throw new MalformedException(SAMLException.REQUESTER, "SAMLAuthenticationQuery.fromDOM() requires samlp:AuthenticationQuery at root");
            }
        }
        this.authMethod = XML.assign(e.getAttributeNS(null, "AuthenticationMethod"));
        this.checkValidity();
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        if (XML.isEmpty(authMethod)) {
            throw new IllegalArgumentException("authMethod cannot be null or empty");
        }
        this.authMethod = authMethod;
        this.setDirty(true);
    }

    protected Element buildRoot(Document doc, boolean xmlns) {
        Element q = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "AuthenticationQuery");
        if (xmlns) {
            q.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
        }
        return q;
    }

    public Node toDOM(Document doc, boolean xmlns) throws SAMLException {
        super.toDOM(doc, xmlns);
        Element q = (Element)this.root;
        if (this.dirty) {
            if (!XML.isEmpty(this.authMethod)) {
                q.setAttributeNS(null, "AuthenticationMethod", this.authMethod);
            }
            this.setDirty(false);
        } else if (xmlns) {
            q.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
        }
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

