/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.opensaml.MalformedException;
import org.opensaml.SAMLAuthorityBinding;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectStatement;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAuthenticationStatement
extends SAMLSubjectStatement
implements Cloneable {
    protected String subjectIP = null;
    protected String subjectDNS = null;
    protected String authMethod = null;
    protected Date authInstant = null;
    protected ArrayList bindings = new ArrayList();
    public static final String AuthenticationMethod_Password = "urn:oasis:names:tc:SAML:1.0:am:password";
    public static final String AuthenticationMethod_Kerberos = "urn:ietf:rfc:1510";
    public static final String AuthenticationMethod_SRP = "urn:ietf:rfc:2945";
    public static final String AuthenticationMethod_HardwareToken = "urn:oasis:names:tc:SAML:1.0:am:HardwareToken";
    public static final String AuthenticationMethod_SSL_TLS_Client = "urn:ietf:rfc:2246";
    public static final String AuthenticationMethod_X509_PublicKey = "urn:oasis:names:tc:SAML:1.0:am:X509-PKI";
    public static final String AuthenticationMethod_PGP_PublicKey = "urn:oasis:names:tc:SAML:1.0:am:PGP";
    public static final String AuthenticationMethod_SPKI_PublicKey = "urn:oasis:names:tc:SAML:1.0:am:SPKI";
    public static final String AuthenticationMethod_XKMS_PublicKey = "urn:oasis:names:tc:SAML:1.0:am:XKMS";
    public static final String AuthenticationMethod_XML_DSig = "urn:ietf:rfc:3075";
    public static final String AuthenticationMethod_Unspecified = "urn:oasis:names:tc:SAML:1.0:am:unspecified";

    public SAMLAuthenticationStatement() {
    }

    public SAMLAuthenticationStatement(SAMLSubject subject, String authMethod, Date authInstant, String subjectIP, String subjectDNS, Collection bindings) throws SAMLException {
        super(subject);
        this.subjectIP = XML.assign(subjectIP);
        this.subjectDNS = XML.assign(subjectDNS);
        this.authMethod = XML.assign(authMethod);
        this.authInstant = authInstant;
        if (bindings != null) {
            Iterator i = bindings.iterator();
            while (i.hasNext()) {
                this.bindings.add(((SAMLAuthorityBinding)i.next()).setParent(this));
            }
        }
    }

    public SAMLAuthenticationStatement(SAMLSubject subject, Date authInstant, String subjectIP, String subjectDNS, Collection bindings) throws SAMLException {
        this(subject, AuthenticationMethod_Unspecified, authInstant, subjectIP, subjectDNS, bindings);
    }

    public SAMLAuthenticationStatement(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAuthenticationStatement(InputStream in) throws SAMLException {
        this.fromDOM(SAMLAuthenticationStatement.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatement")) {
            QName q = XML.getQNameAttribute(e, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "Statement") && q != null && "urn:oasis:names:tc:SAML:1.0:assertion".equals(q.getNamespaceURI()) && "AuthenticationStatementType".equals(q.getLocalPart()))) {
                throw new MalformedException(SAMLException.RESPONDER, "SAMLAuthenticationStatement() requires saml:AuthenticationStatement at root");
            }
        }
        this.authMethod = XML.assign(e.getAttributeNS(null, "AuthenticationMethod"));
        try {
            SimpleDateFormat formatter = null;
            String dateTime = XML.assign(e.getAttributeNS(null, "AuthenticationInstant"));
            int dot = dateTime.indexOf(46);
            formatter = dot > 0 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.authInstant = formatter.parse(dateTime);
        }
        catch (ParseException ex) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAuthenticationStatement() detected an invalid datetime while parsing statement", (Exception)ex);
        }
        Element n = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectLocality");
        if (n != null) {
            this.subjectIP = XML.assign(n.getAttributeNS(null, "IPAddress"));
            this.subjectDNS = XML.assign(n.getAttributeNS(null, "DNSAddress"));
            n = XML.getNextSiblingElement(n);
        }
        n = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthorityBinding");
        while (n != null) {
            this.bindings.add(new SAMLAuthorityBinding(n).setParent(this));
            n = XML.getNextSiblingElement(n, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthorityBinding");
        }
        this.checkValidity();
    }

    public String getSubjectIP() {
        return this.subjectIP;
    }

    public void setSubjectIP(String subjectIP) {
        this.subjectIP = XML.assign(subjectIP);
        this.setDirty(true);
    }

    public String getSubjectDNS() {
        return this.subjectDNS;
    }

    public void setSubjectDNS(String subjectDNS) {
        this.subjectDNS = XML.assign(subjectDNS);
        this.setDirty(true);
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        if (XML.isEmpty(authMethod)) {
            throw new IllegalArgumentException("authMethod cannot be null");
        }
        this.authMethod = authMethod;
        this.setDirty(true);
    }

    public Date getAuthInstant() {
        return this.authInstant;
    }

    public void setAuthInstant(Date authInstant) {
        if (authInstant == null) {
            throw new IllegalArgumentException("authInstant cannot be null");
        }
        this.authInstant = authInstant;
        this.setDirty(true);
    }

    public Iterator getBindings() {
        return this.bindings.iterator();
    }

    public void setBindings(Collection bindings) throws SAMLException {
        this.bindings.clear();
        if (bindings != null) {
            Iterator i = bindings.iterator();
            while (i.hasNext()) {
                this.bindings.add(((SAMLAuthorityBinding)i.next()).setParent(this));
            }
        }
        this.setDirty(true);
    }

    public void addBinding(SAMLAuthorityBinding binding) throws SAMLException {
        if (binding == null) {
            throw new IllegalArgumentException("binding cannot be null");
        }
        this.bindings.add(binding.setParent(this));
        this.setDirty(true);
    }

    public void removeBinding(int index) {
        this.bindings.remove(index);
        this.setDirty(true);
    }

    protected Element buildRoot(Document doc, boolean xmlns) {
        Element s = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatement");
        if (xmlns) {
            s.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return s;
    }

    public Node toDOM(Document doc, boolean xmlns) throws SAMLException {
        super.toDOM(doc, xmlns);
        Element statement = (Element)this.root;
        if (this.dirty) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            statement.setAttributeNS(null, "AuthenticationInstant", formatter.format(this.authInstant));
            statement.setAttributeNS(null, "AuthenticationMethod", this.authMethod);
            if (!XML.isEmpty(this.subjectIP) || !XML.isEmpty(this.subjectDNS)) {
                Element locality = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectLocality");
                if (!XML.isEmpty(this.subjectIP)) {
                    locality.setAttributeNS(null, "IPAddress", this.subjectIP);
                }
                if (!XML.isEmpty(this.subjectDNS)) {
                    locality.setAttributeNS(null, "DNSAddress", this.subjectDNS);
                }
                statement.appendChild(locality);
            }
            Iterator i = this.bindings.iterator();
            while (i.hasNext()) {
                statement.appendChild(((SAMLAuthorityBinding)i.next()).toDOM(doc, false));
            }
            this.setDirty(false);
        } else if (xmlns) {
            statement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        super.checkValidity();
        if (XML.isEmpty(this.authMethod) || this.authInstant == null) {
            throw new MalformedException("AuthenticationStatement is invalid, requires AuthenticationMethod and AuthenticationInstant");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAuthenticationStatement dup = (SAMLAuthenticationStatement)super.clone();
        try {
            dup.bindings = new ArrayList();
            Iterator i = this.bindings.iterator();
            while (i.hasNext()) {
                dup.bindings.add(((SAMLAuthorityBinding)((SAMLAuthorityBinding)i.next()).clone()).setParent(dup));
            }
        }
        catch (SAMLException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        return dup;
    }
}

