/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.opensaml.MalformedException;
import org.opensaml.SAMLAction;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectStatement;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAuthorizationDecisionStatement
extends SAMLSubjectStatement
implements Cloneable {
    protected String resource = null;
    protected String decision = null;
    protected ArrayList actions = new ArrayList();
    protected ArrayList evidence = new ArrayList();

    public SAMLAuthorizationDecisionStatement() {
    }

    public SAMLAuthorizationDecisionStatement(SAMLSubject subject, String resource, String decision, Collection actions, Collection evidence) throws SAMLException {
        super(subject);
        Iterator i;
        this.resource = XML.assign(resource);
        this.decision = XML.assign(decision);
        if (actions != null) {
            i = actions.iterator();
            while (i.hasNext()) {
                this.actions.add(((SAMLAction)i.next()).setParent(this));
            }
        }
        if (evidence != null) {
            i = evidence.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (o instanceof SAMLAssertion) {
                    this.evidence.add(((SAMLAssertion)o).setParent(this));
                    continue;
                }
                if (!(o instanceof String) || ((String)o).length() <= 0) continue;
                this.evidence.add(o);
            }
        }
    }

    public SAMLAuthorizationDecisionStatement(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAuthorizationDecisionStatement(InputStream in) throws SAMLException {
        this.fromDOM(SAMLAuthorizationDecisionStatement.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthorizationDecisionStatement")) {
            QName q = XML.getQNameAttribute(e, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "Statement") && XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectStatement") && q != null && "urn:oasis:names:tc:SAML:1.0:assertion".equals(q.getNamespaceURI()) && "AuthorizationDecisionStatementType".equals(q.getLocalPart()))) {
                throw new MalformedException(SAMLException.REQUESTER, "SAMLAuthorizationDecisionStatement.fromDOM() requires saml:AuthorizationDecisionStatement at root");
            }
        }
        this.resource = XML.assign(e.getAttributeNS(null, "Resource"));
        this.decision = XML.assign(e.getAttributeNS(null, "Decision"));
        Element n = XML.getFirstChildElement(e, "urn:oasis:names:tc:SAML:1.0:assertion", "Action");
        while (n != null) {
            this.actions.add(new SAMLAction(n).setParent(this));
            n = XML.getNextSiblingElement(n, "urn:oasis:names:tc:SAML:1.0:assertion", "Action");
        }
        n = XML.getFirstChildElement(e, "urn:oasis:names:tc:SAML:1.0:assertion", "Evidence");
        if (n != null) {
            Element n2 = XML.getFirstChildElement(n);
            while (n2 != null) {
                if (XML.isElementNamed(n2, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion")) {
                    this.evidence.add(new SAMLAssertion(n2).setParent(this));
                } else if (XML.isElementNamed(n2, "urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference") && n2.hasChildNodes()) {
                    this.evidence.add(n2.getFirstChild().getNodeValue());
                }
                n2 = XML.getNextSiblingElement(n2);
            }
        }
        this.checkValidity();
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        if (XML.isEmpty(resource)) {
            throw new IllegalArgumentException("resource cannot be null");
        }
        this.resource = resource;
        this.setDirty(true);
    }

    public String getDecision() {
        return this.decision;
    }

    public void setDecision(String decision) {
        if (XML.isEmpty(decision)) {
            throw new IllegalArgumentException("decision cannot be null");
        }
        this.decision = decision;
        this.setDirty(true);
    }

    public Iterator getActions() {
        return this.actions.iterator();
    }

    public void setActions(Collection actions) throws SAMLException {
        this.actions.clear();
        if (actions != null) {
            Iterator i = actions.iterator();
            while (i.hasNext()) {
                this.actions.add(((SAMLAction)i.next()).setParent(this));
            }
        }
        this.setDirty(true);
    }

    public void addAction(SAMLAction action) throws SAMLException {
        if (action == null) {
            throw new IllegalArgumentException("action cannot be null");
        }
        this.actions.add(action.setParent(this));
        this.setDirty(true);
    }

    public void removeAction(int index) {
        this.actions.remove(index);
        this.setDirty(true);
    }

    public Iterator getEvidence() {
        return this.evidence.iterator();
    }

    public void setEvidence(Collection evidence) throws SAMLException {
        this.evidence.clear();
        if (evidence != null) {
            Iterator i = evidence.iterator();
            while (i.hasNext()) {
                this.addEvidence(i.next());
            }
        }
        this.setDirty(true);
    }

    public void addEvidence(Object evidence) throws SAMLException {
        if (evidence != null && (evidence instanceof String || evidence instanceof SAMLAssertion)) {
            if (evidence instanceof SAMLAssertion) {
                this.evidence.add(((SAMLAssertion)evidence).setParent(this));
            } else if (((String)evidence).length() > 0) {
                this.evidence.add(evidence);
            }
        } else {
            throw new IllegalArgumentException("can only add Strings or SAMLAssertions");
        }
        this.setDirty(true);
    }

    public void removeEvidence(int index) throws IndexOutOfBoundsException {
        this.evidence.remove(index);
        this.setDirty(true);
    }

    protected Element buildRoot(Document doc, boolean xmlns) {
        Element s = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AuthorizationDecisionStatement");
        if (xmlns) {
            s.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return s;
    }

    public Node toDOM(Document doc, boolean xmlns) throws SAMLException {
        super.toDOM(doc, xmlns);
        Element s = (Element)this.root;
        if (this.dirty) {
            s.setAttributeNS(null, "Resource", this.resource);
            s.setAttributeNS(null, "Decision", this.decision);
            Iterator i = this.actions.iterator();
            while (i.hasNext()) {
                s.appendChild(((SAMLAction)i.next()).toDOM(doc, false));
            }
            if (this.evidence.size() > 0) {
                Element ev = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Evidence");
                i = this.evidence.iterator();
                while (i.hasNext()) {
                    Object o = i.next();
                    if (o instanceof SAMLAssertion) {
                        ev.appendChild(((SAMLAssertion)o).toDOM(doc, false));
                        continue;
                    }
                    if (!(o instanceof String) || XML.isEmpty((String)o)) continue;
                    ev.appendChild(doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference")).appendChild(doc.createTextNode((String)o));
                }
                s.appendChild(ev);
            }
            this.setDirty(false);
        } else if (xmlns) {
            s.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        super.checkValidity();
        if (XML.isEmpty(this.resource) || XML.isEmpty(this.decision) || this.actions.size() == 0) {
            throw new MalformedException("AuthorizationDecisionStatement is invalid, must have Resource, Decision, and at least one Action");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAuthorizationDecisionStatement dup = (SAMLAuthorizationDecisionStatement)super.clone();
        try {
            dup.actions = new ArrayList();
            Iterator i = this.actions.iterator();
            while (i.hasNext()) {
                dup.actions.add(((SAMLAction)((SAMLAction)i.next()).clone()).setParent(dup));
            }
            dup.evidence = new ArrayList();
            i = this.evidence.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (o instanceof SAMLAssertion) {
                    dup.evidence.add(((SAMLAssertion)((SAMLAssertion)o).clone()).setParent(dup));
                    continue;
                }
                if (!(o instanceof String)) continue;
                dup.evidence.add(o);
            }
        }
        catch (SAMLException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        return dup;
    }
}

