/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.lang.reflect.Constructor;
import org.opensaml.NoSuchProviderException;
import org.opensaml.SAMLBinding;
import org.opensaml.SAMLConfig;
import org.w3c.dom.Element;

public class SAMLBindingFactory {
    public static SAMLBinding getInstance(String binding) throws NoSuchProviderException {
        return SAMLBindingFactory.getInstance(binding, null, SAMLConfig.instance().getDefaultBindingProvider(binding));
    }

    public static SAMLBinding getInstance(String binding, Element e) throws NoSuchProviderException {
        return SAMLBindingFactory.getInstance(binding, e, SAMLConfig.instance().getDefaultBindingProvider(binding));
    }

    public static SAMLBinding getInstance(String binding, String provider) throws NoSuchProviderException {
        return SAMLBindingFactory.getInstance(binding, null, provider);
    }

    public static SAMLBinding getInstance(String binding, Element e, String provider) throws NoSuchProviderException {
        try {
            Class<?> implementation = Class.forName(provider);
            Class[] paramtypes = new Class[]{String.class, Element.class};
            Object[] params = new Object[]{binding, e};
            Constructor<?> ctor = implementation.getDeclaredConstructor(paramtypes);
            return (SAMLBinding)ctor.newInstance(params);
        }
        catch (Exception ex) {
            throw new NoSuchProviderException("getInstance() unable to build instance of binding provider (" + provider + "): " + ex.getMessage(), ex);
        }
    }
}

