/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import org.apache.log4j.Category;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SAMLNameIdentifier
extends SAMLObject
implements Cloneable {
    protected String name = null;
    protected String nameQualifier = null;
    protected String format = null;
    protected static Hashtable formatMap = new Hashtable();
    public static final String FORMAT_UNSPECIFIED = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
    public static final String FORMAT_EMAIL = "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress";
    public static final String FORMAT_X509 = "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName";
    public static final String FORMAT_WINDOWS = "urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName";

    public static void regFactory(String format, String className) {
        formatMap.put(format, className);
    }

    public static void unregFactory(String format) {
        formatMap.remove(format);
    }

    public static SAMLNameIdentifier getInstance(Element e) throws SAMLException {
        if (e == null) {
            throw new MalformedException("SAMLNameIdentifier.getInstance() given an empty DOM");
        }
        try {
            String className = (String)formatMap.get(e.getAttributeNS(null, "Format"));
            if (className == null) {
                return new SAMLNameIdentifier(e);
            }
            Class<?> implementation = Class.forName(className);
            Class[] paramtypes = new Class[]{Element.class};
            Object[] params = new Object[]{e};
            Constructor<?> ctor = implementation.getDeclaredConstructor(paramtypes);
            return (SAMLNameIdentifier)ctor.newInstance(params);
        }
        catch (ClassNotFoundException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLNameIdentifier.getInstance() unable to locate implementation class for NameIdentifier", (Exception)ex);
        }
        catch (NoSuchMethodException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLNameIdentifier.getInstance() unable to bind to constructor for NameIdentifier", (Exception)ex);
        }
        catch (InstantiationException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLNameIdentifier.getInstance() unable to build implementation object for NameIdentifier", (Exception)ex);
        }
        catch (IllegalAccessException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLNameIdentifier.getInstance() unable to access implementation of NameIdentifier", (Exception)ex);
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            Throwable e2 = ex.getTargetException();
            if (e2 instanceof SAMLException) {
                throw (SAMLException)e2;
            }
            throw new SAMLException(SAMLException.REQUESTER, "SAMLNameIdentifier.getInstance() caught unknown exception while building NameIdentifier object: " + e2.getMessage());
        }
    }

    public static SAMLNameIdentifier getInstance(InputStream in) throws SAMLException {
        try {
            Document doc = XML.parserPool.parse(in);
            return SAMLNameIdentifier.getInstance(doc.getDocumentElement());
        }
        catch (SAXException e) {
            Category.getInstance((String)"SAMLNameIdentifier").error((Object)("caught an exception while parsing a stream:\n" + e.getMessage()));
            throw new MalformedException("SAMLNameIdentifier.getInstance() caught exception while parsing a stream", (Exception)e);
        }
        catch (IOException e) {
            Category.getInstance((String)"SAMLNameIdentifier").error((Object)("caught an exception while parsing a stream:\n" + e.getMessage()));
            throw new MalformedException("SAMLNameIdentifier.getInstance() caught exception while parsing a stream", (Exception)e);
        }
    }

    public static SAMLNameIdentifier getInstance(String format) throws SAMLException {
        try {
            if (format == null) {
                return new SAMLNameIdentifier();
            }
            String className = (String)formatMap.get(format);
            if (className == null) {
                return new SAMLNameIdentifier(null, null, format);
            }
            Class<?> implementation = Class.forName(className);
            Class[] paramtypes = new Class[]{String.class, String.class, String.class};
            Object[] params = new Object[]{null, null, format};
            Constructor<?> ctor = implementation.getDeclaredConstructor(paramtypes);
            return (SAMLNameIdentifier)ctor.newInstance(params);
        }
        catch (ClassNotFoundException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLNameIdentifier.getInstance() unable to locate implementation class for NameIdentifier", (Exception)ex);
        }
        catch (NoSuchMethodException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLNameIdentifier.getInstance() unable to bind to constructor for NameIdentifier", (Exception)ex);
        }
        catch (InstantiationException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLNameIdentifier.getInstance() unable to build implementation object for NameIdentifier", (Exception)ex);
        }
        catch (IllegalAccessException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLNameIdentifier.getInstance() unable to access implementation of NameIdentifier", (Exception)ex);
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            Throwable e2 = ex.getTargetException();
            if (e2 instanceof SAMLException) {
                throw (SAMLException)e2;
            }
            throw new SAMLException(SAMLException.REQUESTER, "SAMLNameIdentifier.getInstance() caught unknown exception while building NameIdentifier object: " + e2.getMessage());
        }
    }

    public SAMLNameIdentifier() {
    }

    public SAMLNameIdentifier(String name, String nameQualifier, String format) throws SAMLException {
        this.name = XML.assign(name);
        this.nameQualifier = XML.assign(nameQualifier);
        this.format = XML.assign(format);
    }

    public SAMLNameIdentifier(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLNameIdentifier(InputStream in) throws SAMLException {
        this.fromDOM(SAMLNameIdentifier.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier")) {
            throw new MalformedException("SAMLNameIdentifier.fromDOM() requires saml:NameIdentifier at root");
        }
        this.nameQualifier = XML.assign(e.getAttributeNS(null, "NameQualifier"));
        this.format = XML.assign(e.getAttributeNS(null, "Format"));
        this.name = XML.assign(e.getFirstChild().getNodeValue());
        this.checkValidity();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (XML.isEmpty(name)) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        this.name = name;
        this.setDirty(true);
    }

    public String getNameQualifier() {
        return this.nameQualifier;
    }

    public void setNameQualifier(String nameQualifier) {
        this.nameQualifier = XML.assign(nameQualifier);
        this.setDirty(true);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = XML.assign(format);
        this.setDirty(true);
    }

    protected Element buildRoot(Document doc, boolean xmlns) {
        Element e = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier");
        if (xmlns) {
            e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return e;
    }

    public Node toDOM(Document doc, boolean xmlns) throws SAMLException {
        super.toDOM(doc, xmlns);
        Element nameid = (Element)this.root;
        if (this.dirty) {
            if (!XML.isEmpty(this.nameQualifier)) {
                nameid.setAttributeNS(null, "NameQualifier", this.nameQualifier);
            }
            if (!XML.isEmpty(this.format)) {
                nameid.setAttributeNS(null, "Format", this.format);
            }
            nameid.appendChild(doc.createTextNode(this.name));
            this.setDirty(false);
        } else if (xmlns) {
            nameid.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (XML.isEmpty(this.name)) {
            throw new MalformedException("NameIdentifier is invalid, requires name");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return (SAMLNameIdentifier)super.clone();
    }
}

