/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.opensaml.MalformedException;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLException;
import org.opensaml.SAMLQuery;
import org.opensaml.SAMLSignedObject;
import org.opensaml.XML;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.ArtifactParseException;
import org.opensaml.artifact.ArtifactParserException;
import org.opensaml.artifact.SAMLArtifact;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SAMLRequest
extends SAMLSignedObject
implements Cloneable {
    protected int minor;
    protected String requestId;
    protected Date issueInstant;
    protected ArrayList respondWiths;
    protected SAMLQuery query;
    protected ArrayList assertionIdRefs;
    protected ArrayList artifacts;

    protected void insertSignature() throws SAMLException {
        Element n = XML.getFirstChildElement(this.root);
        while (n != null && XML.isElementNamed(n, "urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith")) {
            n = XML.getNextSiblingElement(n);
        }
        this.root.insertBefore(this.getSignatureElement(), n);
    }

    public SAMLRequest() {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.requestId = null;
        this.issueInstant = new Date();
        this.respondWiths = new ArrayList();
        this.query = null;
        this.assertionIdRefs = new ArrayList();
        this.artifacts = new ArrayList();
    }

    public SAMLRequest(SAMLQuery query) throws SAMLException {
        this(query, SAMLConfig.instance().getDefaultIDProvider().getIdentifier(), new Date());
    }

    public SAMLRequest(SAMLQuery query, String requestId, Date issueInstant) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.requestId = null;
        this.issueInstant = new Date();
        this.respondWiths = new ArrayList();
        this.query = null;
        this.assertionIdRefs = new ArrayList();
        this.artifacts = new ArrayList();
        this.requestId = XML.assign(requestId);
        this.issueInstant = issueInstant;
        if (query != null) {
            this.query = (SAMLQuery)query.setParent(this);
        }
    }

    public SAMLRequest(Collection artifactsOrIdRefs) throws SAMLException {
        this(artifactsOrIdRefs, SAMLConfig.instance().getDefaultIDProvider().getIdentifier(), new Date());
    }

    public SAMLRequest(Collection artifactsOrIdRefs, String requestId, Date issueInstant) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.requestId = null;
        this.issueInstant = new Date();
        this.respondWiths = new ArrayList();
        this.query = null;
        this.assertionIdRefs = new ArrayList();
        this.artifacts = new ArrayList();
        this.requestId = XML.assign(requestId);
        this.issueInstant = issueInstant;
        if (artifactsOrIdRefs != null && !artifactsOrIdRefs.isEmpty()) {
            Iterator i = artifactsOrIdRefs.iterator();
            Object first = i.next();
            if (first instanceof Artifact) {
                this.artifacts.add(first);
                while (i.hasNext()) {
                    this.artifacts.add((Artifact)i.next());
                }
            } else if (first instanceof String) {
                this.assertionIdRefs.add(first);
                while (i.hasNext()) {
                    this.assertionIdRefs.add((String)i.next());
                }
            } else {
                throw new MalformedException("SAMLRequest() collection parameter must contain Artifacts or Strings");
            }
        }
    }

    public SAMLRequest(Element e) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.requestId = null;
        this.issueInstant = new Date();
        this.respondWiths = new ArrayList();
        this.query = null;
        this.assertionIdRefs = new ArrayList();
        this.artifacts = new ArrayList();
        this.fromDOM(e);
    }

    public SAMLRequest(InputStream in) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.requestId = null;
        this.issueInstant = new Date();
        this.respondWiths = new ArrayList();
        this.query = null;
        this.assertionIdRefs = new ArrayList();
        this.artifacts = new ArrayList();
        this.fromDOM(SAMLRequest.fromStream(in));
    }

    public SAMLRequest(InputStream in, int minor) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.requestId = null;
        this.issueInstant = new Date();
        this.respondWiths = new ArrayList();
        this.query = null;
        this.assertionIdRefs = new ArrayList();
        this.artifacts = new ArrayList();
        this.fromDOM(SAMLRequest.fromStream(in, minor));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "Request")) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLRequest.fromDOM() requires samlp:Request at root");
        }
        if (Integer.parseInt(e.getAttributeNS(null, "MajorVersion")) != 1) {
            throw new MalformedException(SAMLException.VERSION, "SAMLRequest.fromDOM() detected incompatible request major version of " + e.getAttributeNS(null, "MajorVersion"));
        }
        this.minor = Integer.parseInt(e.getAttributeNS(null, "MinorVersion"));
        this.requestId = XML.assign(e.getAttributeNS(null, "RequestID"));
        if (this.minor > 0) {
            e.setIdAttributeNode(e.getAttributeNodeNS(null, "RequestID"), true);
        }
        try {
            SimpleDateFormat formatter = null;
            String dateTime = XML.assign(e.getAttributeNS(null, "IssueInstant"));
            int dot = dateTime.indexOf(46);
            formatter = dot > 0 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.issueInstant = formatter.parse(dateTime);
        }
        catch (ParseException ex) {
            throw new MalformedException(SAMLException.REQUESTER, "SAMLRequest.fromDOM() detected an invalid datetime while parsing request", (Exception)ex);
        }
        Element n = XML.getFirstChildElement(e);
        while (n != null && XML.isElementNamed(n, "urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith")) {
            this.respondWiths.add(XML.getQNameTextNode((Text)n.getFirstChild()));
            n = XML.getNextSiblingElement(n);
        }
        if (XML.isElementNamed(n, "http://www.w3.org/2000/09/xmldsig#", "Signature")) {
            n = XML.getNextSiblingElement(n);
        }
        if (XML.isElementNamed(n, "urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference")) {
            while (n != null && n.hasChildNodes()) {
                this.assertionIdRefs.add(n.getFirstChild().getNodeValue());
                n = XML.getNextSiblingElement(n, "urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference");
            }
        } else if (XML.isElementNamed(n, "urn:oasis:names:tc:SAML:1.0:protocol", "AssertionArtifact")) {
            while (n != null && n.hasChildNodes()) {
                try {
                    this.artifacts.add(SAMLArtifact.getTypeCode(n.getFirstChild().getNodeValue()).getParser().parse(n.getFirstChild().getNodeValue()));
                }
                catch (ArtifactParseException ex) {
                    throw new MalformedException(SAMLException.REQUESTER, "SAMLRequest.fromDOM() unable to parse artifact", (Exception)ex);
                }
                catch (ArtifactParserException ex) {
                    throw new MalformedException(SAMLException.REQUESTER, "SAMLRequest.fromDOM() unable to parse artifact", (Exception)ex);
                }
                n = XML.getNextSiblingElement(n, "urn:oasis:names:tc:SAML:1.0:protocol", "AssertionArtifact");
            }
        } else {
            this.query = (SAMLQuery)SAMLQuery.getInstance(n).setParent(this);
        }
        this.checkValidity();
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public void setMinorVersion(int minor) {
        this.minor = minor;
        this.setDirty(true);
    }

    public String getId() {
        return this.requestId;
    }

    public void setId(String id) {
        if (XML.isEmpty(id)) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.requestId = XML.assign(id);
        this.setDirty(true);
    }

    public Date getIssueInstant() {
        return this.issueInstant;
    }

    public void setIssueInstant(Date issueInstant) {
        if (issueInstant == null) {
            throw new IllegalArgumentException("issueInstant cannot be null");
        }
        this.issueInstant = issueInstant;
        this.setDirty(true);
    }

    public Iterator getRespondWiths() {
        return this.respondWiths.iterator();
    }

    public void setRespondWiths(Collection respondWiths) {
        this.respondWiths.clear();
        if (respondWiths != null) {
            Iterator i = respondWiths.iterator();
            while (i.hasNext()) {
                this.addRespondWith((QName)i.next());
            }
        }
        this.setDirty(true);
    }

    public void addRespondWith(QName respondWith) {
        if (respondWith == null) {
            throw new IllegalArgumentException("respondWith cannot be null");
        }
        this.respondWiths.add(respondWith);
        this.setDirty(true);
    }

    public void removeRespondWith(int index) throws IndexOutOfBoundsException {
        this.respondWiths.remove(index);
        this.setDirty(true);
    }

    public SAMLQuery getQuery() {
        return this.query;
    }

    public void setQuery(SAMLQuery query) throws SAMLException {
        if (query != null) {
            query.setParent(this);
            this.setAssertionIdRefs(null);
            this.setArtifacts(null);
        }
        this.query = query;
        this.setDirty(true);
    }

    public Iterator getAssertionIdRefs() {
        return this.assertionIdRefs.iterator();
    }

    public void addAssertionIdRef(String ref) {
        if (XML.isEmpty(ref)) {
            throw new IllegalArgumentException("ref cannot be null or empty");
        }
        try {
            this.setQuery(null);
        }
        catch (SAMLException sAMLException) {
            // empty catch block
        }
        this.setArtifacts(null);
        this.assertionIdRefs.add(ref);
    }

    public void setAssertionIdRefs(Collection refs) {
        this.assertionIdRefs.clear();
        if (refs != null) {
            Iterator i = refs.iterator();
            while (i.hasNext()) {
                this.addAssertionIdRef((String)i.next());
            }
        }
    }

    public void removeAssertionIdRef(int index) throws IndexOutOfBoundsException {
        this.assertionIdRefs.remove(index);
        this.setDirty(true);
    }

    public Iterator getArtifacts() {
        return this.artifacts.iterator();
    }

    public void setArtifacts(Collection artifacts) {
        this.artifacts.clear();
        if (artifacts != null) {
            Iterator i = artifacts.iterator();
            while (i.hasNext()) {
                this.addArtifact((Artifact)i.next());
            }
        }
    }

    public void addArtifact(Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException("artifact cannot be null or empty");
        }
        try {
            this.setQuery(null);
        }
        catch (SAMLException sAMLException) {
            // empty catch block
        }
        this.setAssertionIdRefs(null);
        this.artifacts.add(artifact);
    }

    public void removeArtifact(int index) throws IndexOutOfBoundsException {
        this.artifacts.remove(index);
        this.setDirty(true);
    }

    protected Element buildRoot(Document doc, boolean xmlns) {
        Element r = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "Request");
        if (xmlns) {
            r.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
            r.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
            r.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
            r.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            r.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        }
        return r;
    }

    public Node toDOM(Document doc, boolean xmlns) throws SAMLException {
        super.toDOM(doc, xmlns);
        Element r = (Element)this.root;
        if (this.dirty) {
            if (this.requestId == null) {
                this.requestId = this.config.getDefaultIDProvider().getIdentifier();
            }
            if (this.issueInstant == null) {
                this.issueInstant = new Date();
            }
            r.setAttributeNS(null, "MajorVersion", "1");
            r.setAttributeNS(null, "MinorVersion", String.valueOf(this.minor));
            r.setAttributeNS(null, "RequestID", this.requestId);
            if (this.minor > 0) {
                r.setIdAttributeNS(null, "RequestID", true);
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            r.setAttributeNS(null, "IssueInstant", formatter.format(this.issueInstant));
            Iterator i = this.respondWiths.iterator();
            while (i.hasNext()) {
                QName qn = (QName)i.next();
                Element rw = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith");
                String rwns = qn.getNamespaceURI();
                if (rwns == null) {
                    rwns = "";
                }
                if (!"urn:oasis:names:tc:SAML:1.0:assertion".equals(rwns)) {
                    rw.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:rw", rwns);
                    rwns = "rw:";
                } else {
                    rwns = "saml:";
                }
                rw.appendChild(doc.createTextNode(rwns + qn.getLocalPart()));
                r.appendChild(rw);
            }
            if (this.query != null) {
                r.appendChild(this.query.toDOM(doc, false));
            } else if (this.assertionIdRefs.size() > 0) {
                i = this.assertionIdRefs.iterator();
                while (i.hasNext()) {
                    r.appendChild(doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "saml:AssertionIDReference")).appendChild(doc.createTextNode((String)i.next()));
                }
            } else {
                i = this.artifacts.iterator();
                while (i.hasNext()) {
                    r.appendChild(doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "AssertionArtifact")).appendChild(doc.createTextNode(((Artifact)i.next()).encode()));
                }
            }
            this.setDirty(false);
        } else if (xmlns) {
            ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
            ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
            ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
            ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (this.requestId == null || this.query == null && this.assertionIdRefs.size() == 0 && this.artifacts.size() == 0) {
            throw new MalformedException("Request is invalid, must have an ID and query, assertion references, or artifacts");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object clone() throws CloneNotSupportedException {
        SAMLRequest dup = (SAMLRequest)super.clone();
        try {
            dup.respondWiths = (ArrayList)this.respondWiths.clone();
            dup.query = (SAMLQuery)((SAMLQuery)this.query.clone()).setParent(dup);
            dup.assertionIdRefs = (ArrayList)this.assertionIdRefs.clone();
            dup.artifacts = new ArrayList();
            Iterator i = this.artifacts.iterator();
            while (i.hasNext()) {
                String a = ((Artifact)i.next()).encode();
                try {
                    dup.artifacts.add(SAMLArtifact.getTypeCode(a).getParser().parse(a));
                }
                catch (ArtifactParseException e) {
                    throw new RuntimeException("Unable to clone artifact");
                }
                catch (ArtifactParserException e) {
                    throw new RuntimeException("Unable to clone artifact");
                    return dup;
                }
            }
        }
        catch (SAMLException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }
}

