/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.log4j.Category;
import org.apache.log4j.NDC;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.UnsupportedExtensionException;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class SAMLStatement
extends SAMLObject
implements Cloneable {
    protected static Hashtable statementTypeMap = new Hashtable();

    public static void regFactory(QName type, String className) {
        statementTypeMap.put(type, className);
    }

    public static void unregFactory(QName type) {
        statementTypeMap.remove(type);
    }

    public static SAMLStatement getInstance(Element e) throws SAMLException {
        if (e == null) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLStatement.getInstance() given an empty DOM");
        }
        try {
            if (XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "Statement") || XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectStatement")) {
                String className = (String)statementTypeMap.get(XML.getQNameAttribute(e, "http://www.w3.org/2001/XMLSchema-instance", "type"));
                if (className == null) {
                    throw new UnsupportedExtensionException(SAMLException.RESPONDER, "SAMLStatement.getInstance() unable to locate an implementation of specified statement type");
                }
                Class<?> implementation = Class.forName(className);
                Class[] paramtypes = new Class[]{Element.class};
                Object[] params = new Object[]{e};
                Constructor<?> ctor = implementation.getDeclaredConstructor(paramtypes);
                return (SAMLStatement)ctor.newInstance(params);
            }
            String className = (String)statementTypeMap.get(new QName(e.getNamespaceURI(), e.getLocalName()));
            if (className == null) {
                throw new UnsupportedExtensionException(SAMLException.RESPONDER, "SAMLStatement.getInstance() unable to locate an implementation of specified statement type");
            }
            Class<?> implementation = Class.forName(className);
            Class[] paramtypes = new Class[]{Element.class};
            Object[] params = new Object[]{e};
            Constructor<?> ctor = implementation.getDeclaredConstructor(paramtypes);
            return (SAMLStatement)ctor.newInstance(params);
        }
        catch (ClassNotFoundException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLStatement.getInstance() unable to locate implementation class for statement", (Exception)ex);
        }
        catch (NoSuchMethodException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLStatement.getInstance() unable to bind to constructor for statement", (Exception)ex);
        }
        catch (InstantiationException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLStatement.getInstance() unable to build implementation object for statement", (Exception)ex);
        }
        catch (IllegalAccessException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLStatement.getInstance() unable to access implementation of statement", (Exception)ex);
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            Throwable e2 = ex.getTargetException();
            if (e2 instanceof SAMLException) {
                throw (SAMLException)e2;
            }
            throw new SAMLException(SAMLException.REQUESTER, "SAMLStatement.getInstance() caught unknown exception while building statement object: " + e2.getMessage());
        }
    }

    public static SAMLStatement getInstance(InputStream in) throws SAMLException {
        try {
            Document doc = XML.parserPool.parse(in);
            return SAMLStatement.getInstance(doc.getDocumentElement());
        }
        catch (SAXException e) {
            NDC.push((String)"getInstance");
            Category.getInstance((String)"SAMLStatement").error((Object)("caught an exception while parsing a stream:\n" + e.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLStatement.getInstance() caught exception while parsing a stream", (Exception)e);
        }
        catch (IOException e) {
            NDC.push((String)"getInstance");
            Category.getInstance((String)"SAMLStatement").error((Object)("caught an exception while parsing a stream:\n" + e.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLStatement.getInstance() caught exception while parsing a stream", (Exception)e);
        }
    }
}

