/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLSubject
extends SAMLObject
implements Cloneable {
    protected SAMLNameIdentifier nameId;
    protected ArrayList confirmationMethods;
    protected Element confirmationData;
    protected KeyInfo keyInfo;
    public static final String CONF_ARTIFACT = "urn:oasis:names:tc:SAML:1.0:cm:artifact";
    public static final String CONF_ARTIFACT01 = "urn:oasis:names:tc:SAML:1.0:cm:artifact-01";
    public static final String CONF_BEARER = "urn:oasis:names:tc:SAML:1.0:cm:bearer";
    public static final String CONF_HOLDER_KEY = "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
    public static final String CONF_SENDER_VOUCHES = "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";

    public SAMLSubject() {
        this.nameId = null;
        this.confirmationMethods = new ArrayList();
        this.confirmationData = null;
        this.keyInfo = null;
    }

    public SAMLSubject(SAMLNameIdentifier nameId, Collection confirmationMethods, Element confirmationData, Object keyInfo) throws SAMLException {
        block8: {
            this.nameId = null;
            this.confirmationMethods = new ArrayList();
            this.confirmationData = null;
            this.keyInfo = null;
            if (nameId != null) {
                this.nameId = (SAMLNameIdentifier)nameId.setParent(this);
            }
            if (confirmationData != null && !XML.isElementNamed(confirmationData, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmationData")) {
                throw new IllegalArgumentException("confirmationData must be a saml:SubjectConfirmationData element");
            }
            this.confirmationData = confirmationData;
            if (confirmationMethods != null) {
                this.confirmationMethods.addAll(confirmationMethods);
            }
            if (keyInfo != null) {
                try {
                    if (keyInfo instanceof KeyInfo && ((KeyInfo)keyInfo).getElement().getParentNode() == null) {
                        this.keyInfo = (KeyInfo)keyInfo;
                        break block8;
                    }
                    if (keyInfo instanceof Element && ((Element)keyInfo).getParentNode() == null) {
                        this.keyInfo = new KeyInfo((Element)keyInfo, null);
                        break block8;
                    }
                    throw new IllegalArgumentException("SAMLSubject() unable to process the provided keyInfo object/element");
                }
                catch (XMLSecurityException e) {
                    throw new MalformedException("SAMLSubject() caught an XML security exception", (Exception)((Object)e));
                }
            }
        }
    }

    public SAMLSubject(Element e) throws SAMLException {
        this.nameId = null;
        this.confirmationMethods = new ArrayList();
        this.confirmationData = null;
        this.keyInfo = null;
        this.fromDOM(e);
    }

    public SAMLSubject(InputStream in) throws SAMLException {
        this.nameId = null;
        this.confirmationMethods = new ArrayList();
        this.confirmationData = null;
        this.keyInfo = null;
        this.fromDOM(SAMLSubject.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "Subject")) {
            throw new MalformedException("SAMLSubject.fromDOM() requires saml:Subject at root");
        }
        Element n = XML.getFirstChildElement(e, "urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier");
        if (n != null) {
            this.nameId = (SAMLNameIdentifier)SAMLNameIdentifier.getInstance(n).setParent(this);
        }
        if ((n = XML.getFirstChildElement(e, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation")) != null) {
            Element n2 = XML.getFirstChildElement(n);
            while (n2 != null && XML.isElementNamed(n2, "urn:oasis:names:tc:SAML:1.0:assertion", "ConfirmationMethod") && n2.hasChildNodes()) {
                this.confirmationMethods.add(n2.getFirstChild().getNodeValue());
                n2 = XML.getNextSiblingElement(n2);
            }
            if (n2 != null && XML.isElementNamed(n2, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmationData")) {
                this.confirmationData = n2;
                n2 = XML.getNextSiblingElement(n2);
            }
            if (n2 != null && XML.isElementNamed(n2, "http://www.w3.org/2000/09/xmldsig#", "KeyInfo")) {
                try {
                    this.keyInfo = new KeyInfo(n2, null);
                }
                catch (XMLSecurityException ex) {
                    throw new MalformedException("SAMLSubject.fromDOM() caught an XML security exception", (Exception)((Object)ex));
                }
            }
        }
        this.checkValidity();
    }

    public SAMLNameIdentifier getNameIdentifier() {
        return this.nameId;
    }

    public void setNameIdentifier(SAMLNameIdentifier nameId) throws SAMLException {
        this.nameId = nameId != null ? (SAMLNameIdentifier)nameId.setParent(this) : null;
        this.setDirty(true);
    }

    public Iterator getConfirmationMethods() {
        return this.confirmationMethods.iterator();
    }

    public void setConfirmationMethods(Collection confirmationMethods) {
        this.confirmationMethods.clear();
        if (confirmationMethods != null) {
            Iterator i = confirmationMethods.iterator();
            while (i.hasNext()) {
                this.addConfirmationMethod((String)i.next());
            }
        }
        this.setDirty(true);
    }

    public void addConfirmationMethod(String confirmationMethod) {
        if (XML.isEmpty(confirmationMethod)) {
            throw new IllegalArgumentException("confirmationMethod cannot be null or empty");
        }
        this.confirmationMethods.add(confirmationMethod);
        this.setDirty(true);
    }

    public void removeConfirmationMethod(int index) throws IndexOutOfBoundsException {
        this.confirmationMethods.remove(index);
        this.setDirty(true);
    }

    public Element getConfirmationData() {
        return this.confirmationData;
    }

    public void setConfirmationData(Element confirmationData) {
        if (confirmationData != null && !XML.isElementNamed(confirmationData, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmationData")) {
            throw new IllegalArgumentException("confirmationData must be a saml:SubjectConfirmationData element");
        }
        this.confirmationData = confirmationData;
        this.setDirty(true);
    }

    public Element getKeyInfo() {
        return this.keyInfo != null ? this.keyInfo.getElement() : null;
    }

    public Object getNativeKeyInfo() {
        return this.keyInfo;
    }

    public void setKeyInfo(Object keyInfo) throws SAMLException {
        if (keyInfo != null && !(keyInfo instanceof KeyInfo) && !(keyInfo instanceof Element)) {
            throw new IllegalArgumentException("keyInfo must be a ds:KeyInfo element or a native library object");
        }
        KeyInfo nativeki = null;
        try {
            nativeki = keyInfo instanceof Element ? new KeyInfo((Element)keyInfo, null) : (KeyInfo)keyInfo;
        }
        catch (XMLSecurityException ex) {
            throw new SAMLException("setKeyInfo() caught an XML security exception", (Exception)((Object)ex));
        }
        this.keyInfo = nativeki;
        this.setDirty(true);
    }

    protected Element buildRoot(Document doc, boolean xmlns) {
        Element s = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Subject");
        if (xmlns) {
            s.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return s;
    }

    public Node toDOM(Document doc, boolean xmlns) throws SAMLException {
        super.toDOM(doc, xmlns);
        Element s = (Element)this.root;
        if (this.dirty) {
            if (this.nameId != null) {
                s.appendChild(this.nameId.toDOM(doc, false));
            }
            if (this.confirmationMethods.size() > 0) {
                Element conf = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation");
                Iterator i = this.confirmationMethods.iterator();
                while (i.hasNext()) {
                    conf.appendChild(doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "ConfirmationMethod")).appendChild(doc.createTextNode((String)i.next()));
                }
                if (this.confirmationData != null) {
                    if (this.confirmationData.getOwnerDocument() == doc) {
                        conf.appendChild(this.confirmationData);
                    } else {
                        conf.appendChild(doc.adoptNode(this.confirmationData));
                    }
                }
                if (this.keyInfo != null) {
                    if (this.keyInfo.getElement().getOwnerDocument() == doc) {
                        conf.appendChild(this.keyInfo.getElement());
                    } else {
                        conf.appendChild(doc.adoptNode(this.keyInfo.getElement()));
                    }
                }
                s.appendChild(conf);
            }
            this.setDirty(false);
        } else if (xmlns) {
            s.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (this.nameId == null && (this.confirmationMethods == null || this.confirmationMethods.size() == 0)) {
            throw new MalformedException("Subject is invalid, requires either NameIdentifier or at least one ConfirmationMethod");
        }
        if (this.confirmationData != null && !XML.isElementNamed(this.confirmationData, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmationData")) {
            throw new MalformedException("Subject is invalid, requires that confirmation data be a saml:SubjectConfirmationData element");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLSubject dup = (SAMLSubject)super.clone();
        try {
            if (this.nameId != null) {
                dup.nameId = (SAMLNameIdentifier)((SAMLNameIdentifier)this.nameId.clone()).setParent(dup);
            }
            dup.confirmationMethods = (ArrayList)this.confirmationMethods.clone();
            if (this.confirmationData != null) {
                dup.confirmationData = (Element)this.confirmationData.cloneNode(true);
            }
            if (this.keyInfo != null) {
                dup.keyInfo = new KeyInfo((Element)this.keyInfo.getElement().cloneNode(true), null);
            }
        }
        catch (SAMLException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        catch (XMLSecurityException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        return dup;
    }
}

