/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLQuery;
import org.opensaml.SAMLSubject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class SAMLSubjectQuery
extends SAMLQuery
implements Cloneable {
    protected SAMLSubject subject = null;

    public SAMLSubjectQuery() {
    }

    public SAMLSubjectQuery(SAMLSubject subject) throws SAMLException {
        this.subject = (SAMLSubject)subject.setParent(this);
    }

    public SAMLSubjectQuery(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLSubjectQuery(InputStream in) throws SAMLException {
        this.fromDOM(SAMLSubjectQuery.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        this.subject = (SAMLSubject)new SAMLSubject(XML.getFirstChildElement(e)).setParent(this);
    }

    public SAMLSubject getSubject() {
        return this.subject;
    }

    public void setSubject(SAMLSubject subject) throws SAMLException {
        if (subject == null) {
            throw new IllegalArgumentException("subject cannot be null");
        }
        this.subject = (SAMLSubject)subject.setParent(this);
        this.setDirty(true);
    }

    public void checkValidity() throws SAMLException {
        if (this.subject == null) {
            throw new MalformedException(SAMLException.RESPONDER, "SubjectQuery invalid, requires subject");
        }
    }

    public Node toDOM(Document doc, boolean xmlns) throws SAMLException {
        super.toDOM(doc, xmlns);
        if (this.dirty) {
            ((Element)this.root).appendChild(this.subject.toDOM(doc));
        }
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLSubjectQuery dup = (SAMLSubjectQuery)super.clone();
        try {
            dup.subject = (SAMLSubject)((SAMLSubject)this.subject.clone()).setParent(dup);
        }
        catch (SAMLException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        return dup;
    }
}

