/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.security.KeyStore;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.opensaml.SAMLAssertion;

public class SignatureTest
extends TestCase {
    private String path = "data/org/opensaml/test.jks";
    private String alias = "mykey";
    private char[] password = "opensaml".toCharArray();
    private KeyStore ks = null;
    private String xmlpath = "data/org/opensaml/assertion.xml";
    private String sigalg = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private String digalg = "http://www.w3.org/2000/09/xmldsig#sha1";
    private int count = 1;
    static /* synthetic */ Class class$0;

    public SignatureTest(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.opensaml.SignatureTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Logger.getRootLogger().setLevel(Level.OFF);
        this.ks = KeyStore.getInstance("JKS");
        this.ks.load(new FileInputStream(this.path), this.password);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSignatureLoop() throws Exception {
        theTest t = new theTest();
        long total = 0L;
        int i = 0;
        while (i < this.count) {
            long elapsed = System.currentTimeMillis();
            t.testSignature();
            total = total + System.currentTimeMillis() - elapsed;
            ++i;
        }
    }

    private class theTest {
        private theTest() {
        }

        private void testSignature() throws Exception {
            SAMLAssertion a = new SAMLAssertion(new FileInputStream(SignatureTest.this.xmlpath));
            SignatureTest.assertNotNull((String)"No unsigned SAMLAssertion was generated.", (Object)a);
            a.sign(SignatureTest.this.sigalg, SignatureTest.this.digalg, SignatureTest.this.ks.getKey(SignatureTest.this.alias, SignatureTest.this.password), null);
            String dump = a.toString();
            SAMLAssertion a2 = new SAMLAssertion(new ByteArrayInputStream(dump.getBytes()));
            SignatureTest.assertNotNull((String)"No signed SAMLAssertion was generated", (Object)a2);
            a.verify(SignatureTest.this.ks.getCertificate(SignatureTest.this.alias).getPublicKey());
        }
    }
}

