/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.artifact;

import org.opensaml.SAMLConfig;
import org.opensaml.SAMLIdentifier;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.SAMLArtifactType0001;
import org.opensaml.artifact.SAMLArtifactType0002;
import org.opensaml.artifact.URI;
import org.opensaml.artifact.Util;

public class ArtifactTest {
    private static String providerIdStr = "https://idp.org/SAML";
    private static byte[] handle;
    private static SAMLIdentifier idgen;

    static {
        idgen = SAMLConfig.instance().getDefaultIDProvider();
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            providerIdStr = args[0];
        }
        handle = idgen.generateRandomBytes(20);
        System.out.println("Begin printing.");
        ArtifactTest.printSAMLArtifactType0001();
        ArtifactTest.printSAMLArtifactType0002();
        System.out.println("End printing.");
    }

    static void printSAMLArtifactType0001() throws Exception {
        byte[] sourceId = idgen.generateRandomBytes(20);
        SAMLArtifactType0001 artifact = new SAMLArtifactType0001(sourceId, handle);
        ArtifactTest.printResults(artifact);
        sourceId = Util.generateSourceId(providerIdStr);
        artifact = new SAMLArtifactType0001(sourceId, handle);
        ArtifactTest.printResults(artifact, providerIdStr);
    }

    static void printSAMLArtifactType0002() throws Exception {
        URI providerId = new URI(providerIdStr);
        SAMLArtifactType0002 artifact = new SAMLArtifactType0002(handle, providerId);
        ArtifactTest.printResults(artifact, providerId);
    }

    static void printResults(Artifact artifact) throws Exception {
        ArtifactTest.printResults(artifact, null);
    }

    static void printResults(Artifact artifact, Object o) throws Exception {
        if (artifact == null) {
            return;
        }
        Artifact.TypeCode typeCode = artifact.getTypeCode();
        String msg = "Artifact Type " + typeCode.toString();
        msg = String.valueOf(msg) + " (size = " + artifact.size() + ")";
        System.out.println(msg);
        if (o != null) {
            System.out.println("URI:     " + o.toString());
        } else {
            System.out.println("URI:     NONE");
        }
        System.out.println("Hex:     " + artifact.toString());
        System.out.println("Base64:  " + artifact.encode());
        System.out.println("         ----------------------------------------------------------------------");
        System.out.println("         1234567890123456789012345678901234567890123456789012345678901234567890");
        System.out.println("                  1         2         3         4         5         6         7");
        System.out.println("         ----------------------------------------------------------------------");
    }
}

