/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.artifact;

import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.ArtifactParserException;
import org.opensaml.artifact.InvalidArgumentException;
import org.opensaml.artifact.NullArgumentException;
import org.opensaml.artifact.SAMLArtifactChecking;
import org.opensaml.artifact.TwoByteSequence;
import org.opensaml.artifact.Util;

public abstract class SAMLArtifact
implements Artifact,
SAMLArtifactChecking {
    protected Artifact.TypeCode typeCode = null;
    protected Artifact.RemainingArtifact remainingArtifact = null;

    protected SAMLArtifact() {
    }

    public Artifact.TypeCode getTypeCode() {
        return this.typeCode;
    }

    public Artifact.RemainingArtifact getRemainingArtifact() {
        return this.remainingArtifact;
    }

    public int size() {
        return this.typeCode.size() + this.remainingArtifact.size();
    }

    public byte[] getBytes() {
        byte[] bytes0 = this.typeCode.getBytes();
        byte[] bytes1 = this.remainingArtifact.getBytes();
        return Util.concat(bytes0, bytes1);
    }

    public String encode() {
        return new String(Base64.encodeBase64((byte[])this.getBytes()));
    }

    public String toString() {
        return new String(Hex.encodeHex((byte[])this.getBytes()));
    }

    public boolean equals(Object o) {
        if (!(o instanceof SAMLArtifact)) {
            return false;
        }
        SAMLArtifact artifact = (SAMLArtifact)o;
        return Arrays.equals(this.getBytes(), artifact.getBytes());
    }

    public int hashCode() {
        return this.typeCode.hashCode() & this.remainingArtifact.hashCode();
    }

    public static Artifact.TypeCode getTypeCode(String s) {
        byte[] bytes = Base64.decodeBase64((byte[])s.getBytes());
        return new TypeCode(bytes[0], bytes[1]);
    }

    public static void checkHandleArg(byte[] handle) {
        SAMLArtifact.checkNullArg(handle);
        int n = handle.length;
        if (n != 20) {
            throw new InvalidArgumentException(n, 20);
        }
    }

    public static void checkIdentifierArg(byte[] identifier) {
        SAMLArtifact.checkNullArg(identifier);
        int n = identifier.length;
        if (n != 20) {
            throw new InvalidArgumentException(n, 20);
        }
    }

    public static void checkNullArg(Object obj) {
        if (obj == null) {
            throw new NullArgumentException();
        }
    }

    public static abstract class Parser
    implements Artifact.Parser {
    }

    public static abstract class RemainingArtifact
    implements Artifact.RemainingArtifact {
        public String toString() {
            return new String(Hex.encodeHex((byte[])this.getBytes()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Artifact.RemainingArtifact)) {
                return false;
            }
            Artifact.RemainingArtifact ra = (Artifact.RemainingArtifact)o;
            return Arrays.equals(this.getBytes(), ra.getBytes());
        }
    }

    public static final class TypeCode
    extends TwoByteSequence
    implements Artifact.TypeCode {
        private static final String CLASS_NAME_PREFIX = "org.opensaml.artifact.SAMLArtifactType";
        private static final String CLASS_NAME_SUFFIX = "$Parser";

        public TypeCode(byte b0, byte b1) {
            super(b0, b1);
        }

        public TypeCode(short tc) {
            super(tc);
        }

        public String toString() {
            return "0x" + super.toString();
        }

        public Artifact.Parser getParser() throws ArtifactParserException {
            Artifact.Parser parser;
            String typeCodeStr = super.toString();
            String className = CLASS_NAME_PREFIX + typeCodeStr + CLASS_NAME_SUFFIX;
            try {
                parser = (Artifact.Parser)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                throw new ArtifactParserException(e.getMessage());
            }
            return parser;
        }
    }
}

