/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.artifact;

import java.util.Arrays;
import junit.textui.TestRunner;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.ArtifactTestCase;
import org.opensaml.artifact.SAMLArtifactType0002;
import org.opensaml.artifact.URI;
import org.opensaml.artifact.Util;

public class SAMLArtifactType0002Test
extends ArtifactTestCase {
    private static String providerIdStr = "https://idp.org/SAML";
    static /* synthetic */ Class class$0;

    public SAMLArtifactType0002Test() {
    }

    public SAMLArtifactType0002Test(String arg) {
        super(arg);
    }

    public static void main(String[] args) {
        Class<?> clazz;
        if (args.length > 0) {
            providerIdStr = args[0];
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.opensaml.artifact.SAMLArtifactType0002Test");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSAMLArtifactType0002() throws Exception {
        URI providerId = new URI(providerIdStr);
        SAMLArtifactType0002 artifact = new SAMLArtifactType0002(providerId);
        Artifact tempArtifact = ArtifactTestCase.duplicate(artifact);
        byte[] handle1 = artifact.getAssertionHandle();
        byte[] handle2 = ((SAMLArtifactType0002)tempArtifact).getAssertionHandle();
        SAMLArtifactType0002Test.assertTrue((String)"Assertion handles not equal", (boolean)Arrays.equals(handle1, handle2));
        URI location1 = artifact.getSourceLocation();
        URI location2 = ((SAMLArtifactType0002)tempArtifact).getSourceLocation();
        SAMLArtifactType0002Test.assertTrue((String)"Source locations not equal", (boolean)location1.equals(location2));
        byte[] assertionHandle = Util.concat(handle1, handle2);
        try {
            artifact = new SAMLArtifactType0002(assertionHandle, location1);
            SAMLArtifactType0002Test.assertTrue((String)"Invalid assertionHandle did not throw exception", (boolean)true);
        }
        catch (Exception e) {
            SAMLArtifactType0002Test.assertTrue((String)"Wrong exception type for invalid assertionHandle", (boolean)(e instanceof IllegalArgumentException));
        }
    }
}

