/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.artifact;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.opensaml.artifact.URI;

public final class Util {
    private static MessageDigest messageDigest = null;

    private Util() {
    }

    public static byte[] generateSourceId(MessageDigest md, String s) {
        if (md == null || s == null) {
            return null;
        }
        return md.digest(s.getBytes());
    }

    public static byte[] generateSourceId(String s) throws NoSuchAlgorithmException {
        if (messageDigest == null) {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        return Util.generateSourceId(messageDigest, s);
    }

    public static byte[] generateSourceId(URI providerId) throws NoSuchAlgorithmException {
        if (providerId == null) {
            return null;
        }
        return Util.generateSourceId(providerId.toString());
    }

    public static byte[] concat(byte[] left_bytes, byte[] right_bytes) {
        if (left_bytes == null) {
            return right_bytes;
        }
        if (right_bytes == null) {
            return left_bytes;
        }
        byte[] bytes = new byte[left_bytes.length + right_bytes.length];
        System.arraycopy(left_bytes, 0, bytes, 0, left_bytes.length);
        System.arraycopy(right_bytes, 0, bytes, left_bytes.length, right_bytes.length);
        return bytes;
    }
}

