/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.provider;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.opensaml.ExpiredAssertionException;
import org.opensaml.FatalProfileException;
import org.opensaml.ReplayCache;
import org.opensaml.ReplayedAssertionException;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLBrowserProfile;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLException;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;
import org.opensaml.UnsupportedProfileException;
import org.opensaml.XML;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.ArtifactParseException;
import org.opensaml.artifact.ArtifactParserException;
import org.opensaml.artifact.SAMLArtifact;
import org.w3c.dom.Element;

public class BrowserProfileProvider
implements SAMLBrowserProfile {
    private static Logger log = Logger.getLogger((String)BrowserProfileProvider.class.getName());
    private static int skew = 1000 * SAMLConfig.instance().getIntProperty("org.opensaml.clock-skew");

    public BrowserProfileProvider(Element e) {
    }

    public SAMLBrowserProfile.BrowserProfileRequest receive(HttpServletRequest requestContext) throws UnsupportedProfileException {
        SAMLBrowserProfile.BrowserProfileRequest bpr = new SAMLBrowserProfile.BrowserProfileRequest();
        bpr.SAMLResponse = requestContext.getParameter("SAMLResponse");
        if (bpr.SAMLResponse == null) {
            bpr.SAMLArt = requestContext.getParameterValues("SAMLart");
            if (bpr.SAMLArt == null || bpr.SAMLArt.length == 0) {
                throw new UnsupportedProfileException("no SAMLResponse or SAMLart parameters supplied in HTTP request");
            }
        }
        bpr.TARGET = requestContext.getParameter("TARGET");
        return bpr;
    }

    public SAMLBrowserProfile.BrowserProfileResponse receive(StringBuffer issuer, SAMLBrowserProfile.BrowserProfileRequest requestContext, String recipient, ReplayCache replayCache, SAMLBrowserProfile.ArtifactMapper artifactMapper, int minorVersion) throws SAMLException {
        Iterator assertions;
        boolean wasPost;
        SAMLAuthenticationStatement authnStatement;
        SAMLAssertion assertion;
        SAMLResponse response;
        long now;
        block32: {
            now = System.currentTimeMillis();
            response = null;
            assertion = null;
            authnStatement = null;
            wasPost = true;
            if (requestContext.SAMLResponse != null) {
                response = new SAMLResponse(new ByteArrayInputStream(Base64.decodeBase64((byte[])requestContext.SAMLResponse.getBytes())), minorVersion);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("decoded SAML response:\n" + response.toString()));
                }
                try {
                    if (XML.isEmpty(recipient) || !XML.safeCompare(recipient, response.getRecipient())) {
                        throw new FatalProfileException("detected recipient mismatch in POST profile response");
                    }
                    if (response.getIssueInstant().getTime() < now - (long)(2 * skew)) {
                        throw new ExpiredAssertionException("detected expired POST profile response");
                    }
                    if (!response.isSigned()) {
                        throw new FatalProfileException("detected unsigned POST profile response");
                    }
                    break block32;
                }
                catch (SAMLException e) {
                    Iterator assertions2;
                    if (issuer != null && (assertions2 = response.getAssertions()).hasNext()) {
                        issuer.append(((SAMLAssertion)assertions2.next()).getIssuer());
                    }
                    throw e;
                }
            }
            if (requestContext.SAMLArt == null || requestContext.SAMLArt.length == 0) {
                throw new FatalProfileException("no SAMLResponse or SAMLart parameters supplied");
            }
            if (artifactMapper == null) {
                throw new FatalProfileException("support of artifact profile requires ArtifactMapper interface object");
            }
            Artifact[] artifacts = new Artifact[requestContext.SAMLArt.length];
            for (int index = 0; index < requestContext.SAMLArt.length; ++index) {
                try {
                    log.debug((Object)("processing encoded artifact (" + requestContext.SAMLArt[index] + ")"));
                    if (replayCache != null) {
                        String key = "A_" + requestContext.SAMLArt[index];
                        if (!replayCache.check(key, new Date(System.currentTimeMillis() + (long)(2 * skew)))) {
                            throw new ReplayedAssertionException("rejecting replayed artifact (" + requestContext.SAMLArt[index] + ")");
                        }
                    } else {
                        log.warn((Object)"replay cache was not provided, this is a potential security risk!");
                    }
                    artifacts[index] = SAMLArtifact.getTypeCode(requestContext.SAMLArt[index]).getParser().parse(requestContext.SAMLArt[index]);
                    continue;
                }
                catch (ArtifactParseException e) {
                    log.error((Object)("invalid artifact (" + requestContext.SAMLArt[index] + ")"));
                    throw new FatalProfileException("unable to parse artifact");
                }
                catch (ArtifactParserException e) {
                    log.error((Object)("unrecognized artifact type (" + requestContext.SAMLArt[index] + ")"));
                    throw new FatalProfileException("unable to build parser for received artifact, unknown type");
                }
            }
            SAMLRequest request = new SAMLRequest(Arrays.asList(artifacts));
            request.setMinorVersion(minorVersion);
            response = artifactMapper.resolve(request);
            wasPost = false;
        }
        try {
            boolean bExpired = false;
            assertions = response.getAssertions();
            while (assertion == null && assertions.hasNext()) {
                bExpired = false;
                SAMLAssertion a = (SAMLAssertion)assertions.next();
                Date notBefore = a.getNotBefore();
                Date notOnOrAfter = a.getNotOnOrAfter();
                if (notBefore == null || notOnOrAfter == null) {
                    log.debug((Object)"skipping assertion without time conditions...");
                    continue;
                }
                if (now + (long)skew < notBefore.getTime()) {
                    bExpired = true;
                    log.debug((Object)"skipping assertion that's not yet valid...");
                    continue;
                }
                if (notOnOrAfter.getTime() <= now - (long)skew) {
                    bExpired = true;
                    log.debug((Object)"skipping expired assertion...");
                    continue;
                }
                Iterator statements = a.getStatements();
                block9: while (authnStatement == null && statements.hasNext()) {
                    SAMLStatement s = (SAMLStatement)statements.next();
                    if (!(s instanceof SAMLAuthenticationStatement)) continue;
                    SAMLAuthenticationStatement as = (SAMLAuthenticationStatement)s;
                    SAMLSubject subject = as.getSubject();
                    Iterator methods = subject.getConfirmationMethods();
                    while (methods.hasNext()) {
                        String m = (String)methods.next();
                        if ((!wasPost || !m.equals("urn:oasis:names:tc:SAML:1.0:cm:bearer")) && !m.equals("urn:oasis:names:tc:SAML:1.0:cm:artifact") && !m.equals("urn:oasis:names:tc:SAML:1.0:cm:artifact-01")) continue;
                        authnStatement = as;
                        assertion = a;
                        continue block9;
                    }
                }
            }
            if (authnStatement == null) {
                if (bExpired && response.getAssertions().hasNext()) {
                    throw new ExpiredAssertionException("unable to accept assertion because of clock skew");
                }
                throw new FatalProfileException("unable to locate a valid authentication statement");
            }
            if (wasPost) {
                if (replayCache != null) {
                    String key = "P_" + assertion.getId();
                    if (!replayCache.check(key, assertion.getNotOnOrAfter())) {
                        throw new ReplayedAssertionException("rejecting replayed assertion ID (" + assertion.getId() + ")");
                    }
                } else {
                    log.warn((Object)"replay cache was not provided, this is a serious security risk!");
                }
            }
        }
        catch (SAMLException e) {
            if (issuer != null && (assertions = response.getAssertions()).hasNext()) {
                issuer.append(((SAMLAssertion)assertions.next()).getIssuer());
            }
            throw e;
        }
        SAMLBrowserProfile.BrowserProfileResponse profileResponse = new SAMLBrowserProfile.BrowserProfileResponse();
        profileResponse.response = response;
        profileResponse.assertion = assertion;
        profileResponse.authnStatement = authnStatement;
        profileResponse.TARGET = requestContext.TARGET;
        return profileResponse;
    }
}

