/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.provider;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.ProviderException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.opensaml.BindingException;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLException;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLSOAPHTTPBinding;
import org.opensaml.SOAPBinding;
import org.opensaml.SOAPException;
import org.opensaml.XML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SOAPHTTPBindingProvider
extends SOAPBinding
implements SAMLSOAPHTTPBinding {
    private static SAMLConfig config = SAMLConfig.instance();
    private static SSLContext sslctx = null;
    private Logger log = Logger.getLogger((String)SOAPHTTPBindingProvider.class.getName());
    private Map httpHooks = Collections.synchronizedMap(new HashMap(4));

    public SOAPHTTPBindingProvider(String binding, Element e) throws SAMLException {
        if (!binding.equals("urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding")) {
            throw new SAMLException("SOAPHTTPBindingProvider does not support requested binding (" + binding + ")");
        }
    }

    public void addHook(SAMLSOAPHTTPBinding.HTTPHook h) {
        this.addHook(h, null);
    }

    public void addHook(SAMLSOAPHTTPBinding.HTTPHook h, Object globalCtx) {
        this.httpHooks.put(h, globalCtx);
    }

    public SAMLResponse send(String endpoint, SAMLRequest request, Object callCtx) throws SAMLException {
        try {
            NDC.push((String)"send");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Preparing to send the following SAML request to " + endpoint + "\n" + request.toString()));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Wrapping request to " + endpoint + " in a SOAP envelope"));
            }
            Element envelope = this.sendRequest(request, callCtx);
            this.log.debug((Object)("Setting connection properties for connecting to " + endpoint));
            URLConnection conn = new URL(endpoint).openConnection();
            conn.setAllowUserInteraction(false);
            conn.setDoOutput(true);
            ((HttpURLConnection)conn).setInstanceFollowRedirects(false);
            ((HttpURLConnection)conn).setRequestMethod("POST");
            ((HttpURLConnection)conn).setRequestProperty("Content-Type", "text/xml; charset=UTF-8");
            ((HttpURLConnection)conn).setRequestProperty("SOAPAction", "http://www.oasis-open.org/committees/security");
            if (conn instanceof HttpsURLConnection && sslctx != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Connection to " + endpoint + " is an HTTPS connection, setting default SSL socket factory."));
                }
                ((HttpsURLConnection)conn).setSSLSocketFactory(sslctx.getSocketFactory());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Connection to " + endpoint + " set up, running " + this.httpHooks.size() + " outgoing client-side HTTP hooks."));
            }
            Iterator hooks = this.httpHooks.entrySet().iterator();
            while (hooks.hasNext()) {
                Map.Entry h = hooks.next();
                if (((SAMLSOAPHTTPBinding.HTTPHook)h.getKey()).outgoing((HttpURLConnection)conn, h.getValue(), callCtx)) continue;
                this.log.warn((Object)"HTTP processing hook returned false, aborting outgoing request");
                throw new BindingException(SAMLException.REQUESTER, "SOAPHTTPBindingProvider.send() HTTP processing hook returned false, aborted outgoing request");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Connecting to " + endpoint));
            }
            conn.connect();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Canonicalizing SOAP envelope-wrapped request and sending it to " + endpoint));
            }
            Canonicalizer c = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            conn.getOutputStream().write(c.canonicalizeSubtree((Node)envelope));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Message sent to " + endpoint + ", running " + this.httpHooks.size() + " incoming client-side HTTP hooks."));
            }
            Iterator hooks2 = this.httpHooks.entrySet().iterator();
            while (hooks2.hasNext()) {
                Map.Entry h = hooks2.next();
                if (((SAMLSOAPHTTPBinding.HTTPHook)h.getKey()).incoming((HttpURLConnection)conn, h.getValue(), callCtx)) continue;
                this.log.warn((Object)"HTTP processing hook returned false, aborting incoming response");
                throw new BindingException("SOAPHTTPBindingProvider.send() HTTP processing hook returned false, aborted incoming response");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Starting to process response from " + endpoint));
            }
            String content_type = ((HttpURLConnection)conn).getContentType();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Response content type is " + content_type));
            }
            if (content_type == null || !content_type.startsWith("text/xml")) {
                this.log.error((Object)("received an invalid content type in the response (" + (content_type != null ? content_type : "none") + "), with the following content:"));
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                this.log.error((Object)reader.readLine());
                throw new BindingException("SOAPHTTPBindingProvider.send() detected an invalid content type (" + (content_type != null ? content_type : "none") + ") in the response.");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Unmarshalling response from " + endpoint + " into a DOM document."));
            }
            envelope = XML.parserPool.parse(new InputSource(conn.getInputStream()), request.getMinorVersion() > 0 ? XML.parserPool.getSchemaSAML11() : XML.parserPool.getSchemaSAML10()).getDocumentElement();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Parsing and verifying SOAP response and retrieving SAML response from it.");
            }
            SAMLResponse ret = this.recvResponse(envelope, callCtx);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Received the following SAML response as the response to the request to " + endpoint + "\n" + ret.toString()));
            }
            if (!ret.getInResponseTo().equals(request.getId())) {
                this.log.error((Object)("Unable to match SAML InResponseTo value to request made to " + endpoint));
                throw new BindingException("SOAPHTTPBindingProvider.send() unable to match SAML InResponseTo value to request");
            }
            SAMLResponse sAMLResponse = ret;
            return sAMLResponse;
        }
        catch (MalformedURLException ex) {
            throw new SAMLException("SAMLSOAPBinding.send() detected a malformed URL in the binding provided", (Exception)ex);
        }
        catch (SAXException ex) {
            throw new SAMLException("SAMLSOAPBinding.send() caught an XML exception while parsing the response", (Exception)ex);
        }
        catch (InvalidCanonicalizerException ex) {
            throw new SAMLException("SAMLSOAPBinding.send() caught a C14N exception while serializing the request", (Exception)((Object)ex));
        }
        catch (CanonicalizationException ex) {
            throw new SAMLException("SAMLSOAPBinding.send() caught a C14N exception while serializing the request", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SAMLException("SAMLSOAPBinding.send() caught an I/O exception", (Exception)ex);
        }
        finally {
            NDC.pop();
        }
    }

    public SAMLRequest receive(Object reqContext, Object callCtx, int minor) throws SAMLException {
        HttpServletRequest req = (HttpServletRequest)reqContext;
        if (!req.getMethod().equals("POST") || !req.getContentType().startsWith("text/xml")) {
            throw new BindingException(SAMLException.REQUESTER, "SOAPHTTPBindingProvider.receive() found bad HTTP method or content type");
        }
        Iterator hooks = this.httpHooks.entrySet().iterator();
        while (hooks.hasNext()) {
            Map.Entry h = hooks.next();
            if (((SAMLSOAPHTTPBinding.HTTPHook)h.getKey()).incoming(req, h.getValue(), callCtx)) continue;
            this.log.warn((Object)"HTTP processing hook returned false, aborting incoming request");
            throw new BindingException(SAMLException.REQUESTER, "SOAPHTTPBindingProvider.recvRequest() HTTP processing hook returned false, aborted incoming request");
        }
        try {
            return this.recvRequest(XML.parserPool.parse(new InputSource((InputStream)req.getInputStream()), minor > 0 ? XML.parserPool.getSchemaSAML11() : XML.parserPool.getSchemaSAML10()).getDocumentElement(), callCtx);
        }
        catch (SAXException e) {
            throw new SOAPException(SOAPException.CLIENT, "SOAPHTTPBindingProvider.receive() detected an XML parsing error: " + e.getMessage());
        }
        catch (IOException e) {
            throw new SOAPException(SOAPException.SERVER, "SOAPHTTPBindingProvider.receive() detected an I/O error: " + e.getMessage());
        }
    }

    public void respond(Object respContext, SAMLResponse response, SAMLException e, Object callCtx) throws SAMLException {
        HttpServletResponse resp = (HttpServletResponse)respContext;
        try {
            Element env = this.sendResponse(response, e, callCtx);
            Iterator hooks = this.httpHooks.entrySet().iterator();
            while (hooks.hasNext()) {
                Map.Entry h = hooks.next();
                if (((SAMLSOAPHTTPBinding.HTTPHook)h.getKey()).outgoing(resp, h.getValue(), callCtx)) continue;
                this.log.warn((Object)"HTTP processing hook returned false, aborting outgoing response");
                throw new BindingException("SOAPHTTPBindingProvider.respond() HTTP processing hook returned false, aborted outgoing response");
            }
            Canonicalizer c = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            if (e != null) {
                resp.setStatus(500);
            }
            resp.setContentType("text/xml; charset=UTF-8");
            resp.getOutputStream().write(c.canonicalizeSubtree((Node)env));
        }
        catch (InvalidCanonicalizerException ex) {
            ex.printStackTrace();
            try {
                resp.sendError(500, "SAMLSOAPBinding.respond() unable to serialize XML document instance");
            }
            catch (IOException e1) {
                throw new SAMLException("SAMLSOAPBinding.respond() caught I/O exception while sending error response", (Exception)e1);
            }
        }
        catch (CanonicalizationException ex) {
            ex.printStackTrace();
            try {
                resp.sendError(500, "SAMLSOAPBinding.respond() unable to serialize XML document instance");
            }
            catch (IOException e1) {
                throw new SAMLException("SAMLSOAPBinding.respond() caught I/O exception while sending error response", (Exception)e1);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new SAMLException("SAMLSOAPBinding.respond() caught I/O exception while sending error response", (Exception)ex);
        }
    }

    public SAMLResponse send(String endpoint, SAMLRequest request) throws SAMLException {
        return this.send(endpoint, request, null);
    }

    public SAMLRequest receive(Object reqContext, int minor) throws SAMLException {
        return this.receive(reqContext, null, minor);
    }

    public void respond(Object respContext, SAMLResponse response, SAMLException e) throws SAMLException {
        this.respond(respContext, response, e, null);
    }

    static {
        try {
            String ks_path = config.getProperty("org.opensaml.ssl.keystore");
            String ts_path = config.getProperty("org.opensaml.ssl.truststore");
            if (ks_path != null || ts_path != null) {
                KeyManagerFactory kmf = null;
                TrustManagerFactory tmf = null;
                if (ks_path != null) {
                    String ks_pwd = config.getProperty("org.opensaml.ssl.keystore-pwd");
                    String key_pwd = config.getProperty("org.opensaml.ssl.key-pwd");
                    String ks_type = config.getProperty("org.opensaml.ssl.keystore-type");
                    KeyStore ks = KeyStore.getInstance(ks_type != null ? ks_type : "JKS");
                    ks.load(new FileInputStream(ks_path), ks_pwd != null ? ks_pwd.toCharArray() : null);
                    kmf = KeyManagerFactory.getInstance("SunX509");
                    kmf.init(ks, key_pwd != null ? key_pwd.toCharArray() : null);
                }
                if (ts_path != null) {
                    String ts_pwd = config.getProperty("org.opensaml.ssl.truststore-pwd");
                    String ts_type = config.getProperty("org.opensaml.ssl.truststore-type");
                    KeyStore ts = KeyStore.getInstance(ts_type != null ? ts_type : "JKS");
                    ts.load(new FileInputStream(ts_path), ts_pwd != null ? ts_pwd.toCharArray() : null);
                    tmf = TrustManagerFactory.getInstance("SunX509");
                    tmf.init(ts);
                }
                sslctx = SSLContext.getInstance("SSL");
                sslctx.init(kmf != null ? kmf.getKeyManagers() : null, tmf != null ? tmf.getTrustManagers() : null, null);
            }
        }
        catch (IOException e) {
            throw new ProviderException("SOAPHTTPBindingProvider caught I/O error initializing SSL context: " + e.getMessage());
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException("SOAPHTTPBindingProvider caught security exception initializing SSL context: " + e.getMessage());
        }
    }
}

