/*
 * Decompiled with CFR 0.152.
 */
package com.activee.ant.bpr.tasks;

import com.activee.ant.bpr.tasks.AeCreateCatalogTask;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;

public class AeCatalogBuilder {
    private List mCatalogEntries;
    private boolean mReplaceExisting;

    public AeCatalogBuilder(List aEntries, boolean aReplaceExisting) {
        this.mCatalogEntries = aEntries;
        this.mReplaceExisting = aReplaceExisting;
    }

    public InputStream build() throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.print("<catalog xmlns='http://schemas.active-endpoints.com/catalog/2006/07/catalog.xsd'");
        if (this.mReplaceExisting) {
            writer.print(" replace.existing=\"true\"");
        }
        writer.println(">");
        Iterator iter = this.mCatalogEntries.iterator();
        while (iter.hasNext()) {
            AeCreateCatalogTask.CatalogEntry entry = (AeCreateCatalogTask.CatalogEntry)iter.next();
            writer.print("   <");
            writer.print(entry.getTagName());
            writer.print(" location=\"");
            writer.print(entry.getLocation());
            writer.print("\" classpath=\"");
            writer.print(entry.getClasspath());
            if (entry.includeTypeURI()) {
                writer.print("\" typeURI=\"");
                writer.print(entry.getTypeURI());
            }
            writer.println("\" />");
        }
        writer.println("</catalog>");
        writer.close();
        return new ByteArrayInputStream(sw.toString().getBytes("UTF-8"));
    }
}

