/*
 * Decompiled with CFR 0.152.
 */
package com.activee.ant.bpr.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;

public class AeCatalogInserter {
    private String mBprFilename;
    private String mCatalogFilename;

    public AeCatalogInserter(String aBprFilename, String aCatalogFilename) {
        this.mBprFilename = aBprFilename;
        this.mCatalogFilename = aCatalogFilename;
    }

    /*
     * Loose catch block
     */
    public void insert(InputStream aInputStream) throws Exception {
        block20: {
            Exception e32;
            File tmpFile;
            ZipOutputStream jarOS;
            JarFile jarFile;
            block18: {
                jarFile = null;
                jarOS = null;
                tmpFile = null;
                File bprFile = new File(this.mBprFilename);
                tmpFile = File.createTempFile("bpr", ".tmp");
                jarFile = new JarFile(this.mBprFilename);
                Manifest mf = jarFile.getManifest();
                jarOS = mf == null ? new JarOutputStream(new FileOutputStream(tmpFile)) : new JarOutputStream((OutputStream)new FileOutputStream(tmpFile), mf);
                Enumeration<JarEntry> e2 = jarFile.entries();
                while (e2.hasMoreElements()) {
                    JarEntry entry = e2.nextElement();
                    if (this.skipEntry(entry)) continue;
                    InputStream is = jarFile.getInputStream(entry);
                    this.storeEntryInJar(entry, is, (JarOutputStream)jarOS);
                }
                JarEntry entry = new JarEntry(this.mCatalogFilename);
                this.storeEntryInJar(entry, aInputStream, (JarOutputStream)jarOS);
                jarFile.close();
                jarFile = null;
                jarOS.close();
                jarOS = null;
                if (bprFile.exists() && !bprFile.delete()) {
                    throw new Exception("Failed to delete original BPR file.");
                }
                if (!this.renameFile(tmpFile, bprFile)) {
                    throw new Exception("Failed to rename temporary BPR file.");
                }
                Object var11_11 = null;
                if (jarOS == null) break block18;
                try {
                    jarOS.close();
                }
                catch (Exception e32) {
                    // empty catch block
                }
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Exception e32) {
                    // empty catch block
                }
            }
            if (tmpFile != null && tmpFile.exists()) {
                tmpFile.delete();
            }
            break block20;
            {
                catch (Exception e4) {
                    throw e4;
                }
            }
            catch (Throwable throwable) {
                Exception e32;
                Object var11_12 = null;
                if (jarOS != null) {
                    try {
                        jarOS.close();
                    }
                    catch (Exception e32) {
                        // empty catch block
                    }
                }
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Exception e32) {
                        // empty catch block
                    }
                }
                if (tmpFile != null && tmpFile.exists()) {
                    tmpFile.delete();
                }
                throw throwable;
            }
        }
    }

    private boolean renameFile(File aTempFile, File aBprFile) throws Exception {
        if (this.copyFile(aTempFile, aBprFile)) {
            return aTempFile.delete();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyFile(File aTempFile, File aBprFile) throws FileNotFoundException, IOException {
        boolean bl;
        FileInputStream srcStream = null;
        FileOutputStream destStream = null;
        try {
            int count;
            srcStream = new FileInputStream(aTempFile);
            destStream = new FileOutputStream(aBprFile);
            byte[] buffer = new byte[2048];
            while ((count = ((InputStream)srcStream).read(buffer)) != -1) {
                ((OutputStream)destStream).write(buffer, 0, count);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            AeCatalogInserter.close(srcStream);
            AeCatalogInserter.close(destStream);
            throw throwable;
        }
        AeCatalogInserter.close(srcStream);
        AeCatalogInserter.close(destStream);
        return bl;
    }

    private boolean skipEntry(JarEntry aEntry) {
        if ("META-INF/MANIFEST.MF".equalsIgnoreCase(aEntry.getName())) {
            return true;
        }
        return this.mCatalogFilename.equalsIgnoreCase(aEntry.getName());
    }

    /*
     * Loose catch block
     */
    public void storeEntryInJar(JarEntry aEntry, InputStream aInputStream, JarOutputStream aJarOutputStream) throws IOException {
        block9: {
            aJarOutputStream.putNextEntry(aEntry);
            byte[] buff = new byte[2048];
            int bytes = -1;
            while ((bytes = aInputStream.read(buff)) != -1) {
                aJarOutputStream.write(buff, 0, bytes);
            }
            Object var7_7 = null;
            if (aInputStream == null) break block9;
            try {
                aInputStream.close();
                break block9;
            }
            catch (Exception e) {
                // empty catch block
            }
            {
                break block9;
                catch (IOException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (aInputStream != null) {
                    try {
                        aInputStream.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                aJarOutputStream.closeEntry();
                throw throwable;
            }
        }
        aJarOutputStream.closeEntry();
    }

    private static void close(InputStream aIn) {
        if (aIn != null) {
            try {
                aIn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void close(OutputStream aIn) {
        if (aIn != null) {
            try {
                aIn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

