/*
 * Decompiled with CFR 0.152.
 */
package com.activee.ant.bpr.tasks;

import com.activee.ant.AeMessages;
import com.activee.ant.bpr.tasks.AeCatalogBuilder;
import com.activee.ant.bpr.tasks.AeCatalogInserter;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class AeCreateCatalogTask
extends Task {
    protected static String MISSING_FILE_ATTR_ERRMSG = AeMessages.getString("AeCreateCatalogTask.ERROR_0");
    private static final String CATALOG_FILE = "META-INF/catalog.xml";
    private String mBprFilename;
    private List mEntries;
    private boolean mReplaceExisting;

    public AeCreateCatalogTask() {
        this.setEntries(new ArrayList());
    }

    public void execute() {
        try {
            if (this.getBprFilename() == null) {
                throw new BuildException(MISSING_FILE_ATTR_ERRMSG, this.getLocation());
            }
            System.out.println(this.getStartMessage());
            AeCatalogBuilder builder = new AeCatalogBuilder(this.getEntries(), this.isReplaceExisting());
            AeCatalogInserter inserter = new AeCatalogInserter(this.getBprFilename(), this.getCatalogFilename());
            inserter.insert(builder.build());
        }
        catch (BuildException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    protected String getCatalogFilename() {
        return CATALOG_FILE;
    }

    public boolean isReplaceExisting() {
        return this.mReplaceExisting;
    }

    public void setReplaceExisting(boolean aReplaceExisting) {
        this.mReplaceExisting = aReplaceExisting;
    }

    public void setFile(String aBprFilename) {
        this.setBprFilename(aBprFilename);
    }

    public void addWSDLEntry(WSDLEntry aEntry) {
        this.getEntries().add(aEntry);
    }

    public void addSchemaEntry(SchemaEntry aEntry) {
        this.getEntries().add(aEntry);
    }

    public void addOtherEntry(OtherEntry aEntry) {
        this.getEntries().add(aEntry);
    }

    protected String getStartMessage() {
        StringBuffer buff = new StringBuffer();
        buff.append("Adding " + this.getCatalogFilename() + " with ");
        buff.append(this.getEntries().size());
        buff.append(" entries to BPR file '");
        buff.append(this.getBprFilename());
        buff.append("'.");
        return buff.toString();
    }

    protected void setBprFilename(String bprFilename) {
        this.mBprFilename = bprFilename;
    }

    protected String getBprFilename() {
        return this.mBprFilename;
    }

    protected void setEntries(List entries) {
        this.mEntries = entries;
    }

    protected List getEntries() {
        return this.mEntries;
    }

    public static class OtherEntry
    extends CatalogEntry {
        private String mTypeURI;

        public String getTagName() {
            return "otherEntry";
        }

        public String getTypeURI() {
            return this.mTypeURI;
        }

        public void setTypeURI(String aTypeURI) {
            this.mTypeURI = aTypeURI;
        }

        public boolean includeTypeURI() {
            return true;
        }
    }

    public static class SchemaEntry
    extends CatalogEntry {
        public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

        public String getTagName() {
            return "schemaEntry";
        }

        public String getTypeURI() {
            return W3C_XML_SCHEMA;
        }
    }

    public static class WSDLEntry
    extends CatalogEntry {
        public static final String WSDL_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";

        public String getTagName() {
            return "wsdlEntry";
        }

        public String getTypeURI() {
            return WSDL_NAMESPACE;
        }
    }

    public static abstract class CatalogEntry {
        private String mLocation;
        private String mClasspath;

        public abstract String getTagName();

        public abstract String getTypeURI();

        public boolean includeTypeURI() {
            return false;
        }

        public String getLocation() {
            return this.mLocation;
        }

        public String getClasspath() {
            return this.mClasspath;
        }

        public void setLocation(String aLocation) {
            this.mLocation = aLocation;
        }

        public void setClasspath(String aClasspath) {
            this.mClasspath = aClasspath;
        }
    }
}

