/*
 * Decompiled with CFR 0.152.
 */
package com.activee.ant.bpr.tasks;

import com.activee.ant.AeMessages;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.URL;
import java.util.Properties;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import sun.misc.BASE64Encoder;

public class AeDeployBPRTask
extends Task {
    private static final String TYPE_FILE = "file";
    private static final String TYPE_WEBSERVICE = "webservice";
    private String mType;
    private String mFile;
    private String mToDir;
    private String mToURL;
    private String mUsername;
    private String mPassword;
    static /* synthetic */ Class class$java$lang$String;

    public void execute() {
        block7: {
            try {
                if (this.getType() == null) {
                    throw new BuildException(AeMessages.getString("AeDeployBPRTask.ERROR_2"), this.getLocation());
                }
                if (this.getFile() == null) {
                    throw new BuildException(AeMessages.getString("AeDeployBPRTask.ERROR_3"), this.getLocation());
                }
                if (this.getType().toLowerCase().equals(TYPE_FILE)) {
                    this.deployToFile();
                    break block7;
                }
                if (this.getType().toLowerCase().equals(TYPE_WEBSERVICE)) {
                    this.deployToWebservice();
                    break block7;
                }
                throw new BuildException(AeMessages.getString("AeDeployBPRTask.ERROR_4"), this.getLocation());
            }
            catch (BuildException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage(), this.getLocation());
            }
        }
    }

    protected File verifySourceFile() throws BuildException {
        File srcFile = new File(this.getFile());
        if (!srcFile.isFile()) {
            throw new BuildException(AeMessages.getString("AeDeployBPRTask.ERROR_5"), this.getLocation());
        }
        if (!srcFile.canRead()) {
            throw new BuildException(AeMessages.getString("AeDeployBPRTask.ERROR_6"), this.getLocation());
        }
        return srcFile;
    }

    protected void deployToFile() {
        if (this.getToDir() == null) {
            throw new BuildException(AeMessages.getString("AeDeployBPRTask.ERROR_7"), this.getLocation());
        }
        File srcFile = this.verifySourceFile();
        File destDir = new File(this.getToDir());
        if (!destDir.isDirectory()) {
            throw new BuildException(AeMessages.getString("AeDeployBPRTask.ERROR_8"), this.getLocation());
        }
        if (!destDir.canWrite()) {
            throw new BuildException(AeMessages.getString("AeDeployBPRTask.ERROR_9"), this.getLocation());
        }
        File destFile = new File(destDir, srcFile.getName());
        this.copyFile(srcFile, destFile);
        this.deploymentCompleteCallback(TYPE_FILE, null);
    }

    protected void deployToWebservice() {
        if (this.getToURL() == null) {
            throw new BuildException(AeMessages.getString("AeDeployBPRTask.ERROR_10"), this.getLocation());
        }
        File srcFile = this.verifySourceFile();
        String base64File = this.getBase64EncodedFile(srcFile);
        String rval = this.callWebservice(srcFile.getName(), base64File);
        this.log(rval);
        this.deploymentCompleteCallback(TYPE_WEBSERVICE, rval);
    }

    protected String callWebservice(String aFilename, String aBase64File) {
        String endpoint = this.getToURL();
        String methodName = "deployBpr";
        try {
            Call call = this.createCall(endpoint, methodName);
            call.setTimeout(new Integer(600000));
            if (this.getUsername() != null && !"".equals(this.getUsername().trim())) {
                call.setUsername(this.getUsername());
                call.setPassword(this.getPassword());
            }
            if (endpoint.endsWith("DeployBPRService")) {
                call.addParameter("aBprFilename", Constants.XSD_STRING, ParameterMode.IN);
                call.addParameter("aBase64File", Constants.XSD_STRING, ParameterMode.IN);
            } else {
                call.addParameter("bprFilename", Constants.XSD_STRING, ParameterMode.IN);
                call.addParameter("base64File", Constants.XSD_STRING, ParameterMode.IN);
            }
            call.setReturnType(Constants.XSD_STRING);
            return (String)call.invoke(new Object[]{aFilename, aBase64File});
        }
        catch (AxisFault fault) {
            if (fault.getCause() == null) {
                this.deploymentErrorCallback(AeMessages.format("AeDeployBPRTask.FAILED_TO_DEPLOY_TO_WS_ERROR", fault.toString()));
            } else if (fault.getCause() instanceof ConnectException) {
                this.deploymentErrorCallback(AeMessages.format("AeDeployBPRTask.COULD_NOT_CONNECT_ERROR", fault.getCause().getLocalizedMessage()));
            } else {
                this.deploymentErrorCallback(AeMessages.format("AeDeployBPRTask.WEBSERVICE_DEPLOY_ERROR", fault.getCause().getLocalizedMessage()));
            }
            throw new BuildException(fault.getLocalizedMessage(), this.getLocation());
        }
        catch (Throwable t) {
            throw new BuildException(t, this.getLocation());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getBase64EncodedFile(File aSrcFile) {
        String string;
        FileInputStream fis = null;
        String base64File = null;
        try {
            try {
                fis = new FileInputStream(aSrcFile);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int count = 0;
                byte[] buff = new byte[4096];
                while ((count = fis.read(buff)) != -1) {
                    baos.write(buff, 0, count);
                }
                BASE64Encoder encoder = new BASE64Encoder();
                string = base64File = encoder.encode(baos.toByteArray());
                Object var10_10 = null;
                if (fis == null) return string;
            }
            catch (Throwable t) {
                throw new BuildException(t.getLocalizedMessage(), this.getLocation());
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ioe) {
            // empty catch block
            return string;
        }
        fis.close();
        return string;
    }

    /*
     * Loose catch block
     */
    protected void copyFile(File aSrcFile, File aDestFile) {
        block15: {
            Exception e22;
            FileOutputStream fos;
            FileInputStream fis;
            block14: {
                fis = null;
                fos = null;
                fis = new FileInputStream(aSrcFile);
                fos = new FileOutputStream(aDestFile);
                byte[] buff = new byte[10240];
                int count = 0;
                while ((count = fis.read(buff)) != -1) {
                    fos.write(buff, 0, count);
                }
                Object var8_8 = null;
                if (fis == null) break block14;
                try {
                    fis.close();
                }
                catch (Exception e22) {
                    // empty catch block
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e22) {}
            }
            break block15;
            {
                catch (Throwable t) {
                    throw new BuildException(t.getLocalizedMessage(), this.getLocation());
                }
            }
            catch (Throwable throwable) {
                Exception e22;
                Object var8_9 = null;
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e22) {
                        // empty catch block
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public String getFile() {
        return this.mFile;
    }

    public void setFile(String aFile) {
        this.mFile = aFile;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setPassword(String aPassword) {
        this.mPassword = aPassword;
    }

    public String getToDir() {
        return this.mToDir;
    }

    public void setToDir(String aToDir) {
        this.mToDir = aToDir;
    }

    public String getToURL() {
        return this.mToURL;
    }

    public void setToURL(String aToURL) {
        this.mToURL = aToURL;
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String aType) {
        this.mType = aType;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public void setUsername(String aUsername) {
        this.mUsername = aUsername;
    }

    private Call createCall(String aEndpoint, String aMethodName) throws Exception {
        Service service = new Service();
        Call call = (Call)service.createCall();
        call.setTimeout(new Integer(180000));
        call.setTimeout(new Integer(600000));
        call.setTargetEndpointAddress(new URL(aEndpoint));
        call.setOperationName(aMethodName);
        return call;
    }

    private void deploymentCompleteCallback(String aType, String aReturnValue) {
        try {
            Method method = this.getCallbackMethod("awf.callback.method", new Class[]{class$java$lang$String == null ? (class$java$lang$String = AeDeployBPRTask.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = AeDeployBPRTask.class$("java.lang.String")) : class$java$lang$String});
            method.invoke(null, aType, aReturnValue);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void deploymentErrorCallback(String aErrorMessage) {
        try {
            Method method = this.getCallbackMethod("awf.callback.errormethod", new Class[]{class$java$lang$String == null ? (class$java$lang$String = AeDeployBPRTask.class$("java.lang.String")) : class$java$lang$String});
            method.invoke(null, aErrorMessage);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Method getCallbackMethod(String aMethodProp, Class[] aArgTypes) throws Exception {
        Properties props = new Properties();
        props.load(((Object)((Object)this)).getClass().getResourceAsStream("aetasks.properties"));
        String callBackClass = props.getProperty("awf.callback.class");
        String callBackMethod = props.getProperty(aMethodProp);
        Class<?> c = Class.forName(callBackClass);
        return c.getMethod(callBackMethod, aArgTypes);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

