/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connector.spi;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.tamino.db.api.connector.TaminoDataSourceImpl;
import com.softwareag.tamino.db.api.connector.cci.ConnectionFactoryImpl;
import com.softwareag.tamino.db.api.connector.spi.TaminoConnectionRequestInfo;
import com.softwareag.tamino.db.api.connector.spi.TaminoManagedConnection;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.GenericCredential;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public abstract class AbstractConnectionFactory
implements ManagedConnectionFactory,
Serializable {
    private static final String LOG_NAME = "com.softwareag.tamino.db.api.connector.spi.AbstractConnectionFactory";
    private static Logger logger = LoggerFactory.getLogger((String)"com.softwareag.tamino.db.api.connector.spi.AbstractConnectionFactory");
    private PrintWriter logWriter = null;
    private boolean thisSupportsCCI = false;
    private boolean thisSupportsXA = false;
    private boolean thisSupportsLocalTx = false;
    private boolean thisNonManaged = false;
    private String userName = null;
    private String password = null;
    private String taminoURL = null;
    private String utxDaemonUri = "tcpip://localhost:5555/utxDaemon";
    private String supportsAllXaResourceFlags = "yes";

    public AbstractConnectionFactory(String string) throws ResourceException {
        this.trace(string);
        this.trace("mcf is: " + this.toString());
    }

    public Object createConnectionFactory() throws ResourceException {
        this.trace("createConnectionFactory()");
        if (!this.supportsCCI()) {
            TaminoDataSourceImpl taminoDataSourceImpl = new TaminoDataSourceImpl(this, null);
            return taminoDataSourceImpl;
        }
        ConnectionFactoryImpl connectionFactoryImpl = new ConnectionFactoryImpl((ManagedConnectionFactory)this);
        return connectionFactoryImpl;
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        this.trace("createConnectionFactory(Connection Manager)");
        if (!this.supportsCCI()) {
            TaminoDataSourceImpl taminoDataSourceImpl = new TaminoDataSourceImpl(this, connectionManager);
            return taminoDataSourceImpl;
        }
        ConnectionFactoryImpl connectionFactoryImpl = new ConnectionFactoryImpl((ManagedConnectionFactory)this, connectionManager);
        return connectionFactoryImpl;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        this.trace("createManagedConnection()");
        TaminoConnectionRequestInfo taminoConnectionRequestInfo = this.determineCredentials(subject, connectionRequestInfo);
        TaminoManagedConnection taminoManagedConnection = new TaminoManagedConnection(this, taminoConnectionRequestInfo);
        taminoManagedConnection.setLogWriter(this.logWriter);
        this.trace("the created managed connection: " + taminoManagedConnection.toString());
        return taminoManagedConnection;
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        this.trace("matchManagedConnections()");
        this.trace("  set of candidates: " + this.traceSetOfCandidates(set));
        TaminoConnectionRequestInfo taminoConnectionRequestInfo = this.determineCredentials(subject, connectionRequestInfo);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.trace("connectionSet object is " + e);
            if (!(e instanceof TaminoManagedConnection)) continue;
            this.trace("object is instance of TaminoManagedConnection");
            TaminoManagedConnection taminoManagedConnection = (TaminoManagedConnection)e;
            ManagedConnectionFactory managedConnectionFactory = taminoManagedConnection.getManagedConnectionFactory();
            this.trace("mcf is " + managedConnectionFactory);
            this.trace("this is " + this);
            if (taminoManagedConnection.isDestroyed()) {
                this.trace("ignore destroyed ManagedConnections: " + taminoManagedConnection.toString());
                continue;
            }
            if (!taminoManagedConnection.isFree()) {
                this.trace("ignore ManagedConnections already in use: " + taminoManagedConnection.toString());
                continue;
            }
            if (!taminoManagedConnection.isHealthy()) {
                this.trace("ignore unhealthy ManagedConnections: " + taminoManagedConnection.toString());
                taminoManagedConnection.sendEventConnectionErrorOccurred();
                continue;
            }
            if (!managedConnectionFactory.equals((Object)this)) continue;
            if (taminoManagedConnection.getUserName() != null) {
                if (!taminoManagedConnection.getUserName().equals(taminoConnectionRequestInfo.getUserName()) || !taminoManagedConnection.getPassword().equals(taminoConnectionRequestInfo.getPassword())) continue;
                this.trace("matching ManagedConnection found, so return that: " + taminoManagedConnection.toString());
                taminoManagedConnection.reset();
                return taminoManagedConnection;
            }
            if (taminoConnectionRequestInfo.getUserName() != null) continue;
            this.trace("matching ManagedConnection without user name found, so return that: " + taminoManagedConnection.toString());
            taminoManagedConnection.reset();
            return taminoManagedConnection;
        }
        this.trace("no matching ManagedConnection found, so return null");
        return null;
    }

    protected void setSupportsCCI(boolean bl) {
        this.thisSupportsCCI = bl;
    }

    protected boolean supportsCCI() {
        return this.thisSupportsCCI;
    }

    protected void setSupportsXA(boolean bl) {
        this.thisSupportsXA = bl;
    }

    protected boolean supportsXA() {
        return this.thisSupportsXA;
    }

    protected void setSupportsLocalTx(boolean bl) {
        this.thisSupportsLocalTx = bl;
    }

    protected boolean supportsLocalTx() {
        return this.thisSupportsLocalTx;
    }

    public void setNonManaged(boolean bl) {
        this.thisNonManaged = bl;
    }

    public boolean isNonManaged() {
        return this.thisNonManaged;
    }

    public void setTaminoURL(String string) {
        this.trace("setUrl(): set to " + string);
        this.taminoURL = string;
    }

    public void settaminoURL(String string) {
        this.setTaminoURL(string);
    }

    public String getTaminoURL() {
        this.trace("getUrl(): return " + this.taminoURL);
        return this.taminoURL;
    }

    public void setUserName(String string) {
        this.trace("setUserName(): set to " + string);
        this.userName = string;
    }

    public void setuserName(String string) {
        this.setUserName(string);
    }

    public String getUserName() {
        this.trace("getUserName(): return " + this.userName);
        return this.userName;
    }

    public void setPassword(String string) {
        this.trace("setPassword(): set to ***");
        this.password = string;
    }

    public void setpassword(String string) {
        this.setPassword(string);
    }

    public String getPassword() {
        this.trace("getPassword(): return ***");
        return this.password;
    }

    public void setUtxDaemonUri(String string) {
        this.trace("setUtxDaemonUri(): set to " + string);
        this.utxDaemonUri = string;
    }

    public void setutxDaemonUri(String string) {
        this.setUtxDaemonUri(string);
    }

    public String getUtxDaemonUri() {
        this.trace("getUtxDaemonUri(): return " + this.utxDaemonUri);
        return this.utxDaemonUri;
    }

    public void setSupportsAllXaResourceFlags(String string) {
        this.trace("setSupportsAllXaResourceFlags(): set to " + string);
        this.supportsAllXaResourceFlags = string;
    }

    public String getSupportsAllXaResourceFlags() {
        this.trace("getSupportsAllXaResourceFlags(): return " + this.supportsAllXaResourceFlags);
        return this.supportsAllXaResourceFlags;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        this.trace("getLogWriter()");
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.trace("setLogWriter()");
        this.logWriter = printWriter;
    }

    protected TaminoConnectionRequestInfo determineCredentials(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        boolean bl = false;
        TaminoConnectionRequestInfo taminoConnectionRequestInfo = null;
        try {
            taminoConnectionRequestInfo = new TaminoConnectionRequestInfo((TaminoConnectionRequestInfo)connectionRequestInfo);
        }
        catch (ClassCastException classCastException) {
            this.trace("Class cast exception trying to cast a ConnectionRequestInfo to a TaminoConnectionRequestInfo.");
            this.trace("This means that the application server passed us some strange object:");
            this.trace(connectionRequestInfo.getClass().getName());
            this.trace("Ignore this exception and create an empty TaminoConnectionRequestInfo instance.");
            this.trace("Exception: " + classCastException);
            taminoConnectionRequestInfo = new TaminoConnectionRequestInfo();
        }
        if (subject != null) {
            Set<?> set = null;
            this.trace("a subject was passed, analyse it");
            try {
                set = subject.getPrivateCredentials(Class.forName("javax.resource.spi.security.PasswordCredential"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.trace("ClassNotFoundException: PasswordCredential could not be found.");
                throw new ResourceException("ClassNotFoundException: PasswordCredential could not be found; exception is: " + classNotFoundException);
            }
            if (!set.isEmpty()) {
                Iterator<?> iterator = set.iterator();
                PasswordCredential passwordCredential = null;
                while (iterator.hasNext()) {
                    passwordCredential = (PasswordCredential)iterator.next();
                    if (!passwordCredential.getManagedConnectionFactory().equals((Object)this)) continue;
                    this.trace("relevant PasswordCredential credentials were found in the subject, take them:");
                    this.trace("user: " + passwordCredential.getUserName());
                    if (passwordCredential.getUserName() != null && passwordCredential.getUserName() != "") {
                        bl = true;
                        taminoConnectionRequestInfo.setUserName(passwordCredential.getUserName());
                        taminoConnectionRequestInfo.setPassword(new String(passwordCredential.getPassword()));
                        continue;
                    }
                    this.trace("subject PasswordCredential credentials were ignored as they were null or empty !!!");
                }
            } else {
                try {
                    set = subject.getPrivateCredentials(Class.forName("javax.resource.spi.security.GenericCredential"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.trace("ClassNotFoundException: GenericCredential could not be found.");
                    throw new ResourceException("ClassNotFoundException: GenericCredential could not be found; exception is: " + classNotFoundException);
                }
                if (!set.isEmpty()) {
                    Iterator<?> iterator = set.iterator();
                    GenericCredential genericCredential = null;
                    while (iterator.hasNext()) {
                        genericCredential = (GenericCredential)iterator.next();
                        this.trace("relevant GenericCredential credentials were found in the subject, take them:");
                        this.trace("user: " + genericCredential.getName());
                        if (genericCredential.getName() != null && genericCredential.getName() != "") {
                            bl = true;
                            taminoConnectionRequestInfo.setUserName(genericCredential.getName());
                            taminoConnectionRequestInfo.setPassword(new String(genericCredential.getCredentialData()));
                            continue;
                        }
                        this.trace("subject GenericCredential credentials were ignored as they were null or empty !!!");
                    }
                }
            }
        }
        if (!bl) {
            this.trace("no subject was passed or no relevant credentials were found, analyse request info");
            if (taminoConnectionRequestInfo.getUserName() == null) {
                this.trace("no user name passed by bean, take RA default:");
                this.trace("user: " + this.getUserName());
                taminoConnectionRequestInfo.setUserName(this.getUserName());
            }
            if (taminoConnectionRequestInfo.getPassword() == null) {
                taminoConnectionRequestInfo.setPassword(this.getPassword());
            }
        }
        return taminoConnectionRequestInfo;
    }

    private String traceSetOfCandidates(Set set) {
        String string = "";
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof TaminoManagedConnection)) continue;
            TaminoManagedConnection taminoManagedConnection = (TaminoManagedConnection)e;
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + Integer.toHexString(taminoManagedConnection.hashCode());
        }
        return string;
    }

    protected void trace(String string) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(string);
        }
        if (this.logWriter != null) {
            this.logWriter.println(string);
        }
    }
}

