/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connector.spi;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.tamino.db.api.connection.TLocalTransaction;
import com.softwareag.tamino.db.api.connection.TTransactionException;
import com.softwareag.tamino.db.api.connector.spi.TaminoManagedConnection;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;

public class TaminoLocalTransaction
implements LocalTransaction {
    private TaminoManagedConnection mc = null;
    private TLocalTransaction transaction = null;
    private boolean switchedToLocalTransactionMode = false;
    private static final String LOG_NAME = "com.softwareag.tamino.db.api.connector.spi.TaminoLocalTransaction";
    private static Logger logger = LoggerFactory.getLogger((String)"com.softwareag.tamino.db.api.connector.spi.TaminoLocalTransaction");
    private String lastCommand = "";

    public TaminoLocalTransaction(TaminoManagedConnection taminoManagedConnection) throws ResourceException {
        this.trace("constructor TaminoLocalTransaction()");
        if (taminoManagedConnection == null) {
            throw new ResourceException("   no connection object to set transaction to");
        }
        this.mc = taminoManagedConnection;
    }

    public void begin() throws ResourceException {
        this.trace("begin()");
        if (logger.isLoggable(Level.FINE)) {
            this.traceTxStatus("Begin");
        }
        if (!this.mc.getTCon().usesLocalTransactionMode()) {
            this.trace(" transaction mode is autocommit");
            if (this.switchedToLocalTransactionMode) {
                this.trace("attempt to switch to local transaction mode twice!");
                throw new ResourceException("attempt to switch to local transaction mode twice!");
            }
            try {
                this.transaction = this.mc.getTCon().useLocalTransactionMode();
                this.switchedToLocalTransactionMode = true;
            }
            catch (TTransactionException tTransactionException) {
                this.trace(" caught TTransactionException when setting useLocalTransactionMode: " + tTransactionException.getMessage() + " XML message is: " + tTransactionException.toXMLString());
                tTransactionException.printStackTrace();
                throw new ResourceException("set transaction mode error: " + tTransactionException.getMessage() + " XML message is: " + tTransactionException.toXMLString());
            }
        } else {
            this.trace(" transaction mode is localtransaction, so do nothing");
            this.transaction = (TLocalTransaction)this.mc.getTCon().getTransaction();
        }
        this.lastCommand = "Begin";
    }

    public void commit() throws ResourceException {
        this.trace("in commit()");
        if (logger.isLoggable(Level.FINE)) {
            this.traceTxStatus("Commit");
        }
        this.checkIfValid();
        try {
            this.trace("now call tamino commit");
            this.transaction.commit();
            this.transaction = null;
        }
        catch (TTransactionException tTransactionException) {
            this.trace("caught TTransactionException");
            tTransactionException.printStackTrace();
            throw new ResourceException("TaminoAPI commit error: " + tTransactionException.getMessage());
        }
        this.lastCommand = "Commit";
    }

    public void rollback() throws ResourceException {
        this.trace("in rollback()");
        if (logger.isLoggable(Level.FINE)) {
            this.traceTxStatus("Rollback");
        }
        this.checkIfValid();
        try {
            this.trace("now call tamino rollback");
            this.transaction.rollback();
            this.transaction = null;
        }
        catch (TTransactionException tTransactionException) {
            this.trace("caught TTransactionException");
            tTransactionException.printStackTrace();
            throw new ResourceException("API rollback error: " + tTransactionException.getMessage());
        }
        this.lastCommand = "Rollback";
    }

    private void checkIfValid() throws ResourceException {
        this.trace("checkIfValid");
        if (this.transaction == null) {
            this.trace("transaction object is null, so throw exception");
            throw new ResourceException("no transaction object");
        }
        if (this.transaction != (TLocalTransaction)this.mc.getTCon().getTransaction()) {
            this.trace("transaction object has changed.");
            throw new ResourceException("internal error: transaction object has changed.");
        }
    }

    private void traceTxStatus(String string) {
        if (this.lastCommand == "Begin") {
            this.trace(string + " after Begin !!!");
        }
        if (this.lastCommand == "Commit") {
            this.trace(string + " after Commit !!!");
        }
        if (this.lastCommand == "Rollback") {
            this.trace(string + " after Rollback !!!");
        }
    }

    private void trace(String string) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(Integer.toHexString(this.hashCode()) + ": " + string);
        }
    }
}

