/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connector.spi;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.common.TDatabaseVersionCache;
import com.softwareag.tamino.db.api.common.TUri;
import com.softwareag.tamino.db.api.connector.spi.AbstractConnectionFactory;
import com.softwareag.tamino.db.api.connector.spi.TaminoManagedConnection;
import java.net.MalformedURLException;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;

public class TaminoMetaData
implements ManagedConnectionMetaData {
    private TaminoManagedConnection mc;
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger((String)LOG_NAME);
    private String uri;
    private String user;

    public TaminoMetaData(TaminoManagedConnection taminoManagedConnection) {
        this.trace("new TaminoMetaData called");
        this.mc = taminoManagedConnection;
        ManagedConnectionFactory managedConnectionFactory = this.mc.getManagedConnectionFactory();
        this.uri = new String(((AbstractConnectionFactory)managedConnectionFactory).getTaminoURL());
        this.user = new String(((AbstractConnectionFactory)managedConnectionFactory).getUserName());
    }

    public String getEISProductName() throws ResourceException {
        this.trace("getEISProductName()");
        return "Tamino Server";
    }

    public String getEISProductVersion() throws ResourceException {
        String string = "";
        try {
            string = TDatabaseVersionCache.getInstance().fetchVersion(new TUri(this.uri));
        }
        catch (MalformedURLException malformedURLException) {
            this.trace("MalformedURLException thrown for Tamino URL: " + this.uri + " ; exception: " + malformedURLException);
        }
        if (string.length() == 0) {
            string = "unknown version";
        }
        this.trace("getEISProductVersion(): return " + string);
        return string;
    }

    public int getMaxConnections() throws ResourceException {
        int n = 256;
        this.trace("getMaxConnections() returns fix " + n);
        return n;
    }

    public String getUserName() throws ResourceException {
        this.trace("getUserName() returns : " + this.user);
        return this.user;
    }

    private void trace(String string) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("TaminoMetaData:" + string);
        }
    }
}

