/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connector.xa;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connector.spi.AbstractConnectionFactory;
import com.softwareag.tamino.db.api.connector.spi.TaminoManagedConnection;
import com.softwareag.tamino.db.api.connector.xa.XidImpl;
import com.softwareag.utx.UTXDaemonInfo;
import com.softwareag.utx.UTXDaemonProxy;
import com.softwareag.utx.UTXDaemonUri;
import com.softwareag.utx.UTXException;
import com.softwareag.utx.UTXIterator;
import com.softwareag.utx.UTXObjectFactory;
import com.softwareag.utx.UTXRmId;
import com.softwareag.utx.UTXUrl;
import com.softwareag.utx.UTXXaId;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceImpl
implements XAResource {
    private static final int STATE_ACTIVE = 1;
    private static final int STATE_SUSPENDED = 2;
    private static final int STATE_ENDED = 3;
    private static final int STATE_PREPARED = 4;
    private int thisTransactionTimeout = 0;
    private TaminoManagedConnection thisMc;
    private UTXObjectFactory factory = UTXObjectFactory.getInstance();
    private UTXDaemonProxy utxDaemonProxy;
    private UTXRmId utxRmId = null;
    private UTXUrl utxUrl = null;
    private UTXDaemonUri utxDaemonUri = null;
    private Xid thisXid = null;
    private int thisState = 1;
    private boolean supportsAllXaResourceFlags = true;
    private static final String LOG_NAME = "com.softwareag.tamino.db.api.connector.xa.XAResourceImpl";
    private static Logger logger = LoggerFactory.getLogger((String)"com.softwareag.tamino.db.api.connector.xa.XAResourceImpl");

    public XAResourceImpl(TaminoManagedConnection taminoManagedConnection) throws ResourceException {
        this.trace("new instance");
        this.thisMc = taminoManagedConnection;
        AbstractConnectionFactory abstractConnectionFactory = (AbstractConnectionFactory)taminoManagedConnection.getManagedConnectionFactory();
        try {
            String string = abstractConnectionFactory.getSupportsAllXaResourceFlags();
            if (string != null && string.toLowerCase().startsWith("no")) {
                this.supportsAllXaResourceFlags = false;
            }
            this.utxDaemonUri = this.factory.createDaemonUrl(abstractConnectionFactory.getUtxDaemonUri());
            this.utxRmId = this.factory.createResourceManagerId(abstractConnectionFactory.getTaminoURL());
            this.trace("UTXDaemonUri = " + this.utxDaemonUri.toString() + ", UTXRmId = " + this.utxRmId.toString());
            this.utxDaemonProxy = this.factory.createDaemonProxy(this.utxDaemonUri);
        }
        catch (UTXException uTXException) {
            throw new ResourceException("Could not allocate the UTXProxy!", uTXException.getMessage());
        }
    }

    public XAResourceImpl(String string, String string2) throws ResourceException {
        try {
            this.utxDaemonUri = this.factory.createDaemonUrl(string);
            this.utxRmId = this.factory.createResourceManagerId(string2);
            this.utxDaemonProxy = this.factory.createDaemonProxy(this.utxDaemonUri);
        }
        catch (UTXException uTXException) {
            throw new ResourceException("Could not allocate the UTXProxy!", uTXException.getMessage());
        }
    }

    public void closeUtxProxy() {
        this.trace("closing UTX Deamon Proxy for: " + this.utxDaemonUri.toString());
        try {
            this.utxDaemonProxy.close();
            this.trace("close done");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void start(Xid xid, int n) throws XAException {
        this.trace("start( flag=" + this.flagsToString(n) + ", " + xid + ")");
        switch (n) {
            case 0x200000: {
                this.throwConditionedXAException("TMJOIN not supported", -5);
                break;
            }
            case 0x8000000: {
                this.throwConditionedXAException("TMRESUME not supported", -5);
                break;
            }
            case 0: {
                this.thisXid = xid;
                UTXXaId uTXXaId = this.getUTXXaId(xid);
                try {
                    this.utxUrl = this.utxDaemonProxy.startUTXSubordinateToXA(this.utxRmId, uTXXaId, (short)0);
                }
                catch (UTXException uTXException) {
                    this.throwXAException(uTXException);
                }
                this.thisState = 1;
                break;
            }
            default: {
                this.throwXAException("Unexpected flag setting", -5);
            }
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        block4: {
            this.trace("commit( onePhase=" + bl + ", " + xid + ")");
            this.checkXid(xid);
            UTXXaId uTXXaId = this.getUTXXaId(xid);
            try {
                if (this.utxUrl == null) {
                    this.utxDaemonProxy.commit(uTXXaId);
                    break block4;
                }
                if (bl) {
                    this.utxDaemonProxy.prepare(this.utxUrl, uTXXaId);
                    this.utxDaemonProxy.commit(this.utxUrl, uTXXaId);
                    this.utxUrl = null;
                    break block4;
                }
                this.utxDaemonProxy.commit(this.utxUrl, uTXXaId);
                this.utxUrl = null;
            }
            catch (UTXException uTXException) {
                this.throwXAException(uTXException);
            }
        }
    }

    public void rollback(Xid xid) throws XAException {
        block3: {
            this.trace("rollback(" + xid + ")");
            this.checkXid(xid);
            UTXXaId uTXXaId = this.getUTXXaId(xid);
            try {
                if (this.utxUrl == null) {
                    this.utxDaemonProxy.rollback(uTXXaId);
                    break block3;
                }
                this.utxDaemonProxy.rollback(this.utxUrl, uTXXaId);
                this.utxUrl = null;
            }
            catch (UTXException uTXException) {
                this.throwXAException(uTXException);
            }
        }
    }

    public void end(Xid xid, int n) throws XAException {
        this.trace("end( flags=" + this.flagsToString(n) + ", " + xid + ")");
        this.checkXid(xid);
        switch (n) {
            case 0x2000000: {
                this.throwConditionedXAException("TMSUSPEND not supported", -5);
                break;
            }
            case 0x20000000: {
                this.thisState = 3;
                break;
            }
            case 0x4000000: {
                this.thisState = 3;
                break;
            }
            default: {
                this.throwXAException("Unexpected flag setting", -5);
            }
        }
    }

    public void forget(Xid xid) throws XAException {
        this.trace("forget(" + xid + ")");
        try {
            this.utxDaemonProxy.forget(this.getUTXXaId(xid));
        }
        catch (UTXException uTXException) {
            this.throwXAException(uTXException);
        }
    }

    public int getTransactionTimeout() throws XAException {
        this.trace("getTransactionTimeout()");
        try {
            UTXDaemonInfo uTXDaemonInfo = this.utxDaemonProxy.diagnose();
            return uTXDaemonInfo.getDefaultTimeout();
        }
        catch (UTXException uTXException) {
            this.throwXAException(uTXException);
            return 0;
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        this.trace("setTransactionTimeout()");
        return false;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        boolean bl = false;
        if (xAResource instanceof XAResourceImpl) {
            XAResourceImpl xAResourceImpl = (XAResourceImpl)xAResource;
            if (this.hashCode() == xAResourceImpl.hashCode()) {
                bl = true;
            }
        }
        this.trace("isSameRM(), returned " + bl);
        return bl;
    }

    public int hashCode() {
        AbstractConnectionFactory abstractConnectionFactory = (AbstractConnectionFactory)this.thisMc.getManagedConnectionFactory();
        if (abstractConnectionFactory.getUserName() == null) {
            return abstractConnectionFactory.getTaminoURL().hashCode();
        }
        return abstractConnectionFactory.getTaminoURL().hashCode() + abstractConnectionFactory.getUserName().hashCode();
    }

    public int prepare(Xid xid) throws XAException {
        this.trace("prepare(" + xid + ")");
        this.checkXid(xid);
        if (this.thisState != 3) {
            this.throwXAException("Attempt to prepare a transaction branch before it was ended", -6);
        }
        try {
            this.utxDaemonProxy.prepare(this.utxUrl, this.getUTXXaId(xid));
        }
        catch (UTXException uTXException) {
            this.throwXAException(uTXException);
        }
        return 0;
    }

    public Xid[] recover(int n) throws XAException {
        this.trace("recover(flags=" + this.flagsToString(n) + ")");
        Xid[] xidArray = null;
        if (n == 0 || n == 0x800000) {
            return null;
        }
        Vector<XidImpl> vector = new Vector<XidImpl>();
        try {
            UTXIterator uTXIterator = this.utxDaemonProxy.recover(this.utxRmId);
            int n2 = 0;
            while (uTXIterator.hasNext()) {
                UTXXaId uTXXaId = (UTXXaId)uTXIterator.next();
                XidImpl xidImpl = new XidImpl(uTXXaId);
                vector.addElement(xidImpl);
                ++n2;
            }
            xidArray = new Xid[n2];
            int n3 = 0;
            while (n3 < vector.size()) {
                xidArray[n3] = (Xid)vector.elementAt(n3);
                ++n3;
            }
            uTXIterator.close();
        }
        catch (UTXException uTXException) {
            this.throwXAException(uTXException);
        }
        return xidArray;
    }

    private UTXXaId getUTXXaId(Xid xid) {
        return this.factory.createTransactionId(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
    }

    private void setGlobalTransaction(TConnection tConnection, UTXUrl uTXUrl) throws XAException {
        if (this instanceof XAResourceImpl) {
            // empty if block
        }
    }

    private void checkXid(Xid xid) {
        if (!logger.isLoggable(Level.INFO)) {
            return;
        }
        if (this.thisXid == null) {
            return;
        }
        if (this.thisXid != xid) {
            byte[] byArray;
            byte[] byArray2;
            String string = "xid changed !!!!!!!!!!!!!!!";
            if (this.thisXid.getFormatId() != xid.getFormatId()) {
                logger.info(string);
                return;
            }
            byte[] byArray3 = this.thisXid.getBranchQualifier();
            if (byArray3.length != (byArray2 = xid.getBranchQualifier()).length) {
                logger.info(string);
                return;
            }
            int n = 0;
            while (n < byArray3.length) {
                if (byArray3[n] != byArray2[n]) {
                    logger.info(string);
                    return;
                }
                ++n;
            }
            byte[] byArray4 = this.thisXid.getBranchQualifier();
            if (byArray4.length != (byArray = xid.getBranchQualifier()).length) {
                logger.info(string);
                return;
            }
            int n2 = 0;
            while (n2 < byArray4.length) {
                if (byArray4[n2] != byArray[n2]) {
                    logger.info(string);
                    return;
                }
                ++n2;
            }
        }
    }

    private void throwConditionedXAException(String string, int n) throws XAException {
        if (this.supportsAllXaResourceFlags) {
            return;
        }
        this.throwXAException(string, n);
    }

    private void throwXAException(String string, int n) throws XAException {
        XAException xAException = new XAException(string);
        xAException.errorCode = n;
        throw xAException;
    }

    private void throwXAException(UTXException uTXException) throws XAException {
        Exception exception = uTXException.getNestedExeption();
        XAException xAException = new XAException(uTXException.getMessage());
        if (uTXException.hasErrorCode()) {
            xAException.errorCode = this.mapToXaErrorCode(uTXException.getErrorCode());
        }
        if (exception == null) {
            throw xAException;
        }
        exception.printStackTrace();
        throw xAException;
    }

    private int mapToXaErrorCode(int n) {
        if (n == 3) {
            return 3;
        }
        if (n == 5) {
            return 5;
        }
        if (n == 6) {
            return 6;
        }
        if (n == 7) {
            return 7;
        }
        if (n == 8) {
            return 8;
        }
        if (n == 100) {
            return 100;
        }
        if (n == 101) {
            return 101;
        }
        if (n == 102) {
            return 102;
        }
        if (n == 103) {
            return 103;
        }
        if (n == 104) {
            return 104;
        }
        if (n == 105) {
            return 105;
        }
        if (n == 106) {
            return 106;
        }
        if (n == 107) {
            return 107;
        }
        if (n == -4) {
            return -4;
        }
        if (n == -3) {
            return -3;
        }
        return -1;
    }

    private void trace(String string) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(string);
        }
    }

    private String xidToString(Xid xid) {
        XidImpl xidImpl = new XidImpl(xid);
        return xidImpl.toString();
    }

    private String flagsToString(int n) {
        String string = "";
        if (n == 0x200000) {
            string = string + " TMJOIN ";
        }
        if (n == 0x8000000) {
            string = string + " TMRESUME ";
        }
        if (n == 0x800000) {
            string = string + " TMENDRSCAN";
        }
        if (n == 0x20000000) {
            string = string + " TMFAIL";
        }
        if (n == 0) {
            string = string + " TMNOFLAGS";
        }
        if (n == 0x40000000) {
            string = string + " TMONEPHASE";
        }
        if (n == 0x1000000) {
            string = string + " TMSTARTRSCAN";
        }
        if (n == 0x4000000) {
            string = string + " TMSUCCESS";
        }
        if (n == 3) {
            string = string + " XA_RDONLY";
        }
        if (n == 0) {
            string = string + " XA_OK";
        }
        return string;
    }
}

