/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.xmlrpc.Base64;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.util.DateTool;

class XmlWriter
extends OutputStreamWriter {
    protected static final String PROLOG_START = "<?xml version=\"1.0\" encoding=\"";
    protected static final String PROLOG_END = "\"?>";
    protected static final String CLOSING_TAG_START = "</";
    protected static final String SINGLE_TAG_END = "/>";
    protected static final String LESS_THAN_ENTITY = "&lt;";
    protected static final String GREATER_THAN_ENTITY = "&gt;";
    protected static final String AMPERSAND_ENTITY = "&amp;";
    protected static final String ISO8859_1 = "ISO8859_1";
    protected static final String UTF8 = "UTF8";
    private static Properties encodings = new Properties();
    private static DateTool dateTool;

    public XmlWriter(OutputStream out, String enc) throws UnsupportedEncodingException, IOException {
        super(out, enc);
        this.write(PROLOG_START);
        this.write(XmlWriter.canonicalizeEncoding(enc));
        this.write(PROLOG_END);
    }

    protected static String canonicalizeEncoding(String javaEncoding) {
        return encodings.getProperty(javaEncoding, javaEncoding);
    }

    public void writeObject(Object obj) throws XmlRpcException, IOException {
        this.startElement("value");
        if (obj == null) {
            throw new IllegalArgumentException("null values not supported by XML-RPC");
        }
        if (obj instanceof String) {
            this.chardata(obj.toString());
        } else if (obj instanceof Integer) {
            this.startElement("int");
            this.write(obj.toString());
            this.endElement("int");
        } else if (obj instanceof Boolean) {
            this.startElement("boolean");
            this.write((Boolean)obj != false ? "1" : "0");
            this.endElement("boolean");
        } else if (obj instanceof Double || obj instanceof Float) {
            this.startElement("double");
            this.write(obj.toString());
            this.endElement("double");
        } else if (obj instanceof Date) {
            this.startElement("dateTime.iso8601");
            Date d = (Date)obj;
            this.write(dateTool.format(d));
            this.endElement("dateTime.iso8601");
        } else if (obj instanceof byte[]) {
            this.startElement("base64");
            this.write(Base64.encode((byte[])obj));
            this.endElement("base64");
        } else if (obj instanceof Object[]) {
            this.startElement("array");
            this.startElement("data");
            Object[] array = (Object[])obj;
            for (int i = 0; i < array.length; ++i) {
                this.writeObject(array[i]);
            }
            this.endElement("data");
            this.endElement("array");
        } else if (obj instanceof Vector) {
            this.startElement("array");
            this.startElement("data");
            Vector array = (Vector)obj;
            int size = array.size();
            for (int i = 0; i < size; ++i) {
                this.writeObject(array.elementAt(i));
            }
            this.endElement("data");
            this.endElement("array");
        } else if (obj instanceof Hashtable) {
            this.startElement("struct");
            Hashtable struct = (Hashtable)obj;
            Enumeration e = struct.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object value = struct.get(key);
                this.startElement("member");
                this.startElement("name");
                this.chardata(key);
                this.endElement("name");
                this.writeObject(value);
                this.endElement("member");
            }
            this.endElement("struct");
        } else {
            throw new RuntimeException("unsupported Java type: " + obj.getClass());
        }
        this.endElement("value");
    }

    protected void write(byte[] byteData) throws IOException {
        for (int i = 0; i < byteData.length; ++i) {
            this.write(byteData[i]);
        }
    }

    protected void startElement(String elem) throws IOException {
        this.write(60);
        this.write(elem);
        this.write(62);
    }

    protected void endElement(String elem) throws IOException {
        this.write(CLOSING_TAG_START);
        this.write(elem);
        this.write(62);
    }

    protected void emptyElement(String elem) throws IOException {
        this.write(60);
        this.write(elem);
        this.write(SINGLE_TAG_END);
    }

    protected void chardata(String text) throws XmlRpcException, IOException {
        int l = text.length();
        block6: for (int i = 0; i < l; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    this.write(c);
                    continue block6;
                }
                case '<': {
                    this.write(LESS_THAN_ENTITY);
                    continue block6;
                }
                case '>': {
                    this.write(GREATER_THAN_ENTITY);
                    continue block6;
                }
                case '&': {
                    this.write(AMPERSAND_ENTITY);
                    continue block6;
                }
                default: {
                    if (c < ' ') {
                        throw new XmlRpcException(0, "Invalid character data corresponding to XML entity &#" + String.valueOf((int)c) + ';');
                    }
                    this.write(c);
                }
            }
        }
    }

    static {
        ((Hashtable)encodings).put(UTF8, "UTF-8");
        ((Hashtable)encodings).put(ISO8859_1, "ISO-8859-1");
        dateTool = new DateTool();
    }
}

