/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core;

import java.io.PrintWriter;
import org.apache.muse.core.Environment;
import org.apache.muse.core.proxy.ProxyHandler;
import org.apache.muse.util.Traceable;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.addressing.soap.SimpleSoapClient;
import org.apache.muse.ws.addressing.soap.SoapClient;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.addressing.soap.SoapMonitor;
import org.apache.muse.ws.addressing.soap.SoapUtils;
import org.w3c.dom.Element;

public abstract class AbstractResourceClient
implements Traceable,
SoapMonitor {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$core$AbstractResourceClient == null ? (class$org$apache$muse$core$AbstractResourceClient = AbstractResourceClient.class$("org.apache.muse.core.AbstractResourceClient")) : class$org$apache$muse$core$AbstractResourceClient);
    private EndpointReference _destination = null;
    private SoapClient _soapClient = null;
    private EndpointReference _source = null;
    static /* synthetic */ Class class$org$apache$muse$core$AbstractResourceClient;

    public AbstractResourceClient(EndpointReference destination) {
        this(destination, WsaConstants.ANONYMOUS_EPR);
    }

    public AbstractResourceClient(EndpointReference destination, EndpointReference source) {
        this(destination, source, new SimpleSoapClient());
    }

    public AbstractResourceClient(EndpointReference destination, EndpointReference source, Environment environment) {
        this(destination, source, environment.getSoapClient());
    }

    public AbstractResourceClient(EndpointReference destination, EndpointReference source, SoapClient soapClient) {
        if (destination == null) {
            throw new NullPointerException(_MESSAGES.get("NullDestinationEPR"));
        }
        if (source == null) {
            throw new NullPointerException(_MESSAGES.get("NullSourceEPR"));
        }
        if (soapClient == null) {
            throw new NullPointerException(_MESSAGES.get("NullSoapClient"));
        }
        this._destination = destination;
        this._source = source;
        this._soapClient = soapClient;
    }

    public EndpointReference getDestination() {
        return this._destination;
    }

    public EndpointReference getEndpointReference() {
        return this.getDestination();
    }

    public SoapClient getSoapClient() {
        return this._soapClient;
    }

    public int getSoapMonitorPort() {
        return this.getSoapClient().getSoapMonitorPort();
    }

    public EndpointReference getSource() {
        return this._source;
    }

    public PrintWriter getTraceWriter() {
        return this.getSoapClient().getTraceWriter();
    }

    public Object invoke(ProxyHandler handler, Object[] parameters) throws SoapFault {
        return this.invoke(handler, parameters, new Element[0]);
    }

    public Object invoke(ProxyHandler handler, Object[] parameters, Element[] extraHeaders) throws SoapFault {
        if (handler == null) {
            throw new NullPointerException(_MESSAGES.get("NullProxyHandler"));
        }
        String action = handler.getAction();
        Element body = handler.toXML(parameters);
        Element response = this.invoke(action, body, extraHeaders);
        return handler.fromXML(response);
    }

    public Element invoke(String action, Element soapBody) throws SoapFault {
        return this.invoke(action, soapBody, new Element[0]);
    }

    public Element invoke(String action, Element soapBody, Element[] extraHeaders) throws SoapFault {
        Element[] body = new Element[]{soapBody};
        Element[] response = this.getSoapClient().send(this.getSource(), this.getDestination(), action, body, extraHeaders);
        if (response.length == 0) {
            return null;
        }
        if (SoapUtils.isFault(response[0])) {
            throw new SoapFault(response[0]);
        }
        return response[0];
    }

    public boolean isUsingSoapMonitor() {
        return this.getSoapClient().isUsingSoapMonitor();
    }

    public boolean isUsingTrace() {
        return this.getSoapClient().isUsingTrace();
    }

    public void setTrace(boolean trace) {
        this.getSoapClient().setTrace(trace);
    }

    public void setTraceWriter(PrintWriter writer) {
        this.getSoapClient().setTraceWriter(writer);
    }

    public void startSoapMonitor(int monitorPort) {
        this.getSoapClient().startSoapMonitor(monitorPort);
    }

    public void stopSoapMonitor() {
        this.getSoapClient().stopSoapMonitor();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

