/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.descriptor;

import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class LoggingConfig {
    public static final String MUSE_LOGGER_NAME = "org.apache.muse.core";
    private File _logFile = null;
    private Level _logLevel = null;

    protected Handler createLogHandler(File logFile) {
        StreamHandler handler = null;
        try {
            handler = new FileHandler(logFile.getAbsolutePath());
        }
        catch (IOException error) {
            error.printStackTrace();
            handler = new ConsoleHandler();
        }
        handler.setFormatter(new SimpleFormatter());
        return handler;
    }

    public File getLogFile() {
        return this._logFile;
    }

    public Level getLogLevel() {
        return this._logLevel;
    }

    public Logger newInstance() {
        File logFile = this.getLogFile();
        Level logLevel = this.getLogLevel();
        File logDir = logFile.getParentFile();
        logDir.mkdirs();
        Logger log = Logger.getLogger(MUSE_LOGGER_NAME);
        log.setLevel(logLevel);
        Handler handler = this.createLogHandler(logFile);
        log.addHandler(handler);
        return log;
    }

    public void setLogFile(File logFile) {
        this._logFile = logFile;
    }

    public void setLogLevel(Level logLevel) {
        this._logLevel = logLevel;
    }
}

