/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.descriptor;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.muse.core.Capability;
import org.apache.muse.core.Environment;
import org.apache.muse.core.Resource;
import org.apache.muse.core.descriptor.CapabilityDefinition;
import org.apache.muse.core.descriptor.WsdlConfig;
import org.apache.muse.core.routing.ResourceIdFactory;
import org.apache.muse.util.ReflectUtils;
import org.apache.muse.ws.addressing.EndpointReference;

public class ResourceDefinition {
    private Collection _capabilities = null;
    private String _contextPath = null;
    private Environment _environment = null;
    private ResourceIdFactory _idFactory = null;
    private boolean _isUsingPersistence = false;
    private Logger _log = null;
    private Map _parameters = null;
    private Class _resourceClass = null;
    private WsdlConfig _wsdl = null;

    public Collection getCapabilityDefinitions() {
        return this._capabilities;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public Environment getEnvironment() {
        return this._environment;
    }

    public Map getInitializationParameters() {
        return this._parameters;
    }

    public Logger getLog() {
        return this._log;
    }

    public Class getResourceClass() {
        return this._resourceClass;
    }

    public ResourceIdFactory getResourceIdFactory() {
        return this._idFactory;
    }

    public WsdlConfig getWsdlConfig() {
        return this._wsdl;
    }

    public boolean isUsingPersistence() {
        return this._isUsingPersistence;
    }

    public Resource newInstance() {
        Environment env = this.getEnvironment();
        Logger log = this.getLog();
        Class resourceClass = this.getResourceClass();
        Resource resource = (Resource)ReflectUtils.newInstance(resourceClass);
        resource.setEnvironment(env);
        resource.setLog(log);
        resource.setContextPath(this.getContextPath());
        resource.setInitializationParameters(this.getInitializationParameters());
        WsdlConfig wsdl = this.getWsdlConfig();
        resource.setWsdlPath(wsdl.getWsdlPath());
        resource.setWsdlPortType(wsdl.getWsdlPortType());
        EndpointReference uniqueEPR = env.getDeploymentEPR();
        ResourceIdFactory idFactory = this.getResourceIdFactory();
        if (idFactory != null) {
            QName id = idFactory.getIdentifierName();
            String value = idFactory.getNextIdentifier();
            uniqueEPR.addParameter(id, value);
        }
        resource.setEndpointReference(uniqueEPR);
        Iterator i = this.getCapabilityDefinitions().iterator();
        while (i.hasNext()) {
            CapabilityDefinition next = (CapabilityDefinition)i.next();
            Capability capability = next.newInstance();
            resource.addCapability(capability);
        }
        return resource;
    }

    public void setCapabilityDefinitions(Collection capabilities) {
        this._capabilities = capabilities;
    }

    public void setContextPath(String contextPath) {
        this._contextPath = contextPath;
    }

    public void setEnvironment(Environment environment) {
        this._environment = environment;
    }

    public void setInitializationParameters(Map parameters) {
        this._parameters = parameters;
    }

    public void setLog(Logger log) {
        this._log = log;
    }

    public void setResourceClass(Class resourceClass) {
        this._resourceClass = resourceClass;
    }

    public void setResourceIdFactory(ResourceIdFactory idFactory) {
        this._idFactory = idFactory;
    }

    public void setUsingPersistence(boolean isUsingPersistence) {
        this._isUsingPersistence = isUsingPersistence;
    }

    public void setWsdlConfig(WsdlConfig wsdl) {
        this._wsdl = wsdl;
    }
}

