/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.util.xml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.muse.util.xml.XmlSerializable;
import org.apache.muse.util.xml.XsdUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    public static final Document EMPTY_DOC = XmlUtils.createDocument();
    public static final String TARGET_NS = "targetNamespace";
    public static final String XML_HEADER = "<?xml version=\"1.0\"?>";
    public static final String XMLNS_PREFIX = "xmlns";
    public static final String W3C_XMLNS = "http://www.w3.org/2000/xmlns/";
    protected static final String INDENT_AMOUNT_XALAN = "{http://xml.apache.org/xalan}indent-amount";
    protected static final String INDENT_AMOUNT_XSLT = "{http://xml.apache.org/xslt}indent-amount";

    public static Node[] convertToArray(NodeList list) {
        int length = list.getLength();
        Node[] copy = new Node[length];
        int n = 0;
        while (n < length) {
            copy[n] = list.item(n);
            ++n;
        }
        return copy;
    }

    public static Node convertToNode(Document document, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Node) {
            return document.importNode((Node)value, true);
        }
        if (value instanceof XmlSerializable) {
            return ((XmlSerializable)value).toXML(document);
        }
        if (value instanceof Date) {
            value = XsdUtils.getLocalTimeString((Date)value);
        } else if (value instanceof QName) {
            value = XmlUtils.toString((QName)value);
        }
        return document.createTextNode(value.toString());
    }

    private static DocumentBuilder createBuilder() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        try {
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException error) {
            throw new RuntimeException(error.getMessage(), error);
        }
    }

    public static Document createDocument() {
        return XmlUtils.createBuilder().newDocument();
    }

    public static Document createDocument(File file) throws IOException, SAXException {
        return XmlUtils.createBuilder().parse(file);
    }

    public static Document createDocument(InputSource source) throws IOException, SAXException {
        return XmlUtils.createBuilder().parse(source);
    }

    public static Document createDocument(InputStream stream) throws IOException, SAXException {
        return XmlUtils.createBuilder().parse(stream);
    }

    public static Document createDocument(String xml) throws IOException, SAXException {
        InputSource source = new InputSource(new StringReader(xml));
        return XmlUtils.createDocument(source);
    }

    public static Document createDocument(URI uri) throws IOException, SAXException {
        return XmlUtils.createDocument(new File(uri));
    }

    public static Element createElement(Document doc, QName qname) {
        return XmlUtils.createElement(doc, qname, null);
    }

    public static Element createElement(Document doc, QName qname, Node value, boolean embedChildren) {
        Element root = XmlUtils.createEmptyElement(doc, qname);
        if (value == null) {
            return root;
        }
        if (embedChildren) {
            NamedNodeMap attributes = value.getAttributes();
            if (attributes != null) {
                String prefix = qname.getPrefix();
                String namespaceAttr = null;
                if (prefix != null && prefix.length() > 0) {
                    namespaceAttr = "xmlns:" + prefix;
                }
                int length = attributes.getLength();
                int n = 0;
                while (n < length) {
                    Node attr = attributes.item(n);
                    String nameString = attr.getNodeName();
                    String valueString = attr.getNodeValue();
                    if (!nameString.equals(namespaceAttr)) {
                        root.setAttribute(nameString, valueString);
                    }
                    ++n;
                }
            }
            NodeList children = value.getChildNodes();
            int length = children.getLength();
            int n = 0;
            while (n < length) {
                Node next = children.item(n);
                next = doc.importNode(next, true);
                root.appendChild(next);
                ++n;
            }
        } else {
            value = doc.importNode(value, true);
            root.appendChild(value);
        }
        return root;
    }

    public static Element createElement(Document doc, QName qname, Object value) {
        boolean embed = value instanceof Node || value instanceof XmlSerializable;
        Node valueNode = XmlUtils.convertToNode(doc, value);
        Element element = XmlUtils.createElement(doc, qname, valueNode, embed);
        if (value instanceof QName) {
            XmlUtils.setQNameNamespace(element, (QName)value);
        }
        return element;
    }

    public static Element createElement(QName qname) {
        return XmlUtils.createElement(qname, null);
    }

    public static Element createElement(QName qname, Object value) {
        return XmlUtils.createElement(EMPTY_DOC, qname, value);
    }

    private static Element createEmptyElement(Document doc, QName qname) {
        String prefix = qname.getPrefix();
        String name = qname.getLocalPart();
        if (prefix != null && prefix.length() > 0) {
            name = String.valueOf(prefix) + ':' + name;
        }
        String uri = qname.getNamespaceURI();
        return doc.createElementNS(uri, name);
    }

    public static boolean equals(Element e1, Element e2) {
        QName qname2;
        if (e1 == e2) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        QName qname1 = XmlUtils.getElementQName(e1);
        if (!qname1.equals(qname2 = XmlUtils.getElementQName(e2))) {
            return false;
        }
        return XmlUtils.haveMatchingChildren(e1, e2) && XmlUtils.haveMatchingAttributes(e1, e2);
    }

    public static String extractText(Element element) {
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        int n = 0;
        while (n < length) {
            Node next = children.item(n);
            if (next.getNodeType() == 3) {
                return next.getNodeValue().trim();
            }
            ++n;
        }
        return null;
    }

    public static Element findFirstInSubTree(Element context, QName qname) {
        Element[] results = XmlUtils.findInSubTree(context, qname);
        if (results.length == 0) {
            return null;
        }
        return results[0];
    }

    public static Element[] findInSubTree(Element context, QName qname) {
        String name = qname.getLocalPart();
        String uri = qname.getNamespaceURI();
        NodeList matches = context.getElementsByTagNameNS(uri, name);
        int length = matches.getLength();
        Element[] asArray = new Element[length];
        int n = 0;
        while (n < length) {
            asArray[n] = (Element)matches.item(n);
            ++n;
        }
        return asArray;
    }

    public static Element[] getAllElements(Node context) {
        return XmlUtils.getAllElements(context, "*");
    }

    public static Element[] getAllElements(Node context, String namespace) {
        return XmlUtils.getAllElements(context, namespace, "*");
    }

    public static Element[] getAllElements(Node context, String namespace, String localName) {
        boolean matchAllNames = localName.equals("*");
        boolean matchAllNamespaces = namespace.equals("*");
        NodeList children = context.getChildNodes();
        int totalLength = children.getLength();
        ArrayList<Node> elements = new ArrayList<Node>(totalLength);
        int n = 0;
        while (n < totalLength) {
            block5: {
                String nextNamespace;
                String nextName;
                Node next;
                block6: {
                    next = children.item(n);
                    if (next.getNodeType() != 1) break block5;
                    nextName = next.getLocalName();
                    nextNamespace = next.getNamespaceURI();
                    if (nextNamespace != null) break block6;
                    if (!matchAllNamespaces) break block5;
                    nextName = next.getNodeName();
                }
                if ((matchAllNamespaces || namespace.equals(nextNamespace)) && (matchAllNames || localName.equals(nextName))) {
                    elements.add(next);
                }
            }
            ++n;
        }
        Element[] resultsAsArray = new Element[elements.size()];
        return elements.toArray(resultsAsArray);
    }

    public static Map getAllNamespaces(Element xml) {
        return XmlUtils.getAllNamespaces(xml, new HashMap());
    }

    private static Map getAllNamespaces(Element xml, Map namespacesByPrefix) {
        QName qname = XmlUtils.getElementQName(xml);
        String prefix = qname.getPrefix();
        String namespace = qname.getNamespaceURI();
        namespacesByPrefix.put(prefix, namespace);
        Element[] children = XmlUtils.getAllElements(xml);
        int n = 0;
        while (n < children.length) {
            XmlUtils.getAllNamespaces(children[n], namespacesByPrefix);
            ++n;
        }
        return namespacesByPrefix;
    }

    public static String getAttribute(Element xml, QName qname) {
        String name;
        String uri = qname.getNamespaceURI();
        String value = xml.getAttributeNS(uri, name = qname.getLocalPart());
        if (value != null && value.length() == 0) {
            return null;
        }
        return value;
    }

    public static Boolean getBoolean(Element xml) {
        String text = XmlUtils.extractText(xml);
        return Boolean.valueOf(text);
    }

    public static Date getDate(Element xml) throws ParseException {
        String text = XmlUtils.extractText(xml);
        return text == null ? null : XsdUtils.getLocalTime(text);
    }

    public static Element getDocumentRoot(Node xml) {
        if (xml.getNodeType() != 9) {
            xml = xml.getOwnerDocument();
        }
        return XmlUtils.getFirstElement(xml);
    }

    public static Double getDouble(Element xml) {
        String text = XmlUtils.extractText(xml);
        return Double.valueOf(text);
    }

    public static Element getElement(Node context, QName qname) {
        return XmlUtils.getElement(context, qname, 0);
    }

    public static Element getElement(Node context, QName qname, int index) {
        String name = qname.getLocalPart();
        String uri = qname.getNamespaceURI();
        Element[] children = XmlUtils.getAllElements(context, uri, name);
        if (children.length == 0) {
            return null;
        }
        if (index >= children.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return children[index];
    }

    public static QName getElementQName(Element xml) {
        String uri = xml.getNamespaceURI();
        String prefix = xml.getPrefix();
        String name = xml.getLocalName();
        if (name == null) {
            return new QName(xml.getNodeName());
        }
        if (prefix != null && prefix.length() > 0) {
            return new QName(uri, name, prefix);
        }
        return new QName(uri, name);
    }

    public static Element[] getElements(Node context, QName qname) {
        String name = qname.getLocalPart();
        String namespace = qname.getNamespaceURI();
        return XmlUtils.getAllElements(context, namespace, name);
    }

    public static String[] getElementsText(Node context, QName qname) {
        Element[] elements = XmlUtils.getElements(context, qname);
        String[] text = new String[elements.length];
        int n = 0;
        while (n < elements.length) {
            text[n] = XmlUtils.extractText(elements[n]);
            ++n;
        }
        return text;
    }

    public static String getElementText(Node context, QName qname) {
        Element element = XmlUtils.getElement(context, qname);
        if (element == null) {
            return null;
        }
        return XmlUtils.extractText(element);
    }

    public static Element getFirstElement(Node context) {
        Element[] elements = XmlUtils.getAllElements(context);
        if (elements.length == 0) {
            return null;
        }
        return elements[0];
    }

    public static Float getFloat(Element xml) {
        String text = XmlUtils.extractText(xml);
        return Float.valueOf(text);
    }

    public static int getHashCode(Element xml) {
        String text = XmlUtils.extractText(xml);
        int hashCode = text == null ? 0 : text.hashCode();
        Element[] children = XmlUtils.getAllElements(xml);
        int n = 0;
        while (n < children.length) {
            hashCode += XmlUtils.getHashCode(children[n]);
            ++n;
        }
        return hashCode;
    }

    public static Integer getInteger(Element xml) {
        String text = XmlUtils.extractText(xml);
        return Integer.valueOf(text);
    }

    public static Long getLong(Element xml) {
        String text = XmlUtils.extractText(xml);
        return Long.valueOf(text);
    }

    public static QName getQName(Element xml) {
        String qnameString = XmlUtils.extractText(xml);
        if (qnameString == null) {
            return null;
        }
        return XmlUtils.parseQName(qnameString, xml);
    }

    public static QName getQNameFromChild(Element xml, QName childQName) {
        Element child = XmlUtils.getElement(xml, childQName);
        if (child == null) {
            return null;
        }
        return XmlUtils.getQName(child);
    }

    public static Short getShort(Element xml) {
        String text = XmlUtils.extractText(xml);
        return Short.valueOf(text);
    }

    public static boolean haveMatchingAttributes(Element e1, Element e2) {
        int length2;
        NamedNodeMap attr1 = e1.getAttributes();
        NamedNodeMap attr2 = e2.getAttributes();
        int length1 = attr1.getLength();
        NamedNodeMap larger = length1 >= (length2 = attr2.getLength()) ? attr1 : attr2;
        int largerLength = larger.getLength();
        int n = 0;
        while (n < largerLength) {
            Attr attr = (Attr)larger.item(n);
            String name = attr.getName();
            String value = attr.getValue();
            if (!name.startsWith("xmlns:")) {
                Attr match = (Attr)larger.getNamedItem(name);
                if (match == null) {
                    return false;
                }
                String matchValue = match.getValue();
                if (matchValue == null || !matchValue.equals(value)) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public static boolean haveMatchingChildren(Element e1, Element e2) {
        int length2;
        NodeList children1 = e1.getChildNodes();
        NodeList children2 = e2.getChildNodes();
        int length1 = children1.getLength();
        if (length1 != (length2 = children2.getLength())) {
            return false;
        }
        int n = 0;
        while (n < length1) {
            String text2;
            String text1;
            short type2;
            Node next1 = children1.item(n);
            Node next2 = children2.item(n);
            short type1 = next1.getNodeType();
            if (type1 != (type2 = next2.getNodeType())) {
                return false;
            }
            if (type1 == 3 ? !(text1 = next1.getNodeValue()).equals(text2 = next2.getNodeValue()) : type1 == 1 && !XmlUtils.equals((Element)next1, (Element)next2)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static Node moveSubTree(Node from, Node to) {
        return XmlUtils.moveSubTree(from, to, null);
    }

    public static Node moveSubTree(Node from, Node to, Node context) {
        NodeList children = from.getChildNodes();
        Node[] asArray = XmlUtils.convertToArray(children);
        Document fromDoc = from.getOwnerDocument();
        Document toDoc = to.getOwnerDocument();
        int n = 0;
        while (n < asArray.length) {
            from.removeChild(asArray[n]);
            if (fromDoc != toDoc) {
                asArray[n] = toDoc.importNode(asArray[n], true);
            }
            if (context == null) {
                to.appendChild(asArray[n]);
            } else {
                to.insertBefore(asArray[n], context);
            }
            ++n;
        }
        return to;
    }

    public static QName parseQName(String qname, Element namespaceContext) {
        int colonIndex = qname.indexOf(58);
        String prefix = null;
        if (colonIndex >= 0) {
            prefix = qname.substring(0, colonIndex);
        }
        String localName = qname.substring(colonIndex + 1);
        String uri = null;
        if (namespaceContext != null) {
            uri = XmlUtils.resolveNamespace(qname, namespaceContext);
        }
        if (prefix != null && prefix.length() > 0) {
            return new QName(uri, localName, prefix);
        }
        return new QName(uri, localName);
    }

    public static QName parseSchemaName(String name, Element namespaceContext) {
        String uri = XmlUtils.searchParentNamespaces(namespaceContext, TARGET_NS);
        return new QName(uri, name, "muse-op");
    }

    public static String resolveNamespace(String qname, Node xml) {
        int colonIndex = qname.indexOf(58);
        String attributeName = XMLNS_PREFIX;
        if (colonIndex >= 0) {
            String prefix = qname.substring(0, colonIndex);
            attributeName = String.valueOf(attributeName) + ':' + prefix;
        }
        return XmlUtils.searchParentNamespaces(xml, attributeName);
    }

    private static String searchParentNamespaces(Node xml, String attribute) {
        Node next = xml;
        String uri = null;
        while (next != null && (uri == null || uri.length() == 0)) {
            if (next.getNodeType() == 1) {
                uri = ((Element)next).getAttribute(attribute);
            }
            next = next.getParentNode();
        }
        if (uri != null && uri.length() == 0) {
            uri = null;
        }
        return uri;
    }

    public static void setElement(Element context, QName qname, Node node, boolean embedChildren) {
        Document doc = context.getOwnerDocument();
        Element next = XmlUtils.createElement(doc, qname, node, embedChildren);
        Element toReplace = XmlUtils.getElement(context, qname);
        if (toReplace == null) {
            context.appendChild(next);
        } else {
            context.replaceChild(next, toReplace);
        }
    }

    public static void setElement(Element context, QName qname, Object value) {
        Document doc = context.getOwnerDocument();
        boolean embedChildren = value instanceof Node || value instanceof XmlSerializable;
        Node valueNode = XmlUtils.convertToNode(doc, value);
        XmlUtils.setElement(context, qname, valueNode, embedChildren);
        if (value instanceof QName) {
            XmlUtils.setQNameNamespace(context, (QName)value);
        }
    }

    public static void setElementText(Element element, String text) {
        Node currentTextNode = null;
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        int n = 0;
        while (n < length && currentTextNode == null) {
            Node next = children.item(n);
            if (next.getNodeType() == 3) {
                currentTextNode = next;
            }
            ++n;
        }
        if (currentTextNode == null) {
            Document doc = element.getOwnerDocument();
            currentTextNode = doc.createTextNode("");
            currentTextNode = element.appendChild(currentTextNode);
        }
        currentTextNode.setNodeValue(text);
    }

    public static void setNamespaceAttribute(Element element, String prefix, String namespaceURI) {
        String attributeName = XMLNS_PREFIX;
        if (prefix != null) {
            attributeName = String.valueOf(attributeName) + ':' + prefix;
        }
        if (!element.hasAttribute(attributeName)) {
            element.setAttributeNS(W3C_XMLNS, attributeName, namespaceURI);
        }
    }

    private static void setQNameNamespace(Element xml, QName value) {
        String elementPrefix = xml.getPrefix();
        String valueURI = value.getNamespaceURI();
        String valuePrefix = value.getPrefix();
        if (valueURI != null && valueURI.length() > 0 && elementPrefix != null && !valuePrefix.equals(elementPrefix)) {
            XmlUtils.setNamespaceAttribute(xml, valuePrefix, valueURI);
        }
    }

    public static void toFile(Node xml, File file) throws IOException {
        XmlUtils.toFile(xml, file, true);
    }

    public static void toFile(Node xml, File file, boolean printHeader) throws IOException {
        String xmlString = XmlUtils.toString(xml, printHeader);
        FileWriter writer = new FileWriter(file);
        writer.write(xmlString);
        writer.close();
    }

    public static String toString(Node xml) {
        return XmlUtils.toString(xml, true);
    }

    public static String toString(Node xml, boolean printHeader) {
        return XmlUtils.toString(xml, printHeader, true);
    }

    public static String toString(Node xml, boolean printHeader, boolean printIndents) {
        short type = xml.getNodeType();
        if (type == 3) {
            return xml.getNodeValue();
        }
        StringWriter writer = new StringWriter();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", printHeader ? "no" : "yes");
            transformer.setOutputProperty("indent", printIndents ? "yes" : "no");
            transformer.setOutputProperty(INDENT_AMOUNT_XSLT, "3");
            transformer.setOutputProperty(INDENT_AMOUNT_XALAN, "3");
            transformer.transform(new DOMSource(xml), new StreamResult(writer));
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex.getLocalizedMessage(), ex);
        }
        return writer.toString();
    }

    public static String toString(QName qname) {
        String prefix = qname.getPrefix();
        String name = qname.getLocalPart();
        if (prefix == null || prefix.length() == 0) {
            return name;
        }
        return String.valueOf(prefix) + ':' + name;
    }
}

