/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.addressing.soap;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.MessageHeaders;
import org.apache.muse.ws.addressing.soap.SoapClient;
import org.apache.muse.ws.addressing.soap.SoapConstants;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleSoapClient
implements SoapClient {
    private static Messages _MESSAGES;
    private static final Element[] _EMPTY_ARRAY;
    private int _monitorPort = -1;
    private boolean _trace = false;
    private PrintWriter _traceWriter = new PrintWriter(System.out);
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.muse.ws.addressing.soap.SimpleSoapClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _MESSAGES = MessagesFactory.get(clazz);
        _EMPTY_ARRAY = new Element[0];
    }

    protected Element createMessage(EndpointReference source, EndpointReference destination, String action, Element[] bodyElements, Element[] extraHeaders) {
        Document doc = XmlUtils.createDocument();
        Element soapXML = XmlUtils.createElement(doc, SoapConstants.ENVELOPE_QNAME);
        MessageHeaders headers = new MessageHeaders(destination, action);
        if (source != null) {
            headers.setFromAddress(source);
        }
        Element headersXML = headers.toXML(doc);
        soapXML.appendChild(headersXML);
        int n = 0;
        while (n < extraHeaders.length) {
            if (extraHeaders[n].getNamespaceURI().equals("http://www.w3.org/2005/08/addressing")) {
                Object[] filler = new Object[]{XmlUtils.getElementQName(extraHeaders[n]), "http://www.w3.org/2005/08/addressing"};
                throw new RuntimeException(_MESSAGES.get("DuplicateAddressingHeader", filler));
            }
            extraHeaders[n] = (Element)doc.importNode(extraHeaders[n], true);
            headersXML.appendChild(extraHeaders[n]);
            ++n;
        }
        Element bodyXML = XmlUtils.createElement(doc, SoapConstants.BODY_QNAME);
        soapXML.appendChild(bodyXML);
        int n2 = 0;
        while (n2 < bodyElements.length) {
            bodyElements[n2] = (Element)doc.importNode(bodyElements[n2], true);
            bodyXML.appendChild(bodyElements[n2]);
            ++n2;
        }
        return soapXML;
    }

    protected URL getDestinationURL(EndpointReference destination) {
        URI uri = destination.getAddress();
        try {
            if (this.isUsingSoapMonitor()) {
                uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), this.getSoapMonitorPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            return uri.toURL();
        }
        catch (Throwable error) {
            throw new RuntimeException(error.getMessage(), error);
        }
    }

    public int getSoapMonitorPort() {
        return this._monitorPort;
    }

    public PrintWriter getTraceWriter() {
        return this._traceWriter;
    }

    public boolean isUsingSoapMonitor() {
        return this._monitorPort >= 0;
    }

    public boolean isUsingTrace() {
        return this._trace;
    }

    public Element[] send(EndpointReference src, EndpointReference dest, String wsaAction, Element[] body) {
        return this.send(src, dest, wsaAction, body, _EMPTY_ARRAY);
    }

    public Element[] send(EndpointReference src, EndpointReference dest, String wsaAction, Element[] body, Element[] extraHeaders) {
        if (dest == null) {
            throw new NullPointerException(_MESSAGES.get("NullDestinationEPR"));
        }
        if (wsaAction == null) {
            throw new NullPointerException(_MESSAGES.get("NullActionURI"));
        }
        if (body == null) {
            body = _EMPTY_ARRAY;
        }
        if (extraHeaders == null) {
            extraHeaders = _EMPTY_ARRAY;
        }
        Element soapRequest = this.createMessage(src, dest, wsaAction, body, extraHeaders);
        byte[] soapBytes = XmlUtils.toString(soapRequest).getBytes();
        if (this.isUsingTrace()) {
            this.trace(soapRequest, false);
        }
        Element soapResponse = null;
        try {
            URL url = this.getDestinationURL(dest);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-type", "application/soap+xml");
            connection.setDoOutput(true);
            connection.connect();
            OutputStream output = connection.getOutputStream();
            output.write(soapBytes);
            output.flush();
            output.close();
            int responseCode = connection.getResponseCode();
            InputStream response = null;
            response = responseCode == 200 ? connection.getInputStream() : connection.getErrorStream();
            Document responseDoc = XmlUtils.createDocument(response);
            soapResponse = XmlUtils.getFirstElement(responseDoc);
            response.close();
            connection.disconnect();
        }
        catch (Throwable error) {
            SoapFault soapFault = new SoapFault(error.getMessage(), error);
            return new Element[]{soapFault.toXML()};
        }
        if (this.isUsingTrace()) {
            this.trace(soapResponse, true);
        }
        Element responseBody = XmlUtils.getElement(soapResponse, SoapConstants.BODY_QNAME);
        return XmlUtils.getAllElements(responseBody);
    }

    public void setTrace(boolean trace) {
        this._trace = trace;
    }

    public void setTraceWriter(PrintWriter writer) {
        if (writer == null) {
            throw new NullPointerException(_MESSAGES.get("NullTraceWriter"));
        }
        this._traceWriter = writer;
    }

    public void startSoapMonitor(int monitorPort) {
        if (monitorPort < 1) {
            Object[] filler = new Object[]{new Integer(monitorPort)};
            throw new RuntimeException(_MESSAGES.get("InvalidPort", filler));
        }
        this._monitorPort = monitorPort;
    }

    public void stopSoapMonitor() {
        this._monitorPort = -1;
    }

    protected void trace(Element xml, boolean incoming) {
        PrintWriter writer = this.getTraceWriter();
        writer.write("[CLIENT TRACE] SOAP envelope contents (");
        writer.write(incoming ? "incoming" : "outgoing");
        writer.write("):\n\n");
        writer.write(XmlUtils.toString(xml, false));
        writer.write(10);
        writer.flush();
    }

    protected void trace(String message) {
        PrintWriter writer = this.getTraceWriter();
        writer.write("[CLIENT TRACE] ");
        writer.write(message);
        writer.write(10);
        writer.flush();
    }
}

