/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.dm.muws.events.impl;

import java.text.ParseException;
import java.util.Date;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.dm.muws.events.Situation;
import org.apache.muse.ws.dm.muws.events.SubstitutableMessage;
import org.apache.muse.ws.dm.muws.events.WefConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleSituation
implements Situation {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$ws$dm$muws$events$impl$SimpleSituation == null ? (class$org$apache$muse$ws$dm$muws$events$impl$SimpleSituation = SimpleSituation.class$("org.apache.muse.ws.dm.muws.events.impl.SimpleSituation")) : class$org$apache$muse$ws$dm$muws$events$impl$SimpleSituation);
    private QName[] _categoryType = null;
    private String _message = null;
    private short _priority = (short)-1;
    private short _severity = (short)-1;
    private Date _situationTime = new Date();
    private SubstitutableMessage _subMessage = null;
    private String _successDisposition = null;
    static /* synthetic */ Class class$org$apache$muse$ws$dm$muws$events$impl$SimpleSituation;

    public SimpleSituation() {
    }

    public SimpleSituation(Element xml) {
        Element severityXML;
        Element priorityXML;
        this.setMessage(XmlUtils.getElementText(xml, WefConstants.MESSAGE_QNAME));
        String disposition = XmlUtils.getElementText(xml, WefConstants.SUCCESS_DISPOSITION_QNAME);
        if (disposition != null) {
            this.setSuccessDisposition(disposition);
        }
        if ((priorityXML = XmlUtils.getElement(xml, WefConstants.PRIORITY_QNAME)) != null) {
            this._priority = XmlUtils.getShort(priorityXML);
        }
        if ((severityXML = XmlUtils.getElement(xml, WefConstants.SEVERITY_QNAME)) != null) {
            this._severity = XmlUtils.getShort(severityXML);
        }
        Element timeXML = XmlUtils.getElement(xml, WefConstants.SITUATION_TIME_QNAME);
        try {
            if (timeXML != null) {
                this._situationTime = XmlUtils.getDate(timeXML);
            }
        }
        catch (ParseException error) {
            throw new RuntimeException(error.getMessage(), error);
        }
        Element categoryXML = XmlUtils.getElement(xml, WefConstants.SITUATION_CATEGORY_QNAME);
        Element categoryTypeXML = XmlUtils.getFirstElement(categoryXML);
        LinkedList<QName> hierarchy = new LinkedList<QName>();
        while (categoryTypeXML != null) {
            QName categoryName = XmlUtils.getElementQName(categoryTypeXML);
            hierarchy.add(categoryName);
            categoryTypeXML = XmlUtils.getElement(categoryTypeXML, WefConstants.SITUATION_CATEGORY_QNAME);
        }
        this._categoryType = new QName[hierarchy.size()];
        this._categoryType = hierarchy.toArray(this._categoryType);
    }

    public final QName[] getCategoryType() {
        return this._categoryType;
    }

    public final String getMessage() {
        return this._message;
    }

    public final short getPriority() {
        return this._priority;
    }

    public final short getSeverity() {
        return this._severity;
    }

    public final Date getSituationTime() {
        return this._situationTime;
    }

    public final SubstitutableMessage getSubstitutableMessage() {
        return this._subMessage;
    }

    public final String getSuccessDisposition() {
        return this._successDisposition;
    }

    public final void setCategoryType(QName categoryType) {
        this.setCategoryType(new QName[]{categoryType});
    }

    public final void setCategoryType(QName[] categoryType) {
        if (categoryType == null || categoryType.length == 0) {
            throw new IllegalArgumentException(_MESSAGES.get("NoCategoryType"));
        }
        this._categoryType = categoryType;
    }

    public final void setMessage(String message) {
        this._message = message;
    }

    public final void setPriority(short priority) {
        if (priority < 0 || priority > 100) {
            Object[] filler = new Object[]{new Short(priority), new Short(0), new Short(100)};
            throw new IllegalArgumentException(_MESSAGES.get("PriorityOutOfBounds", filler));
        }
        this._priority = priority;
    }

    public final void setSeverity(short severity) {
        if (severity < 0 || severity > 6) {
            Object[] filler = new Object[]{new Short(severity), new Short(0), new Short(6)};
            throw new IllegalArgumentException(_MESSAGES.get("SeverityOutOfBounds", filler));
        }
        this._severity = severity;
    }

    public final void setSituationTime(Date situationTime) {
        this._situationTime = situationTime;
    }

    public final void setSubstitutableMessage(SubstitutableMessage message) {
        this._subMessage = message;
    }

    public final void setSuccessDisposition(String disposition) {
        if (!"Unsuccessful".equals(disposition) && !"Successful".equals(disposition)) {
            throw new IllegalArgumentException(_MESSAGES.get("InvalidDisposition", new Object[]{disposition}));
        }
        this._successDisposition = disposition;
    }

    public String toString() {
        return XmlUtils.toString(this.toXML(), false);
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document factory) {
        SubstitutableMessage subMessage;
        String message;
        short severity;
        short priority;
        Date time;
        Element situation = XmlUtils.createElement(factory, WefConstants.SITUATION_QNAME);
        QName[] type = this.getCategoryType();
        if (type == null || type.length == 0) {
            throw new IllegalArgumentException(_MESSAGES.get("NoCategoryType"));
        }
        Element categoryType = XmlUtils.createElement(factory, WefConstants.SITUATION_CATEGORY_QNAME);
        situation.appendChild(categoryType);
        Element parent = categoryType;
        for (int n = 0; n < type.length; ++n) {
            Element nextPart = XmlUtils.createElement(factory, type[n]);
            parent.appendChild(nextPart);
            parent = nextPart;
        }
        String disposition = this.getSuccessDisposition();
        if (disposition != null) {
            XmlUtils.setElement(situation, WefConstants.SUCCESS_DISPOSITION_QNAME, disposition);
        }
        if ((time = this.getSituationTime()) != null) {
            XmlUtils.setElement(situation, WefConstants.SITUATION_TIME_QNAME, time);
        }
        if ((priority = this.getPriority()) >= 0) {
            XmlUtils.setElement(situation, WefConstants.PRIORITY_QNAME, new Short(priority));
        }
        if ((severity = this.getSeverity()) >= 0) {
            XmlUtils.setElement(situation, WefConstants.SEVERITY_QNAME, new Short(severity));
        }
        if ((message = this.getMessage()) != null) {
            XmlUtils.setElement(situation, WefConstants.MESSAGE_QNAME, message);
        }
        if ((subMessage = this.getSubstitutableMessage()) != null) {
            XmlUtils.setElement(situation, WefConstants.SUBSTITUTABLE_MSG_QNAME, subMessage);
        }
        return situation;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

