/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.notification.impl;

import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.muse.core.Environment;
import org.apache.muse.core.serializer.SerializerRegistry;
import org.apache.muse.util.LoggingUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.notification.Filter;
import org.apache.muse.ws.notification.NotificationMessage;
import org.apache.muse.ws.notification.Policy;
import org.apache.muse.ws.notification.SubscriptionManager;
import org.apache.muse.ws.notification.WsnConstants;
import org.apache.muse.ws.notification.impl.FilterSerializer;
import org.apache.muse.ws.notification.remote.NotificationConsumerClient;
import org.apache.muse.ws.resource.impl.AbstractWsResourceCapability;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleSubscriptionManager
extends AbstractWsResourceCapability
implements SubscriptionManager {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$ws$notification$impl$SimpleSubscriptionManager == null ? (class$org$apache$muse$ws$notification$impl$SimpleSubscriptionManager = SimpleSubscriptionManager.class$("org.apache.muse.ws.notification.impl.SimpleSubscriptionManager")) : class$org$apache$muse$ws$notification$impl$SimpleSubscriptionManager);
    private static final String _TRACE_PARAM = "trace-notifications";
    private static final String _TRY_PARAM = "number-of-tries";
    private static final String _DESTROY_PARAM = "destroy-on-failure";
    private NotificationConsumerClient _client = null;
    private EndpointReference _consumer = null;
    private Date _creationTime = new Date();
    private Filter _filter = null;
    private boolean _isDestroyedOnFailure = false;
    private boolean _isPaused = false;
    private boolean _isUsingTrace = false;
    private int _numberOfTries = 1;
    private EndpointReference _producer = null;
    static /* synthetic */ Class class$org$apache$muse$ws$notification$impl$SimpleSubscriptionManager;
    static /* synthetic */ Class class$org$apache$muse$ws$notification$Filter;

    protected NotificationConsumerClient createConsumerClient() {
        EndpointReference consumer = this.getConsumerReference();
        EndpointReference producer = this.getProducerReference();
        Environment env = this.getEnvironment();
        NotificationConsumerClient client = new NotificationConsumerClient(consumer, producer, env);
        client.setTrace(this.isUsingTrace());
        return client;
    }

    protected synchronized NotificationConsumerClient getConsumerClient() {
        if (this._client == null) {
            this._client = this.createConsumerClient();
        }
        return this._client;
    }

    public EndpointReference getConsumerReference() {
        return this._consumer;
    }

    public Date getCreationTime() {
        return this._creationTime;
    }

    public Filter getFilter() {
        return this._filter;
    }

    protected int getNumberOfTries() {
        return this._numberOfTries;
    }

    public EndpointReference getProducerReference() {
        return this._producer;
    }

    public QName[] getPropertyNames() {
        return SubscriptionManager.PROPERTIES;
    }

    public Policy getSubscriptionPolicy() {
        return null;
    }

    public void initialize() throws SoapFault {
        String retryString;
        super.initialize();
        SerializerRegistry.getInstance().registerSerializer(class$org$apache$muse$ws$notification$Filter == null ? (class$org$apache$muse$ws$notification$Filter = SimpleSubscriptionManager.class$("org.apache.muse.ws.notification.Filter")) : class$org$apache$muse$ws$notification$Filter, new FilterSerializer());
        String traceString = this.getInitializationParameter(_TRACE_PARAM);
        if (traceString != null) {
            this._isUsingTrace = Boolean.valueOf(traceString);
        }
        if ((retryString = this.getInitializationParameter(_TRY_PARAM)) != null) {
            this._numberOfTries = Integer.valueOf(retryString);
        }
        if (this._numberOfTries <= 0) {
            throw new RuntimeException(_MESSAGES.get("InvalidNumberOfTries"));
        }
        String destroyString = this.getInitializationParameter(_DESTROY_PARAM);
        if (destroyString != null) {
            this._isDestroyedOnFailure = Boolean.valueOf(destroyString);
        }
    }

    protected synchronized boolean isDestroyedOnFailure() {
        return this._isDestroyedOnFailure;
    }

    public synchronized boolean isPaused() {
        return this._isPaused;
    }

    protected boolean isUsingTrace() {
        return this._isUsingTrace;
    }

    public synchronized void pauseSubscription() {
        this._isPaused = true;
    }

    public void publish(NotificationMessage message) {
        if (this.isPaused() || !this.getFilter().accepts(message)) {
            return;
        }
        message.setProducerReference(this.getProducerReference());
        message.setSubscriptionReference(this.getResource().getEndpointReference());
        boolean success = false;
        int tries = this.getNumberOfTries();
        for (int n = 0; n < tries && !success; ++n) {
            try {
                NotificationConsumerClient client = this.getConsumerClient();
                client.notify(new NotificationMessage[]{message});
                success = true;
                continue;
            }
            catch (SoapFault error) {
                LoggingUtils.logError(this.getLog(), error);
                Object[] filler = new Object[]{error.getMessage()};
                this.getLog().info(_MESSAGES.get("LastPublishFailed", filler));
            }
        }
        try {
            if (!success && this.isDestroyedOnFailure()) {
                this.getResource().shutdown();
            }
        }
        catch (SoapFault error) {
            LoggingUtils.logError(this.getLog(), error);
        }
    }

    public synchronized void resumeSubscription() {
        this._isPaused = false;
    }

    public void setConsumerReference(EndpointReference consumer) {
        if (consumer == null) {
            throw new NullPointerException(_MESSAGES.get("NullConsumerEPR"));
        }
        this._consumer = consumer;
    }

    public void setFilter(Filter filter) {
        this._filter = filter;
    }

    public void setProducerReference(EndpointReference producer) {
        if (producer == null) {
            throw new NullPointerException(_MESSAGES.get("NullProducerEPR"));
        }
        this._producer = producer;
    }

    public void setSubscriptionPolicy(Policy policy) {
        Object[] filler = new Object[]{policy};
        this.getLog().warning(_MESSAGES.get("PolicyNotSupported", filler));
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        Element root = XmlUtils.createElement(doc, WsnConstants.SUBSCRIBE_QNAME);
        EndpointReference sub = this.getWsResource().getEndpointReference();
        EndpointReference consumer = this.getConsumerReference();
        EndpointReference producer = this.getProducerReference();
        Filter filter = this.getFilter();
        XmlUtils.setElement(root, WsnConstants.SUBSCRIPTION_EPR_QNAME, sub);
        XmlUtils.setElement(root, WsnConstants.CONSUMER_QNAME, consumer);
        XmlUtils.setElement(root, WsnConstants.PRODUCER_QNAME, producer);
        XmlUtils.setElement(root, WsnConstants.FILTER_QNAME, filter);
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

