/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.notification.properties;

import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlSerializable;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.notification.NotificationMessage;
import org.apache.muse.ws.resource.properties.WsrpConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ResourcePropertyChangeEvent
implements XmlSerializable {
    private Element[] _newValues = null;
    private Element[] _oldValues = null;
    private QName _propertyName = null;

    public ResourcePropertyChangeEvent(QName propertyName, Element[] oldValues, Element[] newValues) {
        this._propertyName = propertyName;
        this._oldValues = oldValues;
        this._newValues = newValues;
    }

    public ResourcePropertyChangeEvent(NotificationMessage message) {
        this._propertyName = message.getTopic();
        Element wsrpXML = message.getMessageContent(WsrpConstants.NOTIFICATION_QNAME);
        Element oldValuesXML = XmlUtils.getElement(wsrpXML, WsrpConstants.OLD_VALUES_QNAME);
        Element newValuesXML = XmlUtils.getElement(wsrpXML, WsrpConstants.NEW_VALUES_QNAME);
        this._oldValues = XmlUtils.getAllElements(oldValuesXML);
        this._newValues = XmlUtils.getAllElements(newValuesXML);
    }

    public Element[] getNewValues() {
        return this._newValues;
    }

    public Element[] getOldValues() {
        return this._oldValues;
    }

    public QName getPropertyName() {
        return this._propertyName;
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        int n;
        Element root = XmlUtils.createElement(doc, WsrpConstants.NOTIFICATION_QNAME);
        QName propertyName = this.getPropertyName();
        Element[] oldValues = this.getOldValues();
        Element[] newValues = this.getNewValues();
        Element oldValueXML = XmlUtils.createElement(doc, WsrpConstants.OLD_VALUES_QNAME);
        Element newValueXML = XmlUtils.createElement(doc, WsrpConstants.NEW_VALUES_QNAME);
        root.appendChild(oldValueXML);
        root.appendChild(newValueXML);
        for (n = 0; n < oldValues.length; ++n) {
            oldValues[n] = oldValues[n] == null ? XmlUtils.createElement(doc, propertyName) : (Element)doc.importNode(oldValues[n], true);
            oldValueXML.appendChild(oldValues[n]);
        }
        for (n = 0; n < newValues.length; ++n) {
            newValues[n] = newValues[n] == null ? XmlUtils.createElement(doc, propertyName) : (Element)doc.importNode(newValues[n], true);
            newValueXML.appendChild(newValues[n]);
        }
        return root;
    }
}

