/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.notification.remote;

import org.apache.muse.core.Environment;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapClient;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.notification.NotificationMessage;
import org.apache.muse.ws.notification.WsnConstants;
import org.apache.muse.ws.resource.remote.WsResourceClient;
import org.w3c.dom.Element;

public class NotificationConsumerClient
extends WsResourceClient {
    public NotificationConsumerClient(EndpointReference destination) {
        super(destination);
    }

    public NotificationConsumerClient(EndpointReference destination, EndpointReference source) {
        super(destination, source);
    }

    public NotificationConsumerClient(EndpointReference destination, EndpointReference source, Environment environment) {
        super(destination, source, environment);
    }

    public NotificationConsumerClient(EndpointReference destination, EndpointReference source, SoapClient soapClient) {
        super(destination, source, soapClient);
    }

    public EndpointReference getProducerReference() {
        return this.getSource();
    }

    public EndpointReference getConsumerReference() {
        return this.getDestination();
    }

    public void notify(NotificationMessage message) throws SoapFault {
        this.notify(new NotificationMessage[]{message});
    }

    public void notify(NotificationMessage[] messages) throws SoapFault {
        EndpointReference epr = this.getProducerReference();
        for (int n = 0; n < messages.length; ++n) {
            messages[n].setProducerReference(epr);
        }
        Element notify = XmlUtils.createElement(WsnConstants.NOTIFY_QNAME);
        for (int n = 0; n < messages.length; ++n) {
            notify.appendChild(messages[n].toXML());
        }
        this.invoke("http://docs.oasis-open.org/wsn/bw-2/NotificationConsumer/NotifyRequest", notify);
    }
}

