/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.resource.metadata.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.muse.util.StringUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.resource.metadata.MetadataDescriptor;
import org.apache.muse.ws.resource.metadata.WsrmdConstants;
import org.apache.muse.ws.resource.metadata.impl.PropertyMetadata;
import org.apache.muse.ws.resource.properties.impl.WsrpUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleMetadataDescriptor
implements MetadataDescriptor {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$ws$resource$metadata$impl$SimpleMetadataDescriptor == null ? (class$org$apache$muse$ws$resource$metadata$impl$SimpleMetadataDescriptor = SimpleMetadataDescriptor.class$("org.apache.muse.ws.resource.metadata.impl.SimpleMetadataDescriptor")) : class$org$apache$muse$ws$resource$metadata$impl$SimpleMetadataDescriptor);
    private String _name = null;
    private Map _propertiesByQName = new HashMap();
    private QName _wsdlInterface = null;
    private String _wsdlLocation = null;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$metadata$impl$SimpleMetadataDescriptor;
    static /* synthetic */ Class class$java$lang$String;

    public SimpleMetadataDescriptor(String name, String wsdlLocation, QName wsdlInterface) {
        this._name = name;
        this._wsdlLocation = wsdlLocation;
        this._wsdlInterface = wsdlInterface;
        String prefix = this._wsdlInterface.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            this._wsdlInterface = new QName(this._wsdlInterface.getNamespaceURI(), this._wsdlInterface.getLocalPart(), "muse-wsdl");
        }
    }

    public SimpleMetadataDescriptor(Element xml) {
        if (xml == null) {
            throw new NullPointerException(_MESSAGES.get("NullDescriptorElement"));
        }
        this._name = xml.getAttribute("name");
        if (this._name == null || this._name.length() == 0) {
            throw new RuntimeException(_MESSAGES.get("NoDescriptorName"));
        }
        String interfaceString = xml.getAttribute("interface");
        if (interfaceString == null || interfaceString.length() == 0) {
            throw new RuntimeException(_MESSAGES.get("NoDescriptorInterface"));
        }
        this._wsdlInterface = XmlUtils.parseQName(interfaceString, xml);
        String uriList = xml.getAttribute("wsdlLocation");
        if (uriList == null || uriList.length() == 0) {
            throw new RuntimeException(_MESSAGES.get("NoDescriptorWSDLLocation"));
        }
        String[] values = StringUtils.split(uriList);
        if (values.length != 2) {
            Object[] filler = new Object[]{uriList};
            throw new RuntimeException(_MESSAGES.get("InvalidWSDLLocation", filler));
        }
        this._wsdlLocation = values[1];
        Element[] properties = XmlUtils.getElements(xml, WsrmdConstants.PROPERTY_QNAME);
        for (int n = 0; n < properties.length; ++n) {
            PropertyMetadata metadata = new PropertyMetadata(properties[n]);
            this._propertiesByQName.put(metadata.getPropertyName(), metadata);
        }
    }

    private void addProperty(PropertyMetadata property) {
        QName name = property.getPropertyName();
        if (this.hasProperty(name)) {
            throw new RuntimeException(_MESSAGES.get("PropertyExists", new Object[]{property}));
        }
        this._propertiesByQName.put(name, property);
    }

    public void addProperty(QName property, String modifiability, String mutability) {
        this.addProperty(new PropertyMetadata(property, modifiability, mutability));
    }

    public boolean canDelete(QName propertyQName) {
        PropertyMetadata property = this.getProperty(propertyQName);
        return property.getMutability() == 5;
    }

    public boolean canInsert(QName propertyQName) {
        int mutability = this.getProperty(propertyQName).getMutability();
        return mutability == 3 || mutability == 5;
    }

    public boolean canUpdate(QName propertyQName) {
        PropertyMetadata property = this.getProperty(propertyQName);
        return property.getMutability() == 5;
    }

    private Collection convertToObjects(Collection values, Class type) throws SoapFault {
        Element[] asArray = new Element[values.size()];
        asArray = values.toArray(asArray);
        Object[] objects = (Object[])WsrpUtils.convertToObjects(asArray, type);
        return Arrays.asList(objects);
    }

    private Collection convertToXML(QName property, Collection values) throws SoapFault {
        Object[] asArray = new Object[values.size()];
        asArray = values.toArray(asArray);
        Class type = null;
        Iterator i = values.iterator();
        while (type == null && i.hasNext()) {
            Object next = i.next();
            if (next == null) continue;
            type = next.getClass();
        }
        if (type == null) {
            type = class$java$lang$String == null ? (class$java$lang$String = SimpleMetadataDescriptor.class$("java.lang.String")) : class$java$lang$String;
        }
        Element[] xml = WsrpUtils.convertToElements(asArray, type, property);
        return Arrays.asList(xml);
    }

    public String getExtendedMetadata(QName propertyQName, QName elementName) {
        return this.getProperty(propertyQName).getExtendedMetadata(elementName);
    }

    public Collection getExtendedMetadataNames(QName propertyQName) {
        return this.getProperty(propertyQName).getExtendedMetadataNames();
    }

    public Collection getInitialValues(QName propertyQName) {
        return this.getProperty(propertyQName).getInitialValues();
    }

    public Collection getInitialValues(QName propertyQName, Class javaType) throws SoapFault {
        Collection values = this.getProperty(propertyQName).getInitialValues();
        return this.convertToObjects(values, javaType);
    }

    public QName getInterface() {
        return this._wsdlInterface;
    }

    public String getLowerBound(QName propertyQName) {
        return this.getProperty(propertyQName).getLowerBound();
    }

    public String getModifiability(QName propertyQName) {
        return this.getProperty(propertyQName).getModifiabilityString();
    }

    public String getMutability(QName propertyQName) {
        return this.getProperty(propertyQName).getMutabilityString();
    }

    public String getName() {
        return this._name;
    }

    private PropertyMetadata getProperty(QName propertyQName) {
        PropertyMetadata property = (PropertyMetadata)this._propertiesByQName.get(propertyQName);
        if (property == null) {
            Object[] filler = new Object[]{propertyQName};
            throw new RuntimeException(_MESSAGES.get("UndefinedProperty", filler));
        }
        return property;
    }

    public Collection getPropertyNames() {
        return Collections.unmodifiableSet(this._propertiesByQName.keySet());
    }

    public Collection getStaticValues(QName propertyQName) {
        return this.getProperty(propertyQName).getStaticValues();
    }

    public Collection getStaticValues(QName propertyQName, Class javaType) throws SoapFault {
        Collection values = this.getProperty(propertyQName).getStaticValues();
        return this.convertToObjects(values, javaType);
    }

    public String getUpperBound(QName propertyQName) {
        return this.getProperty(propertyQName).getUpperBound();
    }

    public Collection getValidValues(QName propertyQName) {
        return this.getProperty(propertyQName).getValidValues();
    }

    public Collection getValidValues(QName propertyQName, Class javaType) throws SoapFault {
        Collection values = this.getProperty(propertyQName).getValidValues();
        return this.convertToObjects(values, javaType);
    }

    public String getWsdlLocation() {
        return this._wsdlLocation;
    }

    public boolean hasProperty(QName propertyQName) {
        return this._propertiesByQName.containsKey(propertyQName);
    }

    public boolean isInitialValue(QName propertyQName, Object value) {
        return this.getProperty(propertyQName).isInitialValue(value);
    }

    public boolean isReadOnlyExternal(QName propertyQName) {
        PropertyMetadata property = this.getProperty(propertyQName);
        return property.getModifiability() == 1;
    }

    public boolean isStaticValue(QName propertyQName, Object value) {
        return this.getProperty(propertyQName).isStaticValue(value);
    }

    public boolean isValidValue(QName propertyQName, Object value) {
        return this.getProperty(propertyQName).isValidValue(value);
    }

    public void removeProperty(QName property) {
        this._propertiesByQName.remove(property);
    }

    public void setExtendedMetadata(QName property, QName elementName, String value) {
        this.getProperty(property).setExtendedMetadata(elementName, value);
    }

    public void setInitialValues(QName property, Collection values) throws SoapFault {
        values = this.convertToXML(property, values);
        this.getProperty(property).setInitialValues(values);
    }

    public void setLowerBound(QName property, String value) {
        this.getProperty(property).setLowerBound(value);
    }

    public void setModifiability(QName property, String value) {
        this.getProperty(property).setModifiability(value);
    }

    public void setMutability(QName property, String value) {
        this.getProperty(property).setMutability(value);
    }

    public void setPropertyName(QName currentProperty, QName newProperty) {
        if (this.hasProperty(newProperty)) {
            throw new RuntimeException(_MESSAGES.get("PropertyExists", new Object[]{newProperty}));
        }
        PropertyMetadata prop = this.getProperty(currentProperty);
        prop.setPropertyName(newProperty);
        this.removeProperty(currentProperty);
        this.addProperty(prop);
    }

    public void setStaticValues(QName property, Collection values) throws SoapFault {
        values = this.convertToXML(property, values);
        this.getProperty(property).setStaticValues(values);
    }

    public void setUpperBound(QName property, String value) {
        this.getProperty(property).setUpperBound(value);
    }

    public void setValidValues(QName property, Collection values) throws SoapFault {
        values = this.convertToXML(property, values);
        this.getProperty(property).setValidValues(values);
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        Element root = XmlUtils.createElement(doc, WsrmdConstants.DESCRIPTOR_QNAME);
        root.setAttribute("name", this.getName());
        QName portType = this.getInterface();
        root.setAttribute("interface", XmlUtils.toString(portType));
        XmlUtils.setNamespaceAttribute(root, portType.getPrefix(), portType.getNamespaceURI());
        root.setAttribute("wsdlLocation", "http://docs.oasis-open.org/wsrf/rmd-1 " + this.getWsdlLocation());
        Iterator i = this.getPropertyNames().iterator();
        while (i.hasNext()) {
            PropertyMetadata property = this.getProperty((QName)i.next());
            Element propertyXML = property.toXML(doc);
            root.appendChild(propertyXML);
        }
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

