/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.resource.sg.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.muse.core.Persistence;
import org.apache.muse.core.Resource;
import org.apache.muse.core.ResourceManager;
import org.apache.muse.core.ResourceManagerListener;
import org.apache.muse.core.serializer.SerializerRegistry;
import org.apache.muse.util.LoggingUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.apache.muse.ws.resource.ext.faults.ResourceInitializationFault;
import org.apache.muse.ws.resource.impl.AbstractWsResourceCapability;
import org.apache.muse.ws.resource.lifetime.ScheduledTermination;
import org.apache.muse.ws.resource.sg.Entry;
import org.apache.muse.ws.resource.sg.MembershipContentRule;
import org.apache.muse.ws.resource.sg.ServiceGroup;
import org.apache.muse.ws.resource.sg.ServiceGroupPersistence;
import org.apache.muse.ws.resource.sg.WssgConstants;
import org.apache.muse.ws.resource.sg.faults.AddRefusedFault;
import org.apache.muse.ws.resource.sg.impl.MembershipContentRuleSerializer;
import org.w3c.dom.Element;

public class SimpleServiceGroup
extends AbstractWsResourceCapability
implements ServiceGroup,
ResourceManagerListener {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$ws$resource$sg$impl$SimpleServiceGroup == null ? (class$org$apache$muse$ws$resource$sg$impl$SimpleServiceGroup = SimpleServiceGroup.class$("org.apache.muse.ws.resource.sg.impl.SimpleServiceGroup")) : class$org$apache$muse$ws$resource$sg$impl$SimpleServiceGroup);
    private static final MembershipContentRule[] _EMPTY_CONTENT_RULES = new MembershipContentRule[0];
    private MembershipContentRule[] _contentRules = null;
    private Map _entriesByMemberEPR = new HashMap();
    private String _entryPath = null;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$sg$impl$SimpleServiceGroup;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$sg$Entry;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$sg$ServiceGroupPersistence;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$sg$MembershipContentRule;

    public WsResource addEntry(EndpointReference memberEPR, Element content, Date termination) throws AddRefusedFault, BaseFault {
        WsResource entry = this.createEntry(memberEPR, content, termination);
        return this.addEntry(memberEPR, entry);
    }

    public WsResource addEntry(EndpointReference memberEPR, WsResource entry) {
        this._entriesByMemberEPR.put(memberEPR, entry);
        return entry;
    }

    protected WsResource createEntry(EndpointReference epr, Element content, Date termination) throws AddRefusedFault, ResourceInitializationFault, BaseFault {
        if (epr == null) {
            throw new NullPointerException(_MESSAGES.get("NullMemberServiceEPR"));
        }
        WsResource sg = this.getWsResource();
        if (!this.isMatch(epr)) {
            throw new AddRefusedFault(_MESSAGES.get("ContentCreationFailed"));
        }
        ResourceManager manager = sg.getResourceManager();
        String endpoint = this.getEntryContextPath();
        WsResource resource = null;
        try {
            resource = (WsResource)manager.createResource(endpoint);
        }
        catch (SoapFault error) {
            throw new ResourceInitializationFault(error);
        }
        if (termination != null && !resource.hasCapability("http://docs.oasis-open.org/wsrf/rlw-2/ScheduledResourceTermination")) {
            Object[] filler = new Object[]{endpoint, "http://docs.oasis-open.org/wsrf/rlw-2/ScheduledResourceTermination"};
            throw new AddRefusedFault(_MESSAGES.get("NoWSRL", filler));
        }
        Entry entry = (Entry)resource.getCapability("http://docs.oasis-open.org/wsrf/sgw-2/ServiceGroupEntry");
        entry.setServiceGroup(sg);
        entry.setMemberEPR(epr);
        try {
            resource.initialize();
            manager.addResource(resource.getEndpointReference(), resource);
        }
        catch (SoapFault error) {
            throw new ResourceInitializationFault(error);
        }
        if (resource.hasCapability("http://docs.oasis-open.org/wsrf/rlw-2/ScheduledResourceTermination")) {
            ScheduledTermination wsrl = (ScheduledTermination)resource.getCapability("http://docs.oasis-open.org/wsrf/rlw-2/ScheduledResourceTermination");
            wsrl.setTerminationTime(termination);
        }
        return resource;
    }

    protected MembershipContentRule[] createMembershipContentRules() {
        return _EMPTY_CONTENT_RULES;
    }

    public QName[] getContentElements() {
        MembershipContentRule[] rules = this.getMembershipContentRule();
        ArrayList<QName> allContent = new ArrayList<QName>();
        for (int n = 0; n < rules.length; ++n) {
            QName[] content = rules[n].getContentElements();
            allContent.addAll(Arrays.asList(content));
        }
        QName[] array = new QName[allContent.size()];
        return allContent.toArray(array);
    }

    public WsResource[] getEntry() {
        Collection entryResources = this._entriesByMemberEPR.values();
        WsResource[] asArray = new WsResource[entryResources.size()];
        return entryResources.toArray(asArray);
    }

    public WsResource getEntry(EndpointReference memberEPR) {
        return (WsResource)this._entriesByMemberEPR.get(memberEPR);
    }

    protected String getEntryContextPath() {
        return this._entryPath;
    }

    protected Element[] getEntryElements() {
        WsResource[] entries = this.getEntry();
        Element[] entryXML = new Element[entries.length];
        for (int n = 0; n < entries.length; ++n) {
            Entry entryCap = (Entry)entries[n].getCapability("http://docs.oasis-open.org/wsrf/sgw-2/ServiceGroupEntry");
            entryXML[n] = entryCap.toXML();
        }
        return entryXML;
    }

    public MembershipContentRule[] getMembershipContentRule() {
        return this._contentRules;
    }

    public Element[] getProperty(QName property) throws BaseFault {
        if (property.equals(WssgConstants.ENTRY_QNAME)) {
            return this.getEntryElements();
        }
        return super.getProperty(property);
    }

    public QName[] getPropertyNames() {
        return ServiceGroup.PROPERTIES;
    }

    public void initialize() throws SoapFault {
        super.initialize();
        MembershipContentRule[] mcr = this.createMembershipContentRules();
        this.setMembershipContentRule(mcr);
        WsResource resource = this.getWsResource();
        ResourceManager manager = resource.getResourceManager();
        this._entryPath = manager.getResourceContextPath(class$org$apache$muse$ws$resource$sg$Entry == null ? (class$org$apache$muse$ws$resource$sg$Entry = SimpleServiceGroup.class$("org.apache.muse.ws.resource.sg.Entry")) : class$org$apache$muse$ws$resource$sg$Entry);
        if (this._entryPath == null) {
            throw new RuntimeException(_MESSAGES.get("NoEntryEndpoint"));
        }
        Persistence persistence = this.getPersistence();
        if (persistence != null) {
            if (!(class$org$apache$muse$ws$resource$sg$ServiceGroupPersistence == null ? (class$org$apache$muse$ws$resource$sg$ServiceGroupPersistence = SimpleServiceGroup.class$("org.apache.muse.ws.resource.sg.ServiceGroupPersistence")) : class$org$apache$muse$ws$resource$sg$ServiceGroupPersistence).isAssignableFrom(persistence.getClass())) {
                Object[] filler = new Object[]{class$org$apache$muse$ws$resource$sg$ServiceGroupPersistence == null ? (class$org$apache$muse$ws$resource$sg$ServiceGroupPersistence = SimpleServiceGroup.class$("org.apache.muse.ws.resource.sg.ServiceGroupPersistence")) : class$org$apache$muse$ws$resource$sg$ServiceGroupPersistence, persistence.getClass()};
                throw new RuntimeException(_MESSAGES.get("IncorrectPersistenceRoot", filler));
            }
            ServiceGroupPersistence sgP = (ServiceGroupPersistence)persistence;
            sgP.setServiceGroup(resource);
        }
        manager.addListener(this);
        SerializerRegistry registry = SerializerRegistry.getInstance();
        registry.registerSerializer(class$org$apache$muse$ws$resource$sg$MembershipContentRule == null ? (class$org$apache$muse$ws$resource$sg$MembershipContentRule = SimpleServiceGroup.class$("org.apache.muse.ws.resource.sg.MembershipContentRule")) : class$org$apache$muse$ws$resource$sg$MembershipContentRule, new MembershipContentRuleSerializer());
    }

    public boolean isMatch(EndpointReference epr) {
        MembershipContentRule[] rules = this.getMembershipContentRule();
        for (int n = 0; n < rules.length; ++n) {
            if (rules[n].isMatch(epr)) continue;
            return false;
        }
        return true;
    }

    public void removeEntry(WsResource entry) {
        if (entry == null) {
            throw new NullPointerException(_MESSAGES.get("NullEntry"));
        }
        Iterator i = this._entriesByMemberEPR.keySet().iterator();
        EndpointReference memberEPR = null;
        while (i.hasNext() && memberEPR == null) {
            EndpointReference nextEPR = (EndpointReference)i.next();
            WsResource nextEntry = (WsResource)this._entriesByMemberEPR.get(nextEPR);
            if (entry != nextEntry) continue;
            memberEPR = nextEPR;
        }
        if (this._entriesByMemberEPR.remove(memberEPR) == null) {
            throw new RuntimeException(_MESSAGES.get("EntryNotFound"));
        }
        ServiceGroupPersistence persistence = (ServiceGroupPersistence)this.getPersistence();
        try {
            if (persistence != null) {
                persistence.resourceRemoved(entry.getEndpointReference());
            }
        }
        catch (SoapFault fault) {
            LoggingUtils.logError(this.getLog(), fault);
        }
    }

    public void resourceAdded(EndpointReference epr, Resource resource) throws SoapFault {
        if (resource.hasCapability("http://docs.oasis-open.org/wsrf/sgw-2/ServiceGroup") || resource.hasCapability("http://docs.oasis-open.org/wsrf/sgw-2/ServiceGroupEntry")) {
            return;
        }
        if (this.getEntry(epr) != null) {
            return;
        }
        if (!this.isMatch(epr)) {
            return;
        }
        Date termination = null;
        if (resource.hasCapability("http://docs.oasis-open.org/wsrf/rlw-2/ScheduledResourceTermination")) {
            ScheduledTermination wsrl = (ScheduledTermination)resource.getCapability("http://docs.oasis-open.org/wsrf/rlw-2/ScheduledResourceTermination");
            termination = wsrl.getTerminationTime();
        }
        WsResource entry = this.addEntry(epr, null, termination);
        ServiceGroupPersistence persistence = (ServiceGroupPersistence)this.getPersistence();
        try {
            if (persistence != null) {
                persistence.resourceAdded(entry.getEndpointReference(), entry);
            }
        }
        catch (SoapFault fault) {
            throw new AddRefusedFault(fault);
        }
    }

    public void resourceRemoved(EndpointReference epr) {
        if (this.hasBeenShutdown()) {
            this.getWsResource().getResourceManager().removeListener(this);
        } else {
            WsResource entry = this.getEntry(epr);
            if (entry != null) {
                this.removeEntry(entry);
            }
        }
    }

    public void setMembershipContentRule(MembershipContentRule[] mcr) {
        if (mcr == null) {
            mcr = _EMPTY_CONTENT_RULES;
        }
        this._contentRules = mcr;
        EndpointReference sgEPR = this.getResource().getEndpointReference();
        for (int n = 0; n < this._contentRules.length; ++n) {
            this._contentRules[n].setServiceGroupEPR(sgEPR);
        }
    }

    public void shutdown() throws SoapFault {
        WsResource[] entries = this.getEntry();
        for (int n = 0; n < entries.length; ++n) {
            entries[n].shutdown();
        }
        super.shutdown();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

