/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.resource.sg.remote;

import java.util.Date;
import org.apache.muse.core.Environment;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapClient;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.resource.remote.WsResourceClient;
import org.apache.muse.ws.resource.sg.WssgConstants;
import org.apache.muse.ws.resource.sg.impl.AddRequest;
import org.apache.muse.ws.resource.sg.impl.AddResponse;
import org.apache.muse.ws.resource.sg.impl.SimpleMembershipContentRule;
import org.w3c.dom.Element;

public class ServiceGroupClient
extends WsResourceClient {
    public ServiceGroupClient(EndpointReference destination) {
        super(destination);
    }

    public ServiceGroupClient(EndpointReference destination, EndpointReference source) {
        super(destination, source);
    }

    public ServiceGroupClient(EndpointReference destination, EndpointReference source, Environment environment) {
        super(destination, source, environment);
    }

    public ServiceGroupClient(EndpointReference destination, EndpointReference source, SoapClient soapClient) {
        super(destination, source, soapClient);
    }

    public WsResourceClient add(EndpointReference memberEPR, Date termination) throws SoapFault {
        Element emptyContent = XmlUtils.createElement(WssgConstants.CONTENT_QNAME);
        return this.add(memberEPR, termination, emptyContent);
    }

    public WsResourceClient add(EndpointReference memberEPR, Date termination, Element content) throws SoapFault {
        AddRequest add = new AddRequest(memberEPR, termination, content);
        Element responseXML = this.invoke("http://docs.oasis-open.org/wsrf/sgw-2/ServiceGroupRegistration/AddRequest", add.toXML());
        AddResponse response = new AddResponse(responseXML);
        return response.getEntryClient();
    }

    public WsResourceClient[] getMembers() throws SoapFault {
        Element[] entries = this.getResourceProperty(WssgConstants.ENTRY_QNAME);
        WsResourceClient[] clients = new WsResourceClient[entries.length];
        EndpointReference src = this.getSource();
        EndpointReference dest = null;
        for (int n = 0; n < entries.length; ++n) {
            Element eprXML = XmlUtils.getElement(entries[n], WssgConstants.MEMBER_SERVICE_EPR_QNAME);
            dest = new EndpointReference(eprXML);
            clients[n] = new WsResourceClient(dest, src);
        }
        return clients;
    }

    public boolean isMatch(EndpointReference epr) throws SoapFault {
        Element[] results = this.getResourceProperty(WssgConstants.CONTENT_RULE_QNAME);
        for (int n = 0; n < results.length; ++n) {
            SimpleMembershipContentRule mcr = new SimpleMembershipContentRule(results[n]);
            mcr.setServiceGroupEPR(this.getEndpointReference());
            if (mcr.isMatch(epr)) continue;
            return false;
        }
        return true;
    }
}

