/*
 * Decompiled with CFR 0.152.
 */
package org.exist;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.avalon.excalibur.cli.CLArgsParser;
import org.apache.avalon.excalibur.cli.CLOption;
import org.apache.avalon.excalibur.cli.CLOptionDescriptor;
import org.apache.avalon.excalibur.cli.CLUtil;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpc;
import org.exist.memtree.SAXAdapter;
import org.exist.storage.BrokerPool;
import org.exist.util.Configuration;
import org.exist.util.ConfigurationHelper;
import org.exist.xmldb.ShutdownListener;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.http.SslListener;
import org.mortbay.http.handler.ForwardHandler;
import org.mortbay.http.handler.NotFoundHandler;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.WebApplicationHandler;
import org.mortbay.util.ThreadedServer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Database;

public class StandaloneServer {
    private static final Logger LOG = Logger.getLogger((Class)StandaloneServer.class);
    private static final int HELP_OPT = 104;
    private static final int DEBUG_OPT = 100;
    private static final int HTTP_PORT_OPT = 112;
    private static final int THREADS_OPT = 116;
    private static final CLOptionDescriptor[] OPTIONS = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, "print help on command line options and exit."), new CLOptionDescriptor("debug", 8, 100, "debug XMLRPC calls."), new CLOptionDescriptor("http-port", 2, 112, "set HTTP port."), new CLOptionDescriptor("threads", 2, 116, "set max. number of parallel threads allowed by the db.")};
    private static final String DEFAULT_HTTP_LISTENER_PORT = "8088";
    private static Properties DEFAULT_PROPERTIES = new Properties();
    private HttpServer httpServer;
    private Map forwarding = new HashMap();
    private Map listeners = new HashMap();
    private Map filters = new HashMap();

    public void run(String[] args) throws Exception {
        StandaloneServer.printNotice();
        Properties props = new Properties(DEFAULT_PROPERTIES);
        Properties defaultListener = new Properties();
        defaultListener.setProperty("port", DEFAULT_HTTP_LISTENER_PORT);
        this.listeners.put("http", defaultListener);
        List servlets = this.configure(props);
        CLArgsParser optParser = new CLArgsParser(args, OPTIONS);
        if (optParser.getErrorString() != null) {
            System.err.println("ERROR: " + optParser.getErrorString());
            return;
        }
        Vector opt = optParser.getArguments();
        int size = opt.size();
        int threads = 5;
        block8: for (int i = 0; i < size; ++i) {
            CLOption option = (CLOption)opt.get(i);
            switch (option.getId()) {
                case 104: {
                    StandaloneServer.printHelp();
                    return;
                }
                case 100: {
                    XmlRpc.setDebug((boolean)true);
                    continue block8;
                }
                case 112: {
                    Properties httpListener = (Properties)this.listeners.get("http");
                    httpListener.put("port", option.getArgument());
                    this.listeners.put("http", httpListener);
                    continue block8;
                }
                case 116: {
                    try {
                        threads = Integer.parseInt(option.getArgument());
                        continue block8;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("option -t requires a numeric argument");
                        return;
                    }
                }
            }
        }
        System.out.println("Loading configuration ...");
        Configuration config = new Configuration("conf.xml");
        BrokerPool.configure(1, threads, config);
        BrokerPool.getInstance().registerShutdownListener(new ShutdownListenerImpl());
        this.initXMLDB();
        this.startHttpServer(servlets, props);
        System.out.println("\nServer launched ...");
        System.out.println("Installed services:");
        System.out.println("-----------------------------------------------");
        Set listenerProtocols = this.listeners.keySet();
        for (int i = 0; i < servlets.size(); ++i) {
            String name = (String)servlets.get(i);
            if (!props.getProperty(name + ".enabled").equalsIgnoreCase("yes")) continue;
            Iterator itProtocol = listenerProtocols.iterator();
            while (itProtocol.hasNext()) {
                String listenerProtocol = (String)itProtocol.next();
                Properties listenerProperties = (Properties)this.listeners.get(listenerProtocol);
                String host = listenerProperties.getProperty("host", "localhost");
                String port = listenerProperties.getProperty("port");
                System.out.println(name + ":\t" + host + ":" + port + props.getProperty(name + ".context"));
            }
        }
    }

    public boolean isStarted() {
        if (this.httpServer == null) {
            return false;
        }
        return this.httpServer.isStarted();
    }

    private void initXMLDB() throws Exception {
        Class<?> clazz = Class.forName("org.exist.xmldb.DatabaseImpl");
        Database database = (Database)clazz.newInstance();
        database.setProperty("create-database", "true");
        DatabaseManager.registerDatabase((Database)database);
    }

    private void startHttpServer(List servlets, Properties props) throws Exception {
        String path;
        this.httpServer = new HttpServer();
        Set listenerProtocols = this.listeners.keySet();
        Iterator itProtocol = listenerProtocols.iterator();
        while (itProtocol.hasNext()) {
            String listenerProtocol = (String)itProtocol.next();
            Properties listenerProps = (Properties)this.listeners.get(listenerProtocol);
            SocketListener listener = null;
            if (listenerProtocol.equals("http")) {
                listener = new SocketListener();
            } else if (listenerProtocol.equals("https")) {
                listener = new SslListener();
                Properties params = (Properties)listenerProps.get("params");
                if (params.containsKey("keystore")) {
                    String keystore = params.getProperty("keystore");
                    ((SslListener)listener).setKeystore(keystore);
                }
            }
            if (listener == null) continue;
            listener.setHost(listenerProps.getProperty("host"));
            String port = (String)listenerProps.get("port");
            listener.setPort(Integer.parseInt(port));
            String address = (String)listenerProps.get("address");
            if (address != null) {
                InetAddress iaddress = InetAddress.getByName(address);
                ((ThreadedServer)listener).setInetAddress(iaddress);
            }
            ((ThreadedServer)listener).setMinThreads(5);
            ((ThreadedServer)listener).setMaxThreads(50);
            this.httpServer.addListener((HttpListener)listener);
        }
        HttpContext context = new HttpContext();
        context.setContextPath("/");
        WebApplicationHandler webappHandler = new WebApplicationHandler();
        HashMap<String, ServletBootstrap> bootstrappers = new HashMap<String, ServletBootstrap>();
        bootstrappers.put("rest", new ServletBootstrap(){

            public void bootstrap(Properties props, WebApplicationHandler webappHandler) {
                String path = props.getProperty("rest.context", "/*");
                ServletHolder restServlet = webappHandler.addServlet("EXistServlet", path, "org.exist.http.servlets.EXistServlet");
                restServlet.setInitParameter("form-encoding", props.getProperty("rest.param.form-encoding"));
                restServlet.setInitParameter("container-encoding", props.getProperty("rest.param.container-encoding"));
                restServlet.setInitParameter("dynamic-content-type", props.getProperty("rest.param.dynamic-content-type"));
                String value = props.getProperty("rest.param.use-default-user");
                if (value != null) {
                    restServlet.setInitParameter("use-default-user", value);
                }
                if ((value = props.getProperty("rest.param.default-user-username")) != null) {
                    restServlet.setInitParameter("user", value);
                }
                if ((value = props.getProperty("rest.param.default-user-password")) != null) {
                    restServlet.setInitParameter("password", value);
                }
            }
        });
        bootstrappers.put("webdav", new ServletBootstrap(){

            public void bootstrap(Properties props, WebApplicationHandler webappHandler) {
                String path = props.getProperty("webdav.context", "/webdav/*");
                ServletHolder davServlet = webappHandler.addServlet("WebDAV", path, "org.exist.http.servlets.WebDAVServlet");
                davServlet.setInitParameter("authentication", props.getProperty("webdav.param.authentication"));
            }
        });
        bootstrappers.put("xmlrpc", new ServletBootstrap(){

            public void bootstrap(Properties props, WebApplicationHandler webappHandler) {
                String path = props.getProperty("xmlrpc.context", "/xmlrpc/*");
                webappHandler.addServlet("RpcServlet", path, "org.exist.xmlrpc.RpcServlet");
            }
        });
        for (int i = 0; i < servlets.size(); ++i) {
            String name = (String)servlets.get(i);
            ServletBootstrap bootstrapper = (ServletBootstrap)bootstrappers.get(name);
            if (bootstrapper != null) {
                bootstrapper.bootstrap(props, webappHandler);
                continue;
            }
            path = props.getProperty(name + ".context", "/" + name + "/*");
            String sname = props.getProperty(name + ".name", name);
            ServletHolder servlet = webappHandler.addServlet(sname, path, props.getProperty(name + ".class"));
            String paramPrefix = name + ".param.";
            Enumeration<?> pnames = props.propertyNames();
            while (pnames.hasMoreElements()) {
                String pname = (String)pnames.nextElement();
                if (!pname.startsWith(paramPrefix)) continue;
                String theName = pname.substring(paramPrefix.length());
                servlet.setInitParameter(theName, props.getProperty(pname));
            }
        }
        Set filterClasses = this.filters.keySet();
        Iterator itFilterClass = filterClasses.iterator();
        while (itFilterClass.hasNext()) {
            String filterClass = (String)itFilterClass.next();
            Properties filterProps = (Properties)this.filters.get(filterClass);
            FilterHolder filterHolder = webappHandler.defineFilter(filterClass, filterClass);
            filterHolder.putAll((Map)((Properties)filterProps.get("params")));
            webappHandler.addFilterPathMapping(filterProps.getProperty("path"), filterClass, 0);
        }
        if (this.forwarding.size() > 0) {
            ForwardHandler forward = new ForwardHandler();
            Iterator i = this.forwarding.keySet().iterator();
            while (i.hasNext()) {
                path = (String)i.next();
                String destination = (String)this.forwarding.get(path);
                if (path.length() == 0) {
                    forward.setRootForward(destination);
                    continue;
                }
                forward.addForward(path, destination);
            }
            context.addHandler((HttpHandler)forward);
        }
        context.addHandler((HttpHandler)webappHandler);
        context.addHandler((HttpHandler)new NotFoundHandler());
        this.httpServer.addContext(context);
        this.httpServer.start();
    }

    private static void printHelp() {
        System.out.println("Usage: java " + StandaloneServer.class.getName() + " [options]");
        System.out.println(CLUtil.describeOptions((CLOptionDescriptor[])OPTIONS).toString());
    }

    public static void printNotice() {
        System.out.println("eXist version 1.0, Copyright (C) 2005 The eXist Project");
        System.out.println("eXist comes with ABSOLUTELY NO WARRANTY.");
        System.out.println("This is free software, and you are welcome to redistribute it\nunder certain conditions; for details read the license file.\n");
    }

    public void shutdown() {
        BrokerPool.stopAll(false);
    }

    private List configure(Properties properties) throws ParserConfigurationException, SAXException, IOException {
        InputStream is = null;
        String file = System.getProperty("server.xml", "server.xml");
        File f = ConfigurationHelper.lookup(file);
        if (!f.canRead()) {
            is = StandaloneServer.class.getClassLoader().getResourceAsStream("org/exist/server.xml");
            if (is == null) {
                throw new IOException("Server configuration not found!");
            }
            System.out.println("Reading server configuration from exist.jar");
        } else {
            System.out.println("Reading server configuration from: " + f.getAbsolutePath());
            is = new FileInputStream(f);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        InputSource src = new InputSource(is);
        SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        SAXAdapter adapter = new SAXAdapter();
        reader.setContentHandler(adapter);
        reader.parse(src);
        Document doc = adapter.getDocument();
        Element root = doc.getDocumentElement();
        if (!root.getLocalName().equals("server")) {
            LOG.warn((Object)"Configuration should have a root element <server>");
            return new ArrayList();
        }
        ArrayList<String> configurations = new ArrayList<String>();
        NodeList cl = root.getChildNodes();
        for (int i = 0; i < cl.getLength(); ++i) {
            Node node = cl.item(i);
            if (node.getNodeType() != 1) continue;
            Element elem = (Element)node;
            String name = elem.getLocalName();
            if ("forwarding".equals(name)) {
                this.configureForwards(elem);
                continue;
            }
            if ("listener".equals(name)) {
                this.configureListener(elem);
                continue;
            }
            if ("filter".equals(name)) {
                this.configureFilter(elem);
                continue;
            }
            if ("servlet".equals(name)) {
                String className = elem.getAttribute("class");
                configurations.add(className);
                this.parseDefaultAttrs(properties, elem, className);
                properties.putAll((Map<?, ?>)this.parseParams(elem, className));
                continue;
            }
            configurations.add(name);
            this.parseDefaultAttrs(properties, elem, name);
            properties.putAll((Map<?, ?>)this.parseParams(elem, name));
        }
        return configurations;
    }

    private void configureListener(Element listener) {
        NamedNodeMap listenerAttrs = listener.getAttributes();
        Node listenerProtocol = listenerAttrs.getNamedItem("protocol");
        Node listenerPort = listenerAttrs.getNamedItem("port");
        Node listenerHost = listenerAttrs.getNamedItem("host");
        Node listenerAddress = listenerAttrs.getNamedItem("address");
        if (listenerProtocol != null && listenerPort != null) {
            Properties listenerProps = new Properties();
            listenerProps.put("port", listenerPort.getNodeValue());
            if (listenerHost != null) {
                listenerProps.put("host", listenerHost.getNodeValue());
            }
            if (listenerAddress != null) {
                listenerProps.put("address", listenerAddress.getNodeValue());
            }
            listenerProps.put("params", this.parseParams(listener, null));
            this.listeners.put(listenerProtocol.getNodeValue().toLowerCase(), listenerProps);
        }
    }

    private void configureFilter(Element filter) {
        NamedNodeMap filterAttrs = filter.getAttributes();
        Node filterEnabled = filterAttrs.getNamedItem("enabled");
        Node filterPath = filterAttrs.getNamedItem("path");
        Node filterClass = filterAttrs.getNamedItem("class");
        if (filterEnabled != null && filterPath != null && filterClass != null && filterEnabled.getNodeValue().equals("yes")) {
            Properties filterProps = new Properties();
            filterProps.put("path", filterPath.getNodeValue());
            filterProps.put("params", this.parseParams(filter, null));
            this.filters.put(filterClass.getNodeValue(), filterProps);
        }
    }

    private Properties parseParams(Element root, String prefix) {
        Properties paramProperties = new Properties();
        prefix = prefix != null ? prefix + ".param." : "";
        NodeList cl = root.getChildNodes();
        for (int i = 0; i < cl.getLength(); ++i) {
            Node node = cl.item(i);
            if (node.getNodeType() != 1 || !"param".equals(node.getLocalName())) continue;
            Element elem = (Element)node;
            String name = elem.getAttribute("name");
            String value = elem.getAttribute("value");
            if (name == null || name.length() <= 0) continue;
            paramProperties.setProperty(prefix + name, value);
        }
        return paramProperties;
    }

    private void configureForwards(Element root) {
        NodeList cl = root.getChildNodes();
        for (int i = 0; i < cl.getLength(); ++i) {
            Node node = cl.item(i);
            if (node.getNodeType() != 1) continue;
            Element elem = (Element)node;
            String name = elem.getLocalName();
            if ("root".equals(name)) {
                String dest = elem.getAttribute("destination");
                this.forwarding.put("", dest);
                continue;
            }
            if (!"forward".equals(name)) continue;
            String path = elem.getAttribute("path");
            String dest = elem.getAttribute("destination");
            this.forwarding.put(path, dest);
        }
    }

    private void parseDefaultAttrs(Properties properties, Element elem, String prefix) {
        String[] names = new String[]{"enabled", "name", "context", "class"};
        for (int i = 0; i < names.length; ++i) {
            String attr = elem.getAttribute(names[i]);
            if (attr == null || attr.length() <= 0) continue;
            properties.setProperty(prefix + '.' + names[i], attr);
        }
    }

    public static void main(String[] args) {
        StandaloneServer server = new StandaloneServer();
        try {
            server.run(args);
        }
        catch (Exception e) {
            System.err.println("An exception occurred while launching the server: " + e.getMessage());
            e.printStackTrace();
        }
    }

    static {
        DEFAULT_PROPERTIES.setProperty("webdav.enabled", "yes");
        DEFAULT_PROPERTIES.setProperty("rest.enabled", "yes");
        DEFAULT_PROPERTIES.setProperty("xmlrpc.enabled", "yes");
        DEFAULT_PROPERTIES.setProperty("webdav.authentication", "basic");
        DEFAULT_PROPERTIES.setProperty("rest.form.encoding", "UTF-8");
        DEFAULT_PROPERTIES.setProperty("rest.container.encoding", "UTF-8");
        DEFAULT_PROPERTIES.setProperty("rest.param.dynamic-content-type", "no");
    }

    class ShutdownListenerImpl
    implements ShutdownListener {
        ShutdownListenerImpl() {
        }

        public void shutdown(String dbname, int remainingInstances) {
            if (remainingInstances == 0) {
                Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    public void run() {
                        System.out.println("killing threads ...");
                        try {
                            StandaloneServer.this.httpServer.stop();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        System.exit(0);
                    }
                }, 1000L);
            }
        }
    }

    public static interface ServletBootstrap {
        public void bootstrap(Properties var1, WebApplicationHandler var2);
    }
}

