/*
 * Decompiled with CFR 0.152.
 */
package org.exist.atom.modules;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.atom.Atom;
import org.exist.atom.AtomModule;
import org.exist.atom.IncomingMessage;
import org.exist.atom.OutgoingMessage;
import org.exist.atom.modules.AtomModuleBase;
import org.exist.collections.Collection;
import org.exist.http.BadRequestException;
import org.exist.http.NotFoundException;
import org.exist.security.PermissionDeniedException;
import org.exist.security.xacml.AccessContext;
import org.exist.source.StringSource;
import org.exist.source.URLSource;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.xml.sax.SAXException;

public class Query
extends AtomModuleBase
implements Atom {
    protected static final Logger LOG = Logger.getLogger((Class)Query.class);
    MimeType xqueryMimeType = MimeTable.getInstance().getContentType("application/xquery");
    boolean allowQueryPost;
    Map methods = new HashMap();
    MethodConfiguration get;
    MethodConfiguration post;
    MethodConfiguration put;
    MethodConfiguration delete;
    MethodConfiguration head;

    public Query() {
        this.methods.put("GET", new MethodConfiguration());
        this.methods.put("POST", new MethodConfiguration());
        this.methods.put("PUT", new MethodConfiguration());
        this.methods.put("DELETE", new MethodConfiguration());
        this.methods.put("HEAD", new MethodConfiguration());
        this.allowQueryPost = false;
    }

    public MethodConfiguration getMethodConfiguration(String name) {
        return (MethodConfiguration)this.methods.get(name);
    }

    public void init(AtomModule.Context context) throws EXistException {
        super.init(context);
        this.get = (MethodConfiguration)this.methods.get("GET");
        this.post = (MethodConfiguration)this.methods.get("POST");
        this.put = (MethodConfiguration)this.methods.get("PUT");
        this.delete = (MethodConfiguration)this.methods.get("DELETE");
        this.head = (MethodConfiguration)this.methods.get("HEAD");
    }

    public void doGet(DBBroker broker, IncomingMessage request, OutgoingMessage response) throws BadRequestException, PermissionDeniedException, NotFoundException, EXistException {
        if (this.get.querySource != null) {
            this.doQuery(broker, request, response, this.get);
        } else {
            super.doGet(broker, request, response);
        }
    }

    public void doPut(DBBroker broker, IncomingMessage request, OutgoingMessage response) throws BadRequestException, PermissionDeniedException, NotFoundException, EXistException {
        if (this.put.querySource != null) {
            this.doQuery(broker, request, response, this.put);
        } else {
            super.doGet(broker, request, response);
        }
    }

    public void doDelete(DBBroker broker, IncomingMessage request, OutgoingMessage response) throws BadRequestException, PermissionDeniedException, NotFoundException, EXistException {
        if (this.delete.querySource != null) {
            this.doQuery(broker, request, response, this.delete);
        } else {
            super.doGet(broker, request, response);
        }
    }

    public void doHead(DBBroker broker, IncomingMessage request, OutgoingMessage response) throws BadRequestException, PermissionDeniedException, NotFoundException, EXistException {
        if (this.head.querySource != null) {
            this.doQuery(broker, request, response, this.head);
        } else {
            super.doGet(broker, request, response);
        }
    }

    public void doPost(DBBroker broker, IncomingMessage request, OutgoingMessage response) throws BadRequestException, PermissionDeniedException, NotFoundException, EXistException {
        if (this.post.querySource != null) {
            this.doQuery(broker, request, response, this.post);
        } else {
            if (this.allowQueryPost) {
                Collection collection = broker.getCollection(XmldbURI.create(request.getPath()));
                if (collection == null) {
                    throw new BadRequestException("Collection " + request.getPath() + " does not exist.");
                }
                XQuery xquery = broker.getXQueryService();
                XQueryContext context = xquery.newContext(AccessContext.REST);
                context.setModuleLoadPath(this.getContext().getModuleLoadPath());
                String contentType = request.getHeader("Content-Type");
                String charset = this.getContext().getDefaultCharset();
                MimeType mime = MimeType.XML_TYPE;
                if (contentType != null) {
                    String param;
                    int semicolon = contentType.indexOf(59);
                    if (semicolon > 0) {
                        contentType = contentType.substring(0, semicolon).trim();
                    }
                    mime = MimeTable.getInstance().getContentType(contentType);
                    int equals = contentType.indexOf(61, semicolon);
                    if (equals > 0 && (param = contentType.substring(semicolon + 1, equals).trim()).compareToIgnoreCase("charset=") == 0) {
                        charset = param.substring(equals + 1).trim();
                    }
                }
                if (!mime.isXMLType() && !mime.equals(this.xqueryMimeType)) {
                    throw new BadRequestException("The xquery mime type is not an XML mime type nor application/xquery");
                }
                CompiledXQuery compiledQuery = null;
                try {
                    int len;
                    StringBuffer builder = new StringBuffer();
                    InputStreamReader r = new InputStreamReader(request.getInputStream(), charset);
                    char[] buffer = new char[4096];
                    int contentLength = request.getContentLength();
                    for (int count = 0; (len = r.read(buffer)) >= 0 && count < contentLength; count += len) {
                        builder.append(buffer, 0, len);
                    }
                    compiledQuery = xquery.compile(context, new StringSource(builder.toString()));
                }
                catch (XPathException ex) {
                    throw new EXistException("Cannot compile xquery.", ex);
                }
                catch (IOException ex) {
                    throw new EXistException("I/O exception while compiling xquery.", ex);
                }
                context.setStaticallyKnownDocuments(new XmldbURI[]{XmldbURI.create(request.getPath()).append(".feed.atom")});
                try {
                    Sequence resultSequence = xquery.execute(compiledQuery, null);
                    if (resultSequence.isEmpty()) {
                        throw new BadRequestException("No topic was found.");
                    }
                    response.setStatusCode(200);
                    response.setContentType("application/atom+xml; charset=" + charset);
                    Serializer serializer = broker.getSerializer();
                    serializer.reset();
                    try {
                        OutputStreamWriter w = new OutputStreamWriter(response.getOutputStream(), charset);
                        SAXSerializer sax = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
                        Properties outputProperties = new Properties();
                        sax.setOutput(w, outputProperties);
                        serializer.setProperties(outputProperties);
                        serializer.setSAXHandlers(sax, sax);
                        serializer.toSAX(resultSequence, 1, 1, false);
                        SerializerPool.getInstance().returnObject(sax);
                        ((Writer)w).flush();
                        ((Writer)w).close();
                    }
                    catch (IOException ex) {
                        LOG.fatal((Object)("Cannot read resource " + request.getPath()), (Throwable)ex);
                        throw new EXistException("I/O error on read of resource " + request.getPath(), ex);
                    }
                    catch (SAXException saxe) {
                        LOG.warn((Object)saxe);
                        throw new BadRequestException("Error while serializing XML: " + saxe.getMessage());
                    }
                    resultSequence.itemAt(0);
                }
                catch (XPathException ex) {
                    throw new EXistException("Cannot execute xquery.", ex);
                }
            }
            super.doPost(broker, request, response);
        }
    }

    public void doQuery(DBBroker broker, IncomingMessage request, OutgoingMessage response, MethodConfiguration config) throws BadRequestException, PermissionDeniedException, NotFoundException, EXistException {
        XQueryContext context;
        Collection collection = broker.getCollection(XmldbURI.create(request.getPath()));
        if (collection == null) {
            throw new BadRequestException("Collection " + request.getPath() + " does not exist.");
        }
        XQuery xquery = broker.getXQueryService();
        CompiledXQuery feedQuery = xquery.getXQueryPool().borrowCompiledXQuery(broker, config.querySource);
        if (feedQuery == null) {
            context = xquery.newContext(AccessContext.REST);
            context.setModuleLoadPath(this.getContext().getModuleLoadPath());
            try {
                feedQuery = xquery.compile(context, config.querySource);
            }
            catch (XPathException ex) {
                throw new EXistException("Cannot compile xquery " + config.querySource.getURL(), ex);
            }
            catch (IOException ex) {
                throw new EXistException("I/O exception while compiling xquery " + config.querySource.getURL(), ex);
            }
        } else {
            context = feedQuery.getContext();
            context.setModuleLoadPath(this.getContext().getModuleLoadPath());
        }
        context.setStaticallyKnownDocuments(new XmldbURI[]{XmldbURI.create(request.getPath()).append(".feed.atom")});
        try {
            Sequence resultSequence = xquery.execute(feedQuery, null);
            if (resultSequence.isEmpty()) {
                throw new BadRequestException("No topic was found.");
            }
            String charset = this.getContext().getDefaultCharset();
            response.setStatusCode(200);
            response.setContentType(config.contentType + "; charset=" + charset);
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            try {
                OutputStreamWriter w = new OutputStreamWriter(response.getOutputStream(), charset);
                SAXSerializer sax = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
                Properties outputProperties = new Properties();
                sax.setOutput(w, outputProperties);
                serializer.setProperties(outputProperties);
                serializer.setSAXHandlers(sax, sax);
                serializer.toSAX(resultSequence, 1, 1, false);
                SerializerPool.getInstance().returnObject(sax);
                ((Writer)w).flush();
                ((Writer)w).close();
            }
            catch (IOException ex) {
                LOG.fatal((Object)("Cannot read resource " + request.getPath()), (Throwable)ex);
                throw new EXistException("I/O error on read of resource " + request.getPath(), ex);
            }
            catch (SAXException saxe) {
                LOG.warn((Object)saxe);
                throw new BadRequestException("Error while serializing XML: " + saxe.getMessage());
            }
            resultSequence.itemAt(0);
        }
        catch (XPathException ex) {
            throw new EXistException("Cannot execute xquery " + config.querySource.getURL(), ex);
        }
        finally {
            xquery.getXQueryPool().returnCompiledXQuery(config.querySource, feedQuery);
        }
    }

    public boolean isQueryByPostAllowed() {
        return this.allowQueryPost;
    }

    public void setQueryByPost(boolean allowed) {
        this.allowQueryPost = allowed;
    }

    public class MethodConfiguration {
        String contentType = "application/atom+xml";
        URLSource querySource = null;

        MethodConfiguration() {
        }

        public void setContentType(String value) {
            this.contentType = value;
        }

        public String getContentType() {
            return this.contentType;
        }

        public URL getQuerySource() {
            return this.querySource.getURL();
        }

        public void setQuerySource(URL source) {
            this.querySource = source == null ? null : new URLSource(source);
        }
    }
}

