/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Observable;
import java.util.Stack;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.exist.backup.RestoreDialog;
import org.exist.dom.DocumentTypeImpl;
import org.exist.security.User;
import org.exist.xmldb.CollectionImpl;
import org.exist.xmldb.CollectionManagementServiceImpl;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.util.URIUtils;
import org.exist.xquery.value.DateTimeValue;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class Restore
extends DefaultHandler {
    private File contents;
    private String uri;
    private String username;
    private String pass;
    private XMLReader reader;
    private CollectionImpl current;
    private Stack stack = new Stack();
    private RestoreDialog dialog = null;
    private int version = 0;
    private static final int strictUriVersion = 1;

    public Restore(String user, String pass, String newAdminPass, File contents, String uri) throws ParserConfigurationException, SAXException, XMLDBException, URISyntaxException {
        File sys;
        this.username = user;
        this.pass = pass;
        this.uri = uri;
        if (newAdminPass != null) {
            this.setAdminCredentials(newAdminPass);
        }
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setNamespaceAware(true);
        saxFactory.setValidating(false);
        SAXParser sax = saxFactory.newSAXParser();
        this.reader = sax.getXMLReader();
        this.reader.setContentHandler(this);
        this.stack.push(contents);
        File dir = contents.getParentFile();
        if (dir.isDirectory() && (sys = new File(dir.getAbsolutePath() + File.separatorChar + "system" + File.separatorChar + "__contents__.xml")).canRead()) {
            System.out.println("found 'db" + File.separatorChar + "system'. It will be processed first.");
            this.stack.push(sys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(boolean showGUI, JFrame parent) throws XMLDBException, FileNotFoundException, IOException, SAXException {
        block8: {
            block7: {
                if (!showGUI) break block7;
                this.dialog = new RestoreDialog(parent, "Restoring data ...", false);
                this.dialog.setVisible(true);
                Thread restoreThread = new Thread(){

                    public void run() {
                        while (!Restore.this.stack.isEmpty()) {
                            try {
                                Restore.this.contents = (File)Restore.this.stack.pop();
                                Restore.this.reader.parse(new InputSource(new FileInputStream(Restore.this.contents)));
                            }
                            catch (FileNotFoundException e) {
                                Restore.this.dialog.displayMessage(e.getMessage());
                            }
                            catch (IOException e) {
                                Restore.this.dialog.displayMessage(e.getMessage());
                            }
                            catch (SAXException e) {
                                Restore.this.dialog.displayMessage(e.getMessage());
                            }
                        }
                        Restore.this.dialog.setVisible(false);
                    }
                };
                restoreThread.start();
                if (parent != null) break block8;
                while (restoreThread.isAlive()) {
                    Restore restore = this;
                    synchronized (restore) {
                        try {
                            this.wait(20L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                break block8;
            }
            while (!this.stack.isEmpty()) {
                this.contents = (File)this.stack.pop();
                String sysId = this.contents.toURI().toASCIIString();
                InputSource is = new InputSource(sysId);
                is.setEncoding("UTF-8");
                System.out.println("restoring " + sysId);
                this.reader.parse(is);
            }
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (namespaceURI.equals("http://exist.sourceforge.net/NS/exist")) {
            if (localName.equals("collection")) {
                String name = atts.getValue("name");
                String owner = atts.getValue("owner");
                String group = atts.getValue("group");
                String mode = atts.getValue("mode");
                String created = atts.getValue("created");
                String strVersion = atts.getValue("version");
                if (strVersion != null) {
                    try {
                        this.version = Integer.parseInt(strVersion);
                    }
                    catch (NumberFormatException e) {
                        this.version = 0;
                    }
                }
                if (name == null) {
                    throw new SAXException("collection requires a name attribute");
                }
                try {
                    XmldbURI collUri;
                    if (this.dialog != null) {
                        this.dialog.displayMessage("creating collection " + name);
                    }
                    if (this.version >= 1) {
                        collUri = XmldbURI.create(name);
                    } else {
                        try {
                            collUri = URIUtils.encodeXmldbUriFor(name);
                        }
                        catch (URISyntaxException e) {
                            String message = "Could not parse document name into a URI: " + e.getMessage();
                            if (this.dialog != null) {
                                this.dialog.displayMessage(message);
                            } else {
                                System.err.println(message);
                            }
                            return;
                        }
                    }
                    Date date_created = null;
                    if (created != null) {
                        try {
                            date_created = new DateTimeValue(created).getDate();
                        }
                        catch (XPathException e2) {
                            // empty catch block
                        }
                    }
                    this.current = this.mkcol(collUri, date_created);
                    if (this.current == null) {
                        throw new SAXException("Collection not found: " + collUri);
                    }
                    UserManagementService service = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                    User u = new User(owner, null, group);
                    service.chown(u, group);
                    service.chmod(Integer.parseInt(mode, 8));
                }
                catch (Exception e) {
                    if (this.dialog != null) {
                        Restore.showErrorMessage("An unrecoverable error occurred while restoring\ncollection '" + name + "'. " + "Aborting restore!");
                    } else {
                        System.err.println("An unrecoverable error occurred while restoring\ncollection '" + name + "'. " + "Aborting restore!");
                    }
                    e.printStackTrace();
                    throw new SAXException(e.getMessage(), e);
                }
                if (this.dialog != null) {
                    this.dialog.setCollection(name);
                }
            } else if (localName.equals("subcollection")) {
                String fname;
                File f;
                String name = atts.getValue("filename");
                if (name == null) {
                    name = atts.getValue("name");
                }
                if ((f = new File(fname = this.contents.getParentFile().getAbsolutePath() + File.separatorChar + name + File.separatorChar + "__contents__.xml")).exists() && f.canRead()) {
                    this.stack.push(f);
                } else {
                    System.err.println(f.getAbsolutePath() + " does not exist or is not readable.");
                }
            } else if (localName.equals("resource")) {
                XmldbURI docUri;
                String type = atts.getValue("type");
                if (type == null) {
                    type = "XMLResource";
                }
                String name = atts.getValue("name");
                String owner = atts.getValue("owner");
                String group = atts.getValue("group");
                String perms = atts.getValue("mode");
                String filename = atts.getValue("filename");
                String mimetype = atts.getValue("mimetype");
                String created = atts.getValue("created");
                String modified = atts.getValue("modified");
                String publicid = atts.getValue("publicid");
                String systemid = atts.getValue("systemid");
                String namedoctype = atts.getValue("namedoctype");
                if (filename == null) {
                    filename = name;
                }
                if (name == null) {
                    if (this.dialog != null) {
                        this.dialog.displayMessage("Wrong entry in backup descriptor: resource requires a name attribute.");
                    } else {
                        System.err.println("Wrong entry in backup descriptor: resource requires a name attribute.");
                    }
                }
                if (this.version >= 1) {
                    docUri = XmldbURI.create(name);
                } else {
                    try {
                        docUri = URIUtils.encodeXmldbUriFor(name);
                    }
                    catch (URISyntaxException e) {
                        String message = "Could not parse document name into a URI: " + e.getMessage();
                        if (this.dialog != null) {
                            this.dialog.displayMessage(message);
                        } else {
                            System.err.println(message);
                        }
                        return;
                    }
                }
                File f = new File(this.contents.getParentFile().getAbsolutePath() + File.separatorChar + filename);
                try {
                    UserManagementService service;
                    Resource res;
                    block59: {
                        if (this.dialog != null && this.current instanceof Observable) {
                            ((Observable)((Object)this.current)).addObserver(this.dialog.getObserver());
                        }
                        if (this.dialog != null) {
                            this.dialog.setResource(name);
                        }
                        res = this.current.createResource(docUri.toString(), type);
                        if (mimetype != null) {
                            ((EXistResource)res).setMimeType(mimetype);
                        }
                        res.setContent((Object)f);
                        if (this.dialog == null) {
                            System.out.println("Restoring " + name);
                        }
                        Date date_created = null;
                        Date date_modified = null;
                        if (created != null) {
                            try {
                                date_created = new DateTimeValue(created).getDate();
                            }
                            catch (XPathException e2) {
                                System.err.println("Illegal creation date. Skipping ...");
                            }
                        }
                        if (modified != null) {
                            try {
                                date_modified = new DateTimeValue(modified).getDate();
                            }
                            catch (XPathException e2) {
                                System.err.println("Illegal modification date. Skipping ...");
                            }
                        }
                        this.current.storeResource(res, date_created, date_modified);
                        if (publicid != null || systemid != null) {
                            DocumentTypeImpl doctype = new DocumentTypeImpl(namedoctype, publicid, systemid);
                            try {
                                ((EXistResource)res).setDocType(doctype);
                            }
                            catch (XMLDBException e1) {
                                e1.printStackTrace();
                            }
                        }
                        service = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                        User u = new User(owner, null, group);
                        try {
                            service.chown(res, u, group);
                        }
                        catch (XMLDBException e1) {
                            if (this.dialog == null) break block59;
                            this.dialog.displayMessage("Failed to change owner on document '" + name + "'; skipping ...");
                        }
                    }
                    service.chmod(res, Integer.parseInt(perms, 8));
                    if (this.dialog != null) {
                        this.dialog.displayMessage("restored " + name);
                    }
                }
                catch (Exception e) {
                    if (this.dialog != null) {
                        this.dialog.displayMessage("Failed to restore resource '" + name + "'\nfrom file '" + f.getAbsolutePath() + "'.\nReason: " + e.getMessage());
                        Restore.showErrorMessage("Failed to restore resource '" + name + "' from file: '" + f.getAbsolutePath() + "'.\n\nReason: " + e.getMessage());
                    }
                    System.err.println("Failed to restore resource '" + name + "' from file '" + f.getAbsolutePath() + "'");
                    e.printStackTrace();
                }
            }
        }
    }

    private final CollectionImpl mkcol(XmldbURI collPath, Date created) throws XMLDBException, URISyntaxException {
        XmldbURI[] segments = collPath.getPathSegments();
        XmldbURI dbUri = !this.uri.endsWith("/db") ? XmldbURI.xmldbUriFor(this.uri + "/db") : XmldbURI.xmldbUriFor(this.uri);
        Collection current = DatabaseManager.getCollection((String)dbUri.toString(), (String)this.username, (String)this.pass);
        XmldbURI p = XmldbURI.ROOT_COLLECTION_URI;
        for (int i = 1; i < segments.length; ++i) {
            XmldbURI xmldbURI = dbUri.resolveCollectionPath(p = p.append(segments[i]));
            Collection c = DatabaseManager.getCollection((String)xmldbURI.toString(), (String)this.username, (String)this.pass);
            if (c == null) {
                CollectionManagementServiceImpl mgtService = (CollectionManagementServiceImpl)current.getService("CollectionManagementService", "1.0");
                current = mgtService.createCollection(segments[i], created);
                continue;
            }
            current = c;
        }
        return (CollectionImpl)current;
    }

    private void setAdminCredentials(String adminPassword) throws XMLDBException, URISyntaxException {
        XmldbURI dbUri = !this.uri.endsWith("/db") ? XmldbURI.xmldbUriFor(this.uri + "/db") : XmldbURI.xmldbUriFor(this.uri);
        Collection root = DatabaseManager.getCollection((String)dbUri.toString(), (String)this.username, (String)this.pass);
        UserManagementService mgmt = (UserManagementService)root.getService("UserManagementService", "1.0");
        User dba = mgmt.getUser("admin");
        dba.setPassword(adminPassword);
        mgmt.updateUser(dba);
        this.pass = adminPassword;
    }

    public static void showErrorMessage(String message) {
        JTextArea msgArea = new JTextArea(message);
        msgArea.setEditable(false);
        msgArea.setBackground(null);
        JScrollPane scroll = new JScrollPane(msgArea);
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessage(new Object[]{scroll});
        optionPane.setMessageType(0);
        JDialog dialog = optionPane.createDialog(null, "Error");
        dialog.setResizable(true);
        dialog.pack();
        dialog.setVisible(true);
    }
}

