/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.exist.backup.Backup;
import org.exist.backup.CreateBackupDialog;
import org.exist.backup.Restore;
import org.exist.client.BackupContentsFilter;
import org.exist.client.DocumentView;
import org.exist.client.IndexDialog;
import org.exist.client.InteractiveClient;
import org.exist.client.LoginPanel;
import org.exist.client.Messages;
import org.exist.client.PrettyXmldbURI;
import org.exist.client.QueryDialog;
import org.exist.client.ResourceDescriptor;
import org.exist.client.ResourcePropertyDialog;
import org.exist.client.TriggersDialog;
import org.exist.client.UploadDialog;
import org.exist.client.UserDialog;
import org.exist.client.xacml.XACMLEditor;
import org.exist.security.Permission;
import org.exist.security.PermissionFactory;
import org.exist.util.MimeTable;
import org.exist.util.SingleInstanceConfiguration;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.CollectionImpl;
import org.exist.xmldb.CollectionManagementServiceImpl;
import org.exist.xmldb.DatabaseInstanceManager;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.IndexQueryService;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.util.URIUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class ClientFrame
extends JFrame
implements WindowFocusListener,
KeyListener,
ActionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    public static final String CUT = Messages.getString("ClientFrame.0");
    public static final String COPY = Messages.getString("ClientFrame.1");
    public static final String PASTE = Messages.getString("ClientFrame.2");
    public static final int MAX_DISPLAY_LENGTH = 512000;
    public static final int MAX_HISTORY = 50;
    private static final SimpleAttributeSet promptAttrs = new SimpleAttributeSet();
    private static final SimpleAttributeSet defaultAttrs = new SimpleAttributeSet();
    private int commandStart;
    private boolean gotUp;
    private DefaultStyledDocument doc;
    private JLabel statusbar;
    private JTable fileman;
    private ResourceTableModel resources;
    private JTextPane shell;
    private JPopupMenu shellPopup;
    private InteractiveClient client;
    private XmldbURI path;
    private ProcessThread process;
    private Properties properties;

    public ClientFrame(InteractiveClient client, XmldbURI path, Properties properties) throws HeadlessException {
        super(Messages.getString("ClientFrame.3"));
        StyleConstants.setForeground(promptAttrs, Color.blue);
        StyleConstants.setBold(promptAttrs, true);
        StyleConstants.setForeground(defaultAttrs, Color.black);
        this.commandStart = 0;
        this.gotUp = false;
        this.resources = new ResourceTableModel();
        this.path = null;
        this.process = new ProcessThread();
        this.path = path;
        this.properties = properties;
        this.client = client;
        this.setupComponents();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent ev) {
                ClientFrame.this.close();
            }
        });
        this.pack();
        this.process.start();
        this.shell.requestFocus();
    }

    private void setupComponents() {
        this.setJMenuBar(this.createMenuBar());
        JToolBar toolbar = new JToolBar();
        URL url = this.getClass().getResource("icons/Up24.gif");
        JButton button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("ClientFrame.5"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.goUpAction(e);
            }
        });
        toolbar.add(button);
        url = this.getClass().getResource("icons/Refresh24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("ClientFrame.7"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ClientFrame.this.client.reloadCollection();
                }
                catch (XMLDBException xMLDBException) {
                    // empty catch block
                }
            }
        });
        toolbar.add(button);
        toolbar.addSeparator();
        url = this.getClass().getResource("icons/New24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("ClientFrame.9"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.newCollectionAction(e);
            }
        });
        toolbar.add(button);
        url = this.getClass().getResource("icons/Add24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("ClientFrame.11"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.uploadAction(e);
            }
        });
        toolbar.add(button);
        url = this.getClass().getResource("icons/Delete24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("ClientFrame.13"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.removeAction(e);
            }
        });
        toolbar.add(button);
        url = this.getClass().getResource(Messages.getString("ClientFrame.14"));
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("ClientFrame.15"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.setPermAction(e);
            }
        });
        toolbar.add(button);
        toolbar.addSeparator();
        url = this.getClass().getResource("icons/Export24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("ClientFrame.17"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.backupAction(e);
            }
        });
        toolbar.add(button);
        url = this.getClass().getResource("icons/Import24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("ClientFrame.19"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.restoreAction(e);
            }
        });
        toolbar.add(button);
        toolbar.addSeparator();
        url = this.getClass().getResource(Messages.getString("ClientFrame.20"));
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("ClientFrame.21"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.editUsersAction(e);
            }
        });
        toolbar.add(button);
        url = this.getClass().getResource("icons/Find24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("ClientFrame.23"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.findAction(e);
            }
        });
        toolbar.add(button);
        JSplitPane split = new JSplitPane(0);
        split.setResizeWeight(0.5);
        this.fileman = new JTable();
        this.fileman.setModel(this.resources);
        this.fileman.addMouseListener(new TableMouseListener());
        ResourceTableCellRenderer renderer = new ResourceTableCellRenderer();
        this.fileman.setDefaultRenderer(Object.class, renderer);
        JScrollPane scroll = new JScrollPane(this.fileman);
        scroll.setMinimumSize(new Dimension(300, 150));
        split.setLeftComponent(scroll);
        this.shellPopup = new JPopupMenu(Messages.getString("ClientFrame.24"));
        this.shellPopup.add(new JMenuItem(CUT)).addActionListener(this);
        this.shellPopup.add(new JMenuItem(COPY)).addActionListener(this);
        this.shellPopup.add(new JMenuItem(PASTE)).addActionListener(this);
        this.doc = new DefaultStyledDocument();
        this.shell = new JTextPane(this.doc);
        this.shell.setContentType("text/plain; charset=UTF-8");
        this.shell.setFont(new Font("Monospaced", 0, 12));
        this.shell.setMargin(new Insets(7, 5, 7, 5));
        this.shell.addKeyListener(this);
        this.shell.addMouseListener(this);
        scroll = new JScrollPane(this.shell);
        split.setRightComponent(scroll);
        this.statusbar = new JLabel(Messages.getString("ClientFrame.27") + this.properties.getProperty("user") + "@" + this.properties.getProperty("uri"));
        this.statusbar.setMinimumSize(new Dimension(400, 15));
        this.statusbar.setBorder(BorderFactory.createBevelBorder(1));
        this.getContentPane().add((Component)split, "Center");
        this.getContentPane().add((Component)toolbar, "North");
        this.getContentPane().add((Component)this.statusbar, "South");
    }

    private JMenuBar createMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu fileMenu = new JMenu(Messages.getString("ClientFrame.31"));
        fileMenu.setMnemonic(70);
        menubar.add(fileMenu);
        JMenuItem item = new JMenuItem(Messages.getString("ClientFrame.32"), 83);
        item.setAccelerator(KeyStroke.getKeyStroke("control S"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.uploadAction(e);
            }
        });
        fileMenu.add(item);
        item = new JMenuItem(Messages.getString("ClientFrame.34"), 78);
        item.setAccelerator(KeyStroke.getKeyStroke("control N"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.newCollectionAction(e);
            }
        });
        fileMenu.add(item);
        item = new JMenuItem(Messages.getString("ClientFrame.36"), 66);
        item.setAccelerator(KeyStroke.getKeyStroke("control B"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Collection collection = ((ClientFrame)ClientFrame.this).client.current;
                XMLResource result = null;
                String nameres = JOptionPane.showInputDialog(null, (Object)Messages.getString("ClientFrame.38"));
                if (nameres != null) {
                    try {
                        result = (XMLResource)collection.createResource(URIUtils.urlEncodeUtf8(nameres), "XMLResource");
                        result.setContent((Object)Messages.getString("ClientFrame.39"));
                        collection.storeResource((Resource)result);
                        collection.close();
                        ClientFrame.this.client.reloadCollection();
                    }
                    catch (XMLDBException ev) {
                        ClientFrame.showErrorMessage(ev.getMessage(), ev);
                    }
                }
            }
        });
        fileMenu.add(item);
        fileMenu.addSeparator();
        item = new JMenuItem(Messages.getString("ClientFrame.40"));
        item.setAccelerator(KeyStroke.getKeyStroke("control D"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.removeAction(e);
            }
        });
        fileMenu.add(item);
        item = new JMenuItem(Messages.getString("ClientFrame.42"), 67);
        item.setAccelerator(KeyStroke.getKeyStroke("control C"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.copyAction(e);
            }
        });
        fileMenu.add(item);
        item = new JMenuItem(Messages.getString("ClientFrame.44"), 77);
        item.setAccelerator(KeyStroke.getKeyStroke("control M"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.moveAction(e);
            }
        });
        fileMenu.add(item);
        item = new JMenuItem(Messages.getString("ClientFrame.46"), 82);
        item.setAccelerator(KeyStroke.getKeyStroke("control R"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.renameAction(e);
            }
        });
        fileMenu.add(item);
        item = new JMenuItem("Export a resource to file ...", 69);
        item.setAccelerator(KeyStroke.getKeyStroke("control E"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.exportAction(e);
            }
        });
        fileMenu.add(item);
        fileMenu.addSeparator();
        item = new JMenuItem(Messages.getString("ClientFrame.48"), 73);
        item.setAccelerator(KeyStroke.getKeyStroke("control I"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.reindexAction(e);
            }
        });
        fileMenu.add(item);
        item = new JMenuItem(Messages.getString("ClientFrame.50"));
        item.setAccelerator(KeyStroke.getKeyStroke("control P"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.setPermAction(e);
            }
        });
        fileMenu.add(item);
        fileMenu.addSeparator();
        item = new JMenuItem(Messages.getString("ClientFrame.52"), 81);
        item.setAccelerator(KeyStroke.getKeyStroke("control Q"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.close();
            }
        });
        fileMenu.add(item);
        JMenu toolsMenu = new JMenu(Messages.getString("ClientFrame.54"));
        toolsMenu.setMnemonic(84);
        menubar.add(toolsMenu);
        item = new JMenuItem(Messages.getString("ClientFrame.55"), 70);
        item.setAccelerator(KeyStroke.getKeyStroke("control F"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.findAction(e);
            }
        });
        toolsMenu.add(item);
        toolsMenu.addSeparator();
        item = new JMenuItem(Messages.getString("ClientFrame.57"), 85);
        item.setAccelerator(KeyStroke.getKeyStroke("control U"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.editUsersAction(e);
            }
        });
        toolsMenu.add(item);
        item = new JMenuItem(Messages.getString("ClientFrame.59"), 85);
        item.setAccelerator(KeyStroke.getKeyStroke("control I"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.editIndexesAction(e);
            }
        });
        toolsMenu.add(item);
        item = new JMenuItem("Edit Triggers", 84);
        item.setAccelerator(KeyStroke.getKeyStroke("control T"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.editTriggersAction(e);
            }
        });
        toolsMenu.add(item);
        item = new JMenuItem(Messages.getString("ClientFrame.61"), 79);
        item.setAccelerator(KeyStroke.getKeyStroke("control O"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.editPolicies();
            }
        });
        toolsMenu.add(item);
        toolsMenu.addSeparator();
        item = new JMenuItem("Enter service mode");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DatabaseInstanceManager service = (DatabaseInstanceManager)((ClientFrame)ClientFrame.this).client.current.getService("DatabaseInstanceManager", "1.0");
                    service.enterServiceMode();
                }
                catch (XMLDBException ex) {
                    ClientFrame.showErrorMessage(ex.getMessage(), ex);
                }
            }
        });
        toolsMenu.add(item);
        item = new JMenuItem("Exit service mode");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DatabaseInstanceManager service = (DatabaseInstanceManager)((ClientFrame)ClientFrame.this).client.current.getService("DatabaseInstanceManager", "1.0");
                    service.exitServiceMode();
                }
                catch (XMLDBException ex) {
                    ClientFrame.showErrorMessage(ex.getMessage(), ex);
                }
            }
        });
        toolsMenu.add(item);
        toolsMenu.addSeparator();
        item = new JMenuItem(Messages.getString("ClientFrame.63"), 66);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.backupAction(e);
            }
        });
        toolsMenu.add(item);
        item = new JMenuItem(Messages.getString("ClientFrame.64"), 82);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.restoreAction(e);
            }
        });
        toolsMenu.add(item);
        JMenu connectMenu = new JMenu(Messages.getString("ClientFrame.65"));
        connectMenu.setMnemonic(68);
        menubar.add(connectMenu);
        item = new JMenuItem(Messages.getString("ClientFrame.66"), 83);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.display(Messages.getString("ClientFrame.67"));
                ClientFrame.this.process.setAction("shutdown");
            }
        });
        connectMenu.add(item);
        item = new JMenuItem(Messages.getString("ClientFrame.69"), 85);
        item.setToolTipText(Messages.getString("ClientFrame.70"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Properties loginData = ClientFrame.getLoginData(ClientFrame.this.properties);
                if (loginData == null) {
                    return;
                }
                Properties oldProps = ClientFrame.this.properties;
                ClientFrame.this.properties.putAll((Map<?, ?>)loginData);
                ClientFrame.this.statusbar.setText(Messages.getString("ClientFrame.71") + ClientFrame.this.properties.getProperty("user") + "@" + ClientFrame.this.properties.getProperty("uri"));
                try {
                    ClientFrame.this.client.shutdown(false);
                    ClientFrame.this.client.connect();
                    ClientFrame.this.client.reloadCollection();
                }
                catch (Exception u) {
                    ClientFrame.showErrorMessage(Messages.getString("ClientFrame.75") + ClientFrame.this.properties.getProperty("uri") + Messages.getString("ClientFrame.77"), u);
                    ClientFrame.this.properties = oldProps;
                    try {
                        ClientFrame.this.client.connect();
                    }
                    catch (Exception uu) {
                        ClientFrame.showErrorMessage(Messages.getString("ClientFrame.78") + ClientFrame.this.properties.getProperty("uri"), u);
                    }
                }
            }
        });
        connectMenu.add(item);
        JMenu optionsMenu = new JMenu(Messages.getString("ClientFrame.80"));
        optionsMenu.setMnemonic(79);
        menubar.add(optionsMenu);
        JCheckBoxMenuItem check = new JCheckBoxMenuItem(Messages.getString("ClientFrame.81"), this.properties.getProperty("indent").equals("yes"));
        check.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.properties.setProperty("indent", ((JCheckBoxMenuItem)e.getSource()).isSelected() ? "yes" : "no");
                try {
                    ClientFrame.this.client.getResources();
                }
                catch (XMLDBException xMLDBException) {
                    // empty catch block
                }
            }
        });
        optionsMenu.add(check);
        check = new JCheckBoxMenuItem(Messages.getString("ClientFrame.85"), this.properties.getProperty("expand-xincludes").equals("yes"));
        check.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.properties.setProperty("expand-xincludes", ((JCheckBoxMenuItem)e.getSource()).isSelected() ? "yes" : "no");
                try {
                    ClientFrame.this.client.getResources();
                }
                catch (XMLDBException xMLDBException) {
                    // empty catch block
                }
            }
        });
        optionsMenu.add(check);
        JMenu HelpMenu = new JMenu(Messages.getString("ClientFrame.89"));
        HelpMenu.setMnemonic(72);
        menubar.add(HelpMenu);
        item = new JMenuItem(Messages.getString("ClientFrame.90"), 65);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.AboutAction();
            }
        });
        HelpMenu.add(item);
        return menubar;
    }

    public void setPath(XmldbURI currentPath) {
        this.path = currentPath;
    }

    protected void displayPrompt() {
        String pathString = this.path.getCollectionPath();
        try {
            this.commandStart = this.doc.getLength();
            this.doc.insertString(this.commandStart, Messages.getString("ClientFrame.91"), promptAttrs);
            this.commandStart += 6;
            this.doc.insertString(this.commandStart, pathString + '>', promptAttrs);
            this.commandStart += pathString.length() + 1;
            this.doc.insertString(this.commandStart++, Messages.getString("ClientFrame.92"), defaultAttrs);
            this.shell.setCaretPosition(this.commandStart);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected void display(String message) {
        try {
            this.commandStart = this.doc.getLength();
            if (this.commandStart > 512000) {
                this.doc.remove(0, 512000);
                this.commandStart = this.doc.getLength();
            }
            this.doc.insertString(this.commandStart, message, defaultAttrs);
            this.commandStart = this.doc.getLength();
            this.shell.setCaretPosition(this.commandStart);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected void setResources(List rows) {
        this.resources.setData(rows);
    }

    protected void setStatus(String message) {
        this.statusbar.setText(message);
    }

    protected void setEditable(boolean enabled) {
        this.shell.setEditable(enabled);
        this.shell.setVisible(enabled);
    }

    public void keyPressed(KeyEvent e) {
        this.type(e);
        this.gotUp = false;
    }

    public void keyReleased(KeyEvent e) {
        this.gotUp = true;
        this.type(e);
    }

    public void keyTyped(KeyEvent e) {
        this.type(e);
    }

    private synchronized void type(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 10: {
                if (e.getID() == 401 && this.gotUp) {
                    this.enter();
                }
                e.consume();
                break;
            }
            case 36: {
                this.shell.setCaretPosition(this.commandStart);
                e.consume();
                break;
            }
            case 8: 
            case 37: 
            case 127: {
                if (this.shell.getCaretPosition() > this.commandStart) break;
                e.consume();
                break;
            }
            case 38: {
                if (e.getID() == 401) {
                    this.historyBack();
                }
                e.consume();
                break;
            }
            case 40: {
                if (e.getID() == 401) {
                    this.historyForward();
                }
                e.consume();
                break;
            }
            default: {
                if ((e.getModifiers() & 0xE) == 0 && this.shell.getCaretPosition() < this.commandStart) {
                    this.shell.setCaretPosition(this.doc.getLength());
                }
                if (e.paramString().indexOf(Messages.getString("ClientFrame.93")) <= -1 || this.shell.getCaretPosition() > this.commandStart) break;
                e.consume();
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(CUT)) {
            this.shell.cut();
        } else if (cmd.equals(COPY)) {
            this.shell.copy();
        } else if (cmd.equals(PASTE)) {
            this.shell.paste();
        }
    }

    private void goUpAction(ActionEvent ev) {
        this.display(Messages.getString("ClientFrame.94"));
        this.process.setAction("cd ..");
    }

    private void newCollectionAction(ActionEvent ev) {
        String newCol = JOptionPane.showInputDialog(this, (Object)Messages.getString("ClientFrame.96"));
        if (newCol != null) {
            String command = "mkcol \"" + newCol + '\"';
            this.display(command + "\n");
            this.process.setAction(command);
        }
    }

    private void newServerURIAction(String newURI) {
        if (newURI == null) {
            newURI = JOptionPane.showInputDialog(this, (Object)(Messages.getString("ClientFrame.99") + Messages.getString("ClientFrame.100")));
        }
        if (newURI != null) {
            this.properties.setProperty("uri", newURI);
            try {
                this.client.shutdown(false);
                this.client.connect();
            }
            catch (Exception e) {
                ClientFrame.showErrorMessage(Messages.getString("ClientFrame.102") + newURI + Messages.getString("ClientFrame.103"), e);
            }
        }
    }

    private ResourceDescriptor[] getSelectedResources() {
        int[] selectedRows = this.fileman.getSelectedRows();
        ResourceDescriptor[] res = new ResourceDescriptor[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            res[i] = this.resources.getRow(selectedRows[i]);
        }
        return res;
    }

    private void removeAction(ActionEvent ev) {
        final ResourceDescriptor[] res = this.getSelectedResources();
        if (JOptionPane.showConfirmDialog(this, Messages.getString("ClientFrame.104") + Messages.getString("ClientFrame.105"), Messages.getString("ClientFrame.106"), 0) == 0) {
            Runnable removeTask = new Runnable(){

                public void run() {
                    ProgressMonitor monitor = new ProgressMonitor(ClientFrame.this, Messages.getString("ClientFrame.107"), Messages.getString("ClientFrame.108"), 1, res.length);
                    monitor.setMillisToDecideToPopup(500);
                    monitor.setMillisToPopup(500);
                    for (int i = 0; i < res.length; ++i) {
                        ResourceDescriptor resource = res[i];
                        if (resource.isCollection()) {
                            try {
                                CollectionManagementServiceImpl mgtService = (CollectionManagementServiceImpl)((ClientFrame)ClientFrame.this).client.current.getService("CollectionManagementService", "1.0");
                                mgtService.removeCollection(resource.getName());
                            }
                            catch (XMLDBException e) {
                                ClientFrame.showErrorMessage(e.getMessage(), e);
                            }
                        } else {
                            try {
                                Resource res2 = ((ClientFrame)ClientFrame.this).client.current.getResource(resource.getName().toString());
                                ((ClientFrame)ClientFrame.this).client.current.removeResource(res2);
                            }
                            catch (XMLDBException e) {
                                ClientFrame.showErrorMessage(e.getMessage(), e);
                            }
                        }
                        monitor.setProgress(i + 1);
                        if (!monitor.isCanceled()) continue;
                        return;
                    }
                    try {
                        ClientFrame.this.client.getResources();
                    }
                    catch (XMLDBException e) {
                        ClientFrame.showErrorMessage(e.getMessage(), e);
                    }
                }
            };
            new Thread(removeTask).start();
        }
    }

    private void moveAction(ActionEvent ev) {
        final ResourceDescriptor[] res = this.getSelectedResources();
        Object[] collections = null;
        try {
            Collection root = this.client.getCollection("/db");
            ArrayList alCollections = this.getCollections(root, new ArrayList());
            collections = new PrettyXmldbURI[alCollections.size()];
            alCollections.toArray(collections);
        }
        catch (XMLDBException e) {
            ClientFrame.showErrorMessage(e.getMessage(), e);
            return;
        }
        Object val = JOptionPane.showInputDialog(this, Messages.getString("ClientFrame.111"), Messages.getString("ClientFrame.112"), 3, null, collections, collections[0]);
        if (val == null) {
            return;
        }
        final XmldbURI destinationPath = ((PrettyXmldbURI)val).getTargetURI();
        Runnable moveTask = new Runnable(){

            public void run() {
                try {
                    CollectionManagementServiceImpl service = (CollectionManagementServiceImpl)((ClientFrame)ClientFrame.this).client.current.getService("CollectionManagementService", "1.0");
                    for (int i = 0; i < res.length; ++i) {
                        ClientFrame.this.setStatus(Messages.getString("ClientFrame.115") + res[i].getName() + Messages.getString("ClientFrame.116") + destinationPath + Messages.getString("ClientFrame.117"));
                        if (res[i].isCollection()) {
                            service.move(res[i].getName(), destinationPath, null);
                            continue;
                        }
                        service.moveResource(res[i].getName(), destinationPath, null);
                    }
                    ClientFrame.this.client.reloadCollection();
                }
                catch (XMLDBException e) {
                    ClientFrame.showErrorMessage(e.getMessage(), e);
                }
                ClientFrame.this.setStatus(Messages.getString("ClientFrame.118"));
            }
        };
        new Thread(moveTask).start();
    }

    private void renameAction(ActionEvent ev) {
        XmldbURI parseIt;
        final ResourceDescriptor[] res = this.getSelectedResources();
        String val = JOptionPane.showInputDialog(this, Messages.getString("ClientFrame.119"), Messages.getString("ClientFrame.120"), 3);
        if (val == null) {
            return;
        }
        try {
            parseIt = URIUtils.encodeXmldbUriFor(val);
        }
        catch (URISyntaxException e) {
            ClientFrame.showErrorMessage(Messages.getString("ClientFrame.121") + e.getMessage(), e);
            return;
        }
        final XmldbURI destinationFilename = parseIt;
        Runnable renameTask = new Runnable(){

            public void run() {
                try {
                    CollectionManagementServiceImpl service = (CollectionManagementServiceImpl)((ClientFrame)ClientFrame.this).client.current.getService("CollectionManagementService", "1.0");
                    for (int i = 0; i < res.length; ++i) {
                        ClientFrame.this.setStatus(Messages.getString("ClientFrame.124") + res[i].getName() + Messages.getString("ClientFrame.125") + destinationFilename + Messages.getString("ClientFrame.126"));
                        if (res[i].isCollection()) {
                            service.move(res[i].getName(), null, destinationFilename);
                            continue;
                        }
                        service.moveResource(res[i].getName(), null, destinationFilename);
                    }
                    ClientFrame.this.client.reloadCollection();
                }
                catch (XMLDBException e) {
                    ClientFrame.showErrorMessage(e.getMessage(), e);
                }
                ClientFrame.this.setStatus(Messages.getString("ClientFrame.127"));
            }
        };
        new Thread(renameTask).start();
    }

    private void copyAction(ActionEvent ev) {
        final ResourceDescriptor[] res = this.getSelectedResources();
        Object[] collections = null;
        try {
            Collection root = this.client.getCollection("/db");
            ArrayList alCollections = this.getCollections(root, new ArrayList());
            collections = new PrettyXmldbURI[alCollections.size()];
            alCollections.toArray(collections);
        }
        catch (XMLDBException e) {
            ClientFrame.showErrorMessage(e.getMessage(), e);
            return;
        }
        Object val = JOptionPane.showInputDialog(this, Messages.getString("ClientFrame.128"), Messages.getString("ClientFrame.129"), 3, null, collections, collections[0]);
        if (val == null) {
            return;
        }
        final XmldbURI destinationPath = ((PrettyXmldbURI)val).getTargetURI();
        Runnable moveTask = new Runnable(){

            public void run() {
                try {
                    CollectionManagementServiceImpl service = (CollectionManagementServiceImpl)((ClientFrame)ClientFrame.this).client.current.getService("CollectionManagementService", "1.0");
                    for (int i = 0; i < res.length; ++i) {
                        ClientFrame.this.setStatus(Messages.getString("ClientFrame.132") + res[i].getName() + Messages.getString("ClientFrame.133") + destinationPath + Messages.getString("ClientFrame.134"));
                        if (res[i].isCollection()) {
                            service.copy(res[i].getName(), destinationPath, null);
                            continue;
                        }
                        service.copyResource(res[i].getName(), destinationPath, null);
                    }
                    ClientFrame.this.client.reloadCollection();
                }
                catch (XMLDBException e) {
                    ClientFrame.showErrorMessage(e.getMessage(), e);
                }
                ClientFrame.this.setStatus(Messages.getString("ClientFrame.135"));
            }
        };
        new Thread(moveTask).start();
    }

    private ArrayList getCollections(Collection root, ArrayList collectionsList) throws XMLDBException {
        collectionsList.add(new PrettyXmldbURI(XmldbURI.create(root.getName())));
        String[] childCollections = root.listChildCollections();
        for (int i = 0; i < childCollections.length; ++i) {
            Collection child = root.getChildCollection(childCollections[i]);
            this.getCollections(child, collectionsList);
        }
        return collectionsList;
    }

    private void reindexAction(ActionEvent ev) {
        ResourceDescriptor[] res;
        int[] selRows = this.fileman.getSelectedRows();
        if (selRows.length == 0) {
            res = new ResourceDescriptor[]{new ResourceDescriptor.Collection(this.client.path)};
        } else {
            res = new ResourceDescriptor[selRows.length];
            for (int i = 0; i < selRows.length; ++i) {
                res[i] = this.resources.getRow(selRows[i]);
                if (res[i].isCollection()) continue;
                JOptionPane.showMessageDialog(this, Messages.getString("ClientFrame.136"), Messages.getString("ClientFrame.137"), 0);
                return;
            }
        }
        if (JOptionPane.showConfirmDialog(this, Messages.getString("ClientFrame.138"), Messages.getString("ClientFrame.139"), 0) == 0) {
            final ResourceDescriptor[] collections = res;
            Runnable reindexThread = new Runnable(){

                public void run() {
                    ClientFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        IndexQueryService service = (IndexQueryService)((ClientFrame)ClientFrame.this).client.current.getService("IndexQueryService", "1.0");
                        for (int i = 0; i < collections.length; ++i) {
                            ResourceDescriptor next = collections[i];
                            ClientFrame.this.setStatus(Messages.getString("ClientFrame.142") + next.getName() + Messages.getString("ClientFrame.143"));
                            service.reindexCollection(next.getName());
                        }
                        ClientFrame.this.setStatus(Messages.getString("ClientFrame.144"));
                    }
                    catch (XMLDBException e) {
                        ClientFrame.showErrorMessage(e.getMessage(), e);
                    }
                    ClientFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            };
            new Thread(reindexThread).start();
        }
    }

    private void uploadAction(ActionEvent ev) {
        String dir = this.properties.getProperty(Messages.getString("ClientFrame.145"), SingleInstanceConfiguration.getPath());
        JFileChooser chooser = new JFileChooser(dir);
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileSelectionMode(2);
        chooser.addChoosableFileFilter(new BinaryFileFilter());
        chooser.addChoosableFileFilter(new XMLFileFilter());
        if (chooser.showDialog(this, Messages.getString("ClientFrame.146")) == 0) {
            final File[] files = chooser.getSelectedFiles();
            if (files.length > 0) {
                new Thread(){

                    public void run() {
                        UploadDialog upload = new UploadDialog();
                        try {
                            ClientFrame.this.client.parse(files, upload);
                            ClientFrame.this.client.getResources();
                        }
                        catch (XMLDBException e) {
                            ClientFrame.showErrorMessage(Messages.getString("ClientFrame.147") + e.getMessage(), e);
                        }
                    }
                }.start();
            }
            File selectedDir = chooser.getCurrentDirectory();
            this.properties.setProperty("working-dir", selectedDir.getAbsolutePath());
        }
    }

    private boolean deleteDirectory(File target) {
        if (target.isDirectory()) {
            String[] children = target.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDirectory(new File(target, children[i]));
                if (success) continue;
                return false;
            }
        }
        return target.delete();
    }

    private void backupAction(ActionEvent ev) {
        CreateBackupDialog dialog = new CreateBackupDialog(this.properties.getProperty("uri", "xmldb:exist://"), this.properties.getProperty("user", "admin"), this.properties.getProperty("password", null), this.properties.getProperty("backup-dir", System.getProperty("user.home") + File.separatorChar + "eXist-backup.zip"));
        if (JOptionPane.showOptionDialog(this, dialog, Messages.getString("ClientFrame.157"), 2, 3, null, null, null) == 0) {
            String collection = dialog.getCollection();
            String backuptarget = dialog.getBackupTarget();
            File target = new File(backuptarget);
            if (target.exists() && JOptionPane.showConfirmDialog(this, Messages.getString("CreateBackupDialog.6a") + " " + backuptarget + " " + Messages.getString("CreateBackupDialog.6b"), Messages.getString("CreateBackupDialog.6c"), 0) == 1) {
                this.deleteDirectory(target);
            }
            try {
                Backup backup = new Backup(this.properties.getProperty("user", "admin"), this.properties.getProperty("password", null), backuptarget, XmldbURI.xmldbUriFor(this.properties.getProperty("uri", "xmldb:exist://") + collection));
                backup.backup(true, this);
            }
            catch (XMLDBException e) {
                ClientFrame.showErrorMessage("XMLDBException: " + e.getMessage(), e);
            }
            catch (IOException e) {
                ClientFrame.showErrorMessage("IOException: " + e.getMessage(), e);
            }
            catch (SAXException e) {
                ClientFrame.showErrorMessage("SAXException: " + e.getMessage(), e);
            }
            catch (URISyntaxException e) {
                ClientFrame.showErrorMessage("URISyntaxException: " + e.getMessage(), e);
            }
        }
    }

    private void restoreAction(ActionEvent ev) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.addChoosableFileFilter(new BackupContentsFilter());
        if (chooser.showDialog(null, Messages.getString("ClientFrame.169")) == 0) {
            JPanel askPass = new JPanel(new BorderLayout());
            askPass.add((Component)new JLabel(Messages.getString("ClientFrame.170")), "North");
            JPasswordField passInput = new JPasswordField(25);
            askPass.add((Component)passInput, "Center");
            if (JOptionPane.showOptionDialog(this, askPass, Messages.getString("ClientFrame.171"), 2, 3, null, null, null) == 0) {
                String newDbaPass = passInput.getPassword().length == 0 ? null : new String(passInput.getPassword());
                File f = chooser.getSelectedFile();
                String restoreFile = f.getAbsolutePath();
                try {
                    Restore restore = new Restore(this.properties.getProperty("user", "admin"), this.properties.getProperty("password", null), newDbaPass, new File(restoreFile), this.properties.getProperty("uri", "xmldb:exist://"));
                    restore.restore(true, this);
                    if (this.properties.getProperty("user", "admin").equals("admin") && newDbaPass != null) {
                        this.properties.setProperty("password", newDbaPass);
                    }
                    this.client.reloadCollection();
                }
                catch (Exception e) {
                    ClientFrame.showErrorMessage(Messages.getString("ClientFrame.181") + e.getMessage(), e);
                }
            }
        }
    }

    private void editUsersAction(ActionEvent ev) {
        try {
            Collection collection = this.client.getCollection();
            UserManagementService service = (UserManagementService)collection.getService("UserManagementService", "1.0");
            UserDialog dialog = new UserDialog(service, Messages.getString("ClientFrame.184"), this.client);
            dialog.setVisible(true);
        }
        catch (XMLDBException e) {
            ClientFrame.showErrorMessage(Messages.getString("ClientFrame.185"), e);
            e.printStackTrace();
        }
    }

    private void exportAction(ActionEvent ev) {
        block9: {
            if (this.fileman.getSelectedRowCount() == 0) {
                return;
            }
            int row = this.fileman.getSelectedRow();
            ResourceDescriptor desc = this.resources.getRow(row);
            if (desc.isCollection()) {
                return;
            }
            String workDir = this.properties.getProperty("working-dir", System.getProperty("user.dir"));
            JFileChooser chooser = new JFileChooser(workDir);
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileSelectionMode(0);
            chooser.setSelectedFile(new File(desc.getName().toString()));
            if (chooser.showDialog(this, "Select file for export") == 0) {
                File file = chooser.getSelectedFile();
                if (file.exists() && JOptionPane.showConfirmDialog(this, "File exists. Overwrite?", "Overwrite?", 0) == 1) {
                    return;
                }
                try {
                    Collection collection = this.client.getCollection();
                    try {
                        Resource resource = collection.getResource(desc.getName().toString());
                        FileOutputStream os = new FileOutputStream(file);
                        if (resource.getResourceType().equals("BinaryResource")) {
                            byte[] bdata = (byte[])resource.getContent();
                            os.write(bdata);
                            os.close();
                            break block9;
                        }
                        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
                        SAXSerializer contentSerializer = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
                        contentSerializer.setOutput(writer, this.properties);
                        ((EXistResource)resource).setLexicalHandler(contentSerializer);
                        ((XMLResource)resource).getContentAsSAX((ContentHandler)contentSerializer);
                        SerializerPool.getInstance().returnObject(contentSerializer);
                        writer.close();
                    }
                    catch (Exception e) {
                        System.err.println("An exception occurred while writing the resource: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    System.err.println("An exception occurred" + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    private void editIndexesAction(ActionEvent ev) {
        IndexDialog dialog = new IndexDialog(Messages.getString("ClientFrame.186"), this.client);
        dialog.setVisible(true);
    }

    private void editTriggersAction(ActionEvent ev) {
        TriggersDialog dialog = new TriggersDialog("Edit Triggers", this.client);
        dialog.setVisible(true);
    }

    private void editPolicies() {
        Collection systemCollection;
        try {
            systemCollection = this.client.getCollection("/db/system");
        }
        catch (XMLDBException e) {
            ClientFrame.showErrorMessage(Messages.getString("ClientFrame.187"), e);
            return;
        }
        try {
            DatabaseInstanceManager dim = (DatabaseInstanceManager)systemCollection.getService("DatabaseInstanceManager", "1.0");
            if (!dim.isXACMLEnabled()) {
                ClientFrame.showErrorMessage(Messages.getString("ClientFrame.190"), null);
                return;
            }
        }
        catch (XMLDBException e) {
            ClientFrame.showErrorMessage(Messages.getString("ClientFrame.191"), e);
            return;
        }
        XACMLEditor editor = new XACMLEditor(systemCollection);
        editor.show();
    }

    private void findAction(ActionEvent ev) {
        Collection collection = this.client.getCollection();
        QueryDialog dialog = new QueryDialog(this.client, collection, this.properties);
        dialog.setVisible(true);
    }

    private void setPermAction(ActionEvent ev) {
        if (this.fileman.getSelectedRowCount() == 0) {
            return;
        }
        try {
            XmldbURI name;
            Collection collection = this.client.getCollection();
            UserManagementService service = (UserManagementService)collection.getService("UserManagementService", "1.0");
            Permission perm = null;
            Date created = new Date();
            Date modified = null;
            String mimeType = null;
            if (this.fileman.getSelectedRowCount() == 1) {
                int row = this.fileman.getSelectedRow();
                ResourceDescriptor desc = this.resources.getRow(row);
                name = desc.getName();
                if (desc.isCollection()) {
                    Collection coll = collection.getChildCollection(name.toString());
                    created = ((CollectionImpl)coll).getCreationTime();
                    perm = service.getPermissions(coll);
                } else {
                    Resource res = collection.getResource(name.toString());
                    created = ((EXistResource)res).getCreationTime();
                    modified = ((EXistResource)res).getLastModificationTime();
                    mimeType = ((EXistResource)res).getMimeType();
                    perm = service.getPermissions(res);
                }
            } else {
                name = XmldbURI.create("..");
                perm = PermissionFactory.getPermission("", "", 493);
            }
            ResourcePropertyDialog dialog = new ResourcePropertyDialog(this, service, name, perm, created, modified, mimeType);
            dialog.setVisible(true);
            if (dialog.getResult() == 0) {
                int[] rows = this.fileman.getSelectedRows();
                for (int i = 0; i < rows.length; ++i) {
                    ResourceDescriptor desc = this.resources.getRow(rows[i]);
                    if (desc.isCollection()) {
                        Collection coll = collection.getChildCollection(desc.getName().toString());
                        service.setPermissions(coll, dialog.permissions);
                        continue;
                    }
                    Resource res = collection.getResource(desc.getName().toString());
                    service.setPermissions(res, dialog.permissions);
                }
                this.client.reloadCollection();
            }
        }
        catch (XMLDBException e) {
            ClientFrame.showErrorMessage(Messages.getString("ClientFrame.197") + e.getMessage(), e);
            e.printStackTrace();
        }
    }

    private void enter() {
        int end = this.doc.getLength();
        if (end - this.commandStart == 0) {
            return;
        }
        try {
            String command = this.doc.getText(this.commandStart, end - this.commandStart);
            this.commandStart = end;
            this.doc.insertString(this.commandStart++, "\n", defaultAttrs);
            if (command != null) {
                this.process.setAction(command);
                this.client.console.getHistory().addToHistory(command);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void historyBack() {
        this.client.console.getHistory().previous();
        String item = this.client.console.getHistory().current();
        if (item == null) {
            return;
        }
        try {
            if (this.shell.getCaretPosition() > this.commandStart) {
                this.doc.remove(this.commandStart, this.doc.getLength() - this.commandStart);
            }
            this.doc.insertString(this.commandStart, item, defaultAttrs);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void historyForward() {
        this.client.console.getHistory().next();
        String item = this.client.console.getHistory().current();
        try {
            if (this.shell.getCaretPosition() > this.commandStart) {
                this.doc.remove(this.commandStart, this.doc.getLength() - this.commandStart);
            }
            this.doc.insertString(this.commandStart, item, defaultAttrs);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
        this.process.terminate();
        System.exit(0);
    }

    private void actionFinished() {
        if (!this.process.getStatus()) {
            this.close();
        }
        this.displayPrompt();
    }

    private void AboutAction() {
        Properties sysProperties = InteractiveClient.getSystemProperties();
        JOptionPane.showMessageDialog(this, sysProperties.getProperty("product-name") + " version " + sysProperties.getProperty("product-version") + " (revision " + sysProperties.getProperty("svn-revision") + ") \n\n" + "Copyright (C) 2001-2007 Wolfgang Meier\n\n" + "eXist comes with ABSOLUTELY NO WARRANTY.\n" + "This is free software, and you are welcome to\n" + "redistribute it under certain conditions;\n" + "for details read the license file.");
    }

    protected static Properties getLoginData(Properties properties) {
        LoginPanel login = new LoginPanel(properties);
        Properties sysProperties = InteractiveClient.getSystemProperties();
        if (JOptionPane.showOptionDialog(null, login, sysProperties.getProperty("product-name") + " " + sysProperties.getProperty("product-version") + " Database Login", 2, 3, null, null, null) == 0) {
            return login.getProperties();
        }
        return null;
    }

    public static void showErrorMessage(String message, Throwable t) {
        JScrollPane scroll = null;
        JTextArea msgArea = new JTextArea(message);
        msgArea.setBorder(BorderFactory.createTitledBorder(Messages.getString("ClientFrame.214")));
        msgArea.setEditable(false);
        msgArea.setBackground(null);
        if (t != null) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            t.printStackTrace(writer);
            JTextArea stacktrace = new JTextArea(out.toString(), 20, 50);
            stacktrace.setBackground(null);
            stacktrace.setEditable(false);
            scroll = new JScrollPane(stacktrace);
            scroll.setPreferredSize(new Dimension(250, 300));
            scroll.setBorder(BorderFactory.createTitledBorder(Messages.getString("ClientFrame.215")));
        }
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessage(new Object[]{msgArea, scroll});
        optionPane.setMessageType(0);
        JDialog dialog = optionPane.createDialog(null, Messages.getString("ClientFrame.216"));
        dialog.setResizable(true);
        dialog.pack();
        dialog.setVisible(true);
    }

    public static int showErrorMessageQuery(String message, Throwable t) {
        JScrollPane scroll = null;
        JTextArea msgArea = new JTextArea(message);
        msgArea.setBorder(BorderFactory.createTitledBorder(Messages.getString("ClientFrame.217")));
        msgArea.setEditable(false);
        msgArea.setBackground(null);
        if (t != null) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            t.printStackTrace(writer);
            JTextArea stacktrace = new JTextArea(out.toString(), 20, 50);
            stacktrace.setBackground(null);
            stacktrace.setEditable(false);
            scroll = new JScrollPane(stacktrace);
            scroll.setPreferredSize(new Dimension(250, 300));
            scroll.setBorder(BorderFactory.createTitledBorder(Messages.getString("ClientFrame.218")));
        }
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessage(new Object[]{msgArea, scroll});
        optionPane.setMessageType(0);
        optionPane.setOptionType(2);
        JDialog dialog = optionPane.createDialog(null, Messages.getString("ClientFrame.219"));
        dialog.setResizable(true);
        dialog.pack();
        dialog.setVisible(true);
        Object result = optionPane.getValue();
        if (result == null) {
            return 2;
        }
        return (Integer)optionPane.getValue();
    }

    public void windowGainedFocus(WindowEvent e) {
        this.toFront();
    }

    public void windowLostFocus(WindowEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.shellPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.shellPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    class XMLFileFilter
    extends FileFilter {
        XMLFileFilter() {
        }

        public String getDescription() {
            return Messages.getString("ClientFrame.221");
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return MimeTable.getInstance().isXMLContent(f.getName());
        }
    }

    class BinaryFileFilter
    extends FileFilter {
        BinaryFileFilter() {
        }

        public String getDescription() {
            return Messages.getString("ClientFrame.220");
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return !MimeTable.getInstance().isXMLContent(f.getName());
        }
    }

    static class ResourceTableCellRenderer
    implements TableCellRenderer {
        public static final Color collectionBackground = new Color(225, 235, 224);
        public static final Color collectionForeground = Color.black;
        public static final Color highBackground = new Color(115, 130, 189);
        public static final Color highForeground = Color.white;
        public static final Color altBackground = new Color(235, 235, 235);
        public static final DefaultTableCellRenderer DEFAULT_RENDERER = new DefaultTableCellRenderer();

        ResourceTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color background;
            Color foreground;
            if (value instanceof XmldbURI) {
                value = new PrettyXmldbURI((XmldbURI)value);
            }
            Component renderer = DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ((JLabel)renderer).setOpaque(true);
            ResourceTableModel resources = (ResourceTableModel)table.getModel();
            if (isSelected) {
                foreground = highForeground;
                background = highBackground;
            } else if (resources.getRow(row).isCollection()) {
                foreground = collectionForeground;
                background = collectionBackground;
            } else if (row % 2 == 0) {
                background = altBackground;
                foreground = Color.black;
            } else {
                foreground = Color.black;
                background = Color.white;
            }
            renderer.setForeground(foreground);
            renderer.setBackground(background);
            return renderer;
        }
    }

    class ResourceTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames = new String[]{Messages.getString("ClientFrame.207"), Messages.getString("ClientFrame.208"), Messages.getString("ClientFrame.209"), Messages.getString("ClientFrame.210"), Messages.getString("ClientFrame.211")};
        private List rows = null;

        ResourceTableModel() {
        }

        public void setData(List rows) {
            Collections.sort(rows, new ResourceComparator());
            this.rows = rows;
            this.fireTableDataChanged();
        }

        public ResourceDescriptor getRow(int index) {
            return (ResourceDescriptor)this.rows.get(index);
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public int getRowCount() {
            return this.rows == null ? 0 : this.rows.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            ResourceDescriptor row = this.getRow(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return row.getName();
                }
                case 1: {
                    return row.getDate();
                }
                case 2: {
                    return row.getOwner();
                }
                case 3: {
                    return row.getGroup();
                }
                case 4: {
                    return row.getPermissions();
                }
            }
            throw new RuntimeException(Messages.getString("ClientFrame.212"));
        }
    }

    class ProcessThread
    extends Thread {
        private String action = null;
        private boolean terminate = false;
        private boolean status = false;

        public synchronized void setAction(String action) {
            while (this.action != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.action = action;
            this.notify();
        }

        public synchronized void terminate() {
            this.terminate = true;
            this.notify();
        }

        public synchronized boolean getStatus() {
            return this.status;
        }

        public boolean isReady() {
            return this.action == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.terminate) {
                ProcessThread processThread;
                while (this.action == null) {
                    try {
                        processThread = this;
                        synchronized (processThread) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                this.status = ClientFrame.this.client.process(this.action);
                processThread = this;
                synchronized (processThread) {
                    this.action = null;
                    ClientFrame.this.actionFinished();
                    this.notify();
                }
            }
        }
    }

    private static class ResourceComparator
    implements Comparator {
        private ResourceComparator() {
        }

        public int compare(Object aO1, Object aO2) {
            ResourceDescriptor desc1 = (ResourceDescriptor)aO1;
            ResourceDescriptor desc2 = (ResourceDescriptor)aO2;
            if (desc1.isCollection() != desc2.isCollection()) {
                return desc1.isCollection() ? -1 : 1;
            }
            return desc1.getName().compareTo(desc2.getName());
        }
    }

    class TableMouseListener
    extends MouseAdapter {
        TableMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int row = ClientFrame.this.fileman.getSelectedRow();
                ResourceDescriptor resource = ClientFrame.this.resources.getRow(row);
                if (resource.isCollection()) {
                    String command = "cd \"" + URIUtils.urlDecodeUtf8(resource.getName()) + '\"';
                    ClientFrame.this.display(command + "\n");
                    ClientFrame.this.process.setAction(command);
                } else {
                    ClientFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        DocumentView view = new DocumentView(ClientFrame.this.client, resource.getName(), ClientFrame.this.properties);
                        view.setSize(new Dimension(640, 400));
                        view.viewDocument();
                    }
                    catch (XMLDBException ex) {
                        ClientFrame.showErrorMessage(Messages.getString("ClientFrame.206") + ex.getMessage(), ex);
                    }
                    ClientFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }
}

