/*
 * Decompiled with CFR 0.152.
 */
package org.exist.cluster;

import org.apache.log4j.Logger;
import org.exist.cluster.ClusterEvent;
import org.exist.cluster.ClusterException;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.modules.XMLResource;

public class StoreClusterEvent
extends ClusterEvent {
    static Logger log = Logger.getLogger((Class)StoreClusterEvent.class);
    private String content;
    private static final long serialVersionUID = 0L;

    public StoreClusterEvent(String content, String collectionName, String documentName) {
        super(documentName, collectionName);
        this.content = content;
    }

    public void execute() throws ClusterException {
        try {
            Collection collection = this.getCollection();
            XMLResource document = (XMLResource)collection.createResource(this.documentName, "XMLResource");
            document.setContent((Object)this.content);
            log.info((Object)("Storing document " + document.getId() + "..."));
            collection.storeResource((Resource)document);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new ClusterException(e);
        }
    }

    public String toString() {
        return "StoreClusterEvent: [content: " + this.content + "] [collection:" + this.collectionName + "] [documentname:" + this.documentName + "]";
    }

    public int hashCode() {
        int e = this.documentName.hashCode();
        e ^= this.content.hashCode();
        e ^= this.collectionName.hashCode();
        return e ^= this.getClass().getName().hashCode();
    }
}

