/*
 * Decompiled with CFR 0.152.
 */
package org.exist.cluster.journal;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.exist.cluster.ClusterEvent;
import org.exist.cluster.ClusterException;
import org.exist.cluster.journal.ClusterEventMarshaller;
import org.exist.util.Configuration;

public class JournalManager {
    public static final String JOURNAL_DIR_ATTRIBUTE = "journalDir";
    public static final String CLUSTER_JOURNAL_MAXSTORE_ATTRIBUTE = "journalMaxItem";
    public static final String CLUSTER_JOURNAL_SHIFT_ATTRIBUTE = "journalIndexShift";
    public static final String PROPERTY_JOURNAL_DIR = "cluster.journalDir";
    public static final String PROPERTY_CLUSTER_JOURNAL_MAXSTORE = "cluster.journal.maxStore";
    public static final String PROPERTY_CLUSTER_JOURNAL_SHIFT = "cluster.journal.shift";
    private static final String JOURNAL_INDEX_FILE = "jei.jbx";
    private static final String JOURNAL_STORAGE_FILE_EXTENSION = ".jbx";
    public static int JOURNAL_STORAGE_FILE_MAX_SIZE = 0xA00000;
    private static final int JOURNAL_INDEX_TRUNK_SIZE = 20;
    private static final int JOURNAL_INDEX_FIRST_TRUNK_SIZE = 12;
    public static int REALIGN_MAX_BLOCK_SIZE = 20;
    private static Logger log = Logger.getLogger((Class)JournalManager.class);
    private File dir;
    private File indexFile;
    private boolean journalDisabled = false;
    private boolean isNewJournal = false;
    private int lastIdSaved = -1;
    private int counter = 1;
    private int maxIdSaved = -1;
    TreeSet queue = new TreeSet(new EventComparator());

    public JournalManager(Configuration conf) {
        String dirName = (String)conf.getProperty(PROPERTY_JOURNAL_DIR);
        if (dirName == null) {
            this.journalDisabled = true;
            return;
        }
        this.dir = new File(dirName);
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
        this.indexFile = new File(this.dir, JOURNAL_INDEX_FILE);
        if (!this.indexFile.exists()) {
            try {
                this.indexFile.createNewFile();
                this.writeInitialHeader();
                this.isNewJournal = true;
            }
            catch (IOException e) {
                log.error((Object)"Error creating index file... disabling jornal");
                this.journalDisabled = true;
            }
        } else {
            int[] header = this.getHeaderData();
            this.lastIdSaved = header[0];
            this.maxIdSaved = header[1];
            this.counter = header[2];
            this.checkNewJournal();
        }
    }

    private void checkNewJournal() {
        if (this.lastIdSaved == -1) {
            this.isNewJournal = true;
        }
    }

    private void writeInitialHeader() {
        try {
            RandomAccessFile raf = new RandomAccessFile(this.indexFile, "rws");
            raf.writeInt(this.lastIdSaved);
            raf.writeInt(this.maxIdSaved);
            raf.writeInt(this.counter);
            raf.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Error create initila header");
        }
    }

    public int getLastIdSaved() {
        if (this.lastIdSaved != -1) {
            return this.lastIdSaved;
        }
        if (this.isNewJournal || this.journalDisabled) {
            return -1;
        }
        return this.getHeaderData()[0];
    }

    public int getMaxIdSaved() {
        if (this.maxIdSaved != -1) {
            return this.maxIdSaved;
        }
        if (this.isNewJournal || this.journalDisabled) {
            return -1;
        }
        return this.getHeaderData()[1];
    }

    public int getCounter() {
        if (this.counter != -1) {
            return this.counter;
        }
        if (this.isNewJournal || this.journalDisabled) {
            return 1;
        }
        return this.getHeaderData()[2];
    }

    private int[] getHeaderData() {
        int[] header = new int[3];
        try {
            RandomAccessFile raf = new RandomAccessFile(this.indexFile, "r");
            header[0] = raf.readInt();
            header[1] = raf.readInt();
            header[2] = raf.readInt();
            raf.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Error during retrieving last id");
        }
        return header;
    }

    public boolean isProcessed(ClusterEvent event) {
        if (this.journalDisabled) {
            return false;
        }
        int id = event.getId();
        if (this.queue.contains(event)) {
            return true;
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(this.indexFile, "r");
            raf.seek(12 + id * 20 + 16);
            int counter = raf.readInt();
            raf.close();
            return event.getCounter() == counter;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void squeueEvent() throws ClusterException {
        if (this.journalDisabled) {
            log.info((Object)"Error persisting data..... journal disabled");
            return;
        }
        boolean done = false;
        while (this.queue.size() > 0) {
            done = true;
            ClusterEvent event = (ClusterEvent)this.queue.first();
            this.saveEvent(event);
            this.queue.remove(event);
        }
        if (done) {
            int[] header = this.getHeaderData();
            System.out.println("IN SYNC last = " + header[0] + " MAX = " + header[1] + " COUNTER = " + header[2]);
        }
    }

    public void enqueEvent(ClusterEvent event) throws ClusterException {
        if (this.journalDisabled) {
            log.info((Object)"Error persisting data..... journal disabled");
            return;
        }
        int id = event.getId();
        if (id == -1) {
            throw new ClusterException("Error in Journal managment... no id found in event");
        }
        this.queue.add(event);
    }

    private void saveEvent(ClusterEvent event) {
        int id = event.getId();
        int counter = event.getCounter();
        try {
            byte[] eventBytes = ClusterEventMarshaller.marshall(event);
            int start = 0;
            int end = eventBytes.length;
            int file = 0;
            RandomAccessFile raf = new RandomAccessFile(this.indexFile, "rws");
            if (!this.isNewJournal) {
                int prev = this.lastIdSaved;
                raf.seek(12 + prev * 20);
                raf.readInt();
                raf.readInt();
                int prevEnd = raf.readInt();
                int prevFile = raf.readInt();
                start = prevEnd;
                end = prevEnd + eventBytes.length;
                file = prevFile;
                if (prevEnd > JOURNAL_STORAGE_FILE_MAX_SIZE) {
                    start = 0;
                    end = eventBytes.length;
                    ++file;
                }
            } else {
                this.isNewJournal = false;
            }
            this.writeDataFile(file, start, eventBytes);
            raf.seek(12 + id * 20);
            raf.writeInt(id);
            raf.writeInt(start);
            raf.writeInt(end);
            raf.writeInt(file);
            raf.writeInt(counter);
            this.lastIdSaved = id;
            System.out.println(">>>>>>>>>> ID " + id);
            System.out.println(">>>>>>>>>> COUNTER " + counter);
            if (id > this.maxIdSaved && this.counter == counter || this.counter == counter - 1) {
                this.maxIdSaved = id;
            }
            if (this.counter == counter - 1) {
                this.counter = counter;
            }
            System.out.println("********** HEADER ID = " + this.lastIdSaved);
            System.out.println("********** HEADER MAXID = " + this.maxIdSaved);
            System.out.println("********** HEADER COUNTER = " + this.counter);
            raf.seek(0L);
            raf.writeInt(this.lastIdSaved);
            raf.writeInt(this.maxIdSaved);
            raf.writeInt(this.counter);
            raf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("Error writing journal file... for ID : " + id));
            throw new RuntimeException("Error writing journal file for ID : " + id, e);
        }
    }

    private void writeDataFile(int file, int start, byte[] eventBytes) throws IOException {
        File storage = new File(this.dir, file + JOURNAL_STORAGE_FILE_EXTENSION);
        RandomAccessFile store = new RandomAccessFile(storage, "rws");
        store.seek(start);
        store.write(eventBytes);
        store.close();
    }

    public synchronized ClusterEvent read(int id) {
        try {
            RandomAccessFile raf = new RandomAccessFile(this.indexFile, "r");
            raf.seek(12 + id * 20);
            raf.readInt();
            int start = raf.readInt();
            int end = raf.readInt();
            int file = raf.readInt();
            raf.close();
            return this.readFromStorage(end, start, file);
        }
        catch (Exception e) {
            log.error((Object)("Error reading journal file ... " + e));
            throw new RuntimeException("Error rading journal file " + e);
        }
    }

    private ClusterEvent readFromStorage(int end, int start, int file) throws IOException {
        byte[] eventBytes = new byte[end - start];
        File storage = new File(this.dir, file + JOURNAL_STORAGE_FILE_EXTENSION);
        RandomAccessFile store = new RandomAccessFile(storage, "r");
        store.seek(start);
        store.read(eventBytes);
        store.close();
        return ClusterEventMarshaller.unmarshall(eventBytes);
    }

    public ArrayList getNextEvents(int[] header, int[] myHeader, Integer start) {
        if (this.journalDisabled) {
            return null;
        }
        System.out.println("Get next events : lastIdSaved " + header[0] + " maxId " + header[1] + " counter:" + header[2]);
        System.out.println("Get next events saved : lastIdSaved " + myHeader[0] + " maxId " + myHeader[1] + " counter:" + myHeader[2]);
        if (header[0] == myHeader[0] && header[1] == myHeader[1] && header[2] == myHeader[2]) {
            System.out.println("Return empty arraylist");
            return new ArrayList();
        }
        System.out.println("Start :" + start);
        if (start == -1) {
            return this.getStart(header[0], myHeader);
        }
        return this.getEvents(start, myHeader);
    }

    private ArrayList getEvents(int last, int[] myHeader) {
        ArrayList<ClusterEvent> events = new ArrayList<ClusterEvent>();
        try {
            RandomAccessFile raf = new RandomAccessFile(this.indexFile, "r");
            int pos = last;
            System.out.println("INITIAL POS = " + pos);
            if (last == myHeader[1]) {
                return null;
            }
            while (true) {
                raf.seek(12 + pos * 20 + 4);
                int start = raf.readInt();
                int end = raf.readInt();
                int file = raf.readInt();
                int count = raf.readInt();
                if (pos <= myHeader[1] && count == myHeader[2] || pos > myHeader[1] && count == myHeader[2] - 1) {
                    ClusterEvent event = this.readFromStorage(end, start, file);
                    events.add(event);
                    System.out.println("Add element " + event.getId());
                }
                if (events.size() >= REALIGN_MAX_BLOCK_SIZE || pos == myHeader[1]) break;
                int size = ((int)raf.length() - 12) / 20 - 1;
                if (++pos <= size) continue;
                pos = 0;
            }
            raf.close();
            return events.size() != 0 ? events : null;
        }
        catch (Exception e) {
            log.error((Object)("Error reading journal file ... " + e));
            throw new RuntimeException("Error rading journal file " + e);
        }
    }

    private synchronized ArrayList getStart(int last, int[] myHeader) {
        ArrayList events = new ArrayList();
        try {
            int pos = last < 0 ? 0 : last;
            int c = myHeader[2];
            int m = myHeader[1];
            RandomAccessFile raf = new RandomAccessFile(this.indexFile, "r");
            do {
                raf.seek(12 + pos * 20);
                int id = raf.readInt();
                int start = raf.readInt();
                int end = raf.readInt();
                int file = raf.readInt();
                int count = raf.readInt();
                if (pos < m && count == c || pos > m && count == c - 1) {
                    ClusterEvent event = this.readFromStorage(end, start, file);
                    events.add(0, event);
                    System.out.println("Add element " + event.getId());
                }
                if (events.size() >= REALIGN_MAX_BLOCK_SIZE) break;
                System.out.println("Pos : " + --pos);
                System.out.println("COUNER =  " + c);
            } while (!(pos >= 0 || c == 1 ? pos < 0 : (pos = ((int)raf.length() - 12) / 20 - 1) <= m) && pos != myHeader[1]);
            System.out.println("EXITING");
            raf.close();
            return events.size() != 0 ? events : this.getEvents(last < 0 ? 0 : last, myHeader);
        }
        catch (Exception e) {
            log.error((Object)("Error reading journal file ... " + e));
            throw new RuntimeException("Error reading journal file ", e);
        }
    }

    private class EventComparator
    implements Comparator {
        private EventComparator() {
        }

        public int compare(Object o, Object o1) {
            if (!(o instanceof ClusterEvent)) {
                return -1;
            }
            if (!(o1 instanceof ClusterEvent)) {
                return 1;
            }
            ClusterEvent ev = (ClusterEvent)o;
            ClusterEvent ev1 = (ClusterEvent)o1;
            int counter = ev.getCounter();
            int counter1 = ev1.getCounter();
            int id = ev.getId();
            int id1 = ev1.getId();
            if (counter == counter1) {
                return id - id1;
            }
            return counter - counter1;
        }
    }
}

