/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.Indexer;
import org.exist.collections.CollectionConfiguration;
import org.exist.collections.CollectionConfigurationException;
import org.exist.collections.CollectionConfigurationManager;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentMetadata;
import org.exist.dom.DocumentSet;
import org.exist.dom.QName;
import org.exist.security.Group;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.PermissionFactory;
import org.exist.security.SecurityManager;
import org.exist.security.User;
import org.exist.security.XMLSecurityManager;
import org.exist.storage.DBBroker;
import org.exist.storage.FulltextIndexSpec;
import org.exist.storage.GeneralRangeIndexSpec;
import org.exist.storage.IndexSpec;
import org.exist.storage.NodePath;
import org.exist.storage.QNameRangeIndexSpec;
import org.exist.storage.cache.Cacheable;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.storage.lock.Lock;
import org.exist.storage.lock.LockedDocumentMap;
import org.exist.storage.lock.ReentrantReadWriteLock;
import org.exist.storage.txn.Txn;
import org.exist.util.Configuration;
import org.exist.util.LockException;
import org.exist.util.MimeType;
import org.exist.util.SyntaxException;
import org.exist.util.XMLReaderObjectFactory;
import org.exist.util.hashtable.ObjectHashSet;
import org.exist.util.serializer.DOMStreamer;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Collection
extends Observable
implements Comparable,
Cacheable {
    public static int LENGTH_COLLECTION_ID = 4;
    private static final int SHALLOW_SIZE = 550;
    private static final int DOCUMENT_SIZE = 450;
    private static final Logger LOG = Logger.getLogger((Class)Collection.class);
    public static final int UNKNOWN_COLLECTION_ID = -1;
    private int collectionId = -1;
    private Map documents = new TreeMap();
    private XmldbURI path;
    private Permission permissions = PermissionFactory.getPermission(509);
    private ObjectHashSet subcollections = new ObjectHashSet(19);
    private long address = -1L;
    private long created = 0L;
    private Observer[] observers = null;
    private boolean collectionConfEnabled = true;
    private boolean triggersEnabled = true;
    private int refCount = 0;
    private int timestamp = 0;
    private Lock lock = null;
    private XMLReader userReader = null;
    private boolean isTempCollection = false;

    public Collection() {
    }

    public Collection(XmldbURI path) {
        this.setPath(path);
        this.lock = new ReentrantReadWriteLock(path);
    }

    public void setPath(XmldbURI path) {
        path = path.toCollectionPathURI();
        this.isTempCollection = path.getRawCollectionPath().equals("/db/system/temp");
        this.path = path;
    }

    public Lock getLock() {
        return this.lock;
    }

    public void addCollection(DBBroker broker, Collection child, boolean isNew) {
        CollectionConfiguration config;
        XmldbURI childName = child.getURI().lastSegment();
        if (!this.subcollections.contains(childName)) {
            this.subcollections.add(childName);
        }
        if (isNew && (config = this.getConfiguration(broker)) != null) {
            child.permissions.setPermissions(config.getDefCollPermissions());
        }
    }

    public boolean hasChildCollection(XmldbURI path) {
        return this.subcollections.contains(path);
    }

    public boolean isTempCollection() {
        return this.isTempCollection;
    }

    public void release(int mode) {
        this.getLock().release(mode);
    }

    public void update(Collection child) {
        XmldbURI childName = child.getURI().lastSegment();
        this.subcollections.remove(childName);
        this.subcollections.add(childName);
    }

    public void addDocument(Txn transaction, DBBroker broker, DocumentImpl doc) {
        if (doc.getDocId() == -1) {
            doc.setDocId(broker.getNextResourceId(transaction, this));
        }
        this.documents.put(doc.getFileURI().getRawCollectionPath(), doc);
    }

    public void unlinkDocument(DocumentImpl doc) {
        this.documents.remove(doc.getFileURI().getRawCollectionPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator collectionIterator() {
        try {
            this.getLock().acquire(0);
            Iterator iterator = this.subcollections.stableIterator();
            return iterator;
        }
        catch (LockException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            Iterator iterator = null;
            return iterator;
        }
        finally {
            this.getLock().release(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDescendants(DBBroker broker, User user) {
        ArrayList<Collection> cl = new ArrayList<Collection>(this.subcollections.size());
        try {
            this.getLock().acquire(0);
            Iterator i = this.subcollections.iterator();
            while (i.hasNext()) {
                XmldbURI childName = (XmldbURI)i.next();
                Collection child = broker.getCollection(this.path.append(childName));
                if (!this.permissions.validate(user, 4)) continue;
                cl.add(child);
                if (child.getChildCollectionCount() <= 0) continue;
                cl.addAll(child.getDescendants(broker, user));
            }
        }
        catch (LockException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.getLock().release(0);
        }
        return cl;
    }

    public DocumentSet allDocs(DBBroker broker, DocumentSet docs, boolean recursive, boolean checkPermissions) {
        return this.allDocs(broker, docs, recursive, checkPermissions, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentSet allDocs(DBBroker broker, DocumentSet docs, boolean recursive, boolean checkPermissions, LockedDocumentMap protectedDocs) {
        if (this.permissions.validate(broker.getUser(), 4)) {
            List subColls = null;
            try {
                this.getLock().acquire(0);
                this.getDocuments(broker, docs, checkPermissions);
                subColls = this.subcollections.keys();
            }
            catch (LockException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                this.getLock().release(0);
            }
            if (recursive && subColls != null) {
                for (int i = 0; i < subColls.size(); ++i) {
                    XmldbURI childName = (XmldbURI)subColls.get(i);
                    Collection child = broker.openCollection(this.path.appendInternal(childName), -1);
                    if (child == null) continue;
                    child.allDocs(broker, docs, recursive, checkPermissions, protectedDocs);
                }
            }
        }
        return docs;
    }

    public DocumentSet allDocs(DBBroker broker, DocumentSet docs, boolean recursive, LockedDocumentMap lockMap, int lockType) throws LockException {
        if (this.permissions.validate(broker.getUser(), 4)) {
            int i;
            List subColls = null;
            XmldbURI[] uris = null;
            try {
                this.getLock().acquire(0);
                this.getDocuments(broker, docs, lockMap, lockType);
                subColls = this.subcollections.keys();
                if (subColls != null) {
                    uris = new XmldbURI[subColls.size()];
                    for (i = 0; i < subColls.size(); ++i) {
                        XmldbURI childName = (XmldbURI)subColls.get(i);
                        uris[i] = this.path.appendInternal(childName);
                    }
                }
            }
            catch (LockException e) {
                LOG.warn((Object)e.getMessage());
                throw e;
            }
            finally {
                this.getLock().release(0);
            }
            if (recursive && uris != null) {
                for (i = 0; i < uris.length; ++i) {
                    Collection child = broker.openCollection(uris[i], -1);
                    if (child == null) continue;
                    child.allDocs(broker, docs, recursive, lockMap, lockType);
                }
            }
        }
        return docs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentSet getDocuments(DBBroker broker, DocumentSet docs, boolean checkPermissions) {
        try {
            this.getLock().acquire(0);
            docs.addCollection(this);
            docs.addAll(broker, this, this.getDocumentPaths(), checkPermissions);
        }
        catch (LockException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.getLock().release(0);
        }
        return docs;
    }

    public DocumentSet getDocuments(DBBroker broker, DocumentSet docs, LockedDocumentMap lockMap, int lockType) throws LockException {
        try {
            this.getLock().acquire(0);
            docs.addCollection(this);
            docs.addAll(broker, this, this.getDocumentPaths(), lockMap, lockType);
        }
        catch (LockException e) {
            throw e;
        }
        finally {
            this.getLock().release(0);
        }
        return docs;
    }

    private String[] getDocumentPaths() {
        String[] paths = new String[this.documents.size()];
        int i = 0;
        Iterator iter = this.documents.keySet().iterator();
        while (iter.hasNext()) {
            paths[i] = (String)iter.next();
            ++i;
        }
        return paths;
    }

    public boolean allowUnload() {
        Iterator i = this.documents.values().iterator();
        while (i.hasNext()) {
            DocumentImpl doc = (DocumentImpl)i.next();
            if (!doc.isLockedForWrite()) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object obj) {
        Collection other = (Collection)obj;
        if (this.collectionId == other.collectionId) {
            return 0;
        }
        if (this.collectionId < other.collectionId) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Collection)) {
            return false;
        }
        return ((Collection)obj).collectionId == this.collectionId;
    }

    public int getMemorySize() {
        return 550 + this.documents.size() * 450;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildCollectionCount() {
        try {
            this.getLock().acquire(0);
            int n = this.subcollections.size();
            return n;
        }
        catch (LockException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            this.getLock().release(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentImpl getDocument(DBBroker broker, XmldbURI path) {
        try {
            this.getLock().acquire(0);
            DocumentImpl doc = (DocumentImpl)this.documents.get(path.getRawCollectionPath());
            if (doc == null) {
                LOG.debug((Object)("Document " + path + " not found!"));
            }
            DocumentImpl documentImpl = doc;
            return documentImpl;
        }
        catch (LockException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            DocumentImpl documentImpl = null;
            return documentImpl;
        }
        finally {
            this.getLock().release(0);
        }
    }

    public DocumentImpl getDocumentWithLock(DBBroker broker, XmldbURI name) throws LockException {
        return this.getDocumentWithLock(broker, name, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentImpl getDocumentWithLock(DBBroker broker, XmldbURI uri, int lockMode) throws LockException {
        try {
            this.getLock().acquire(0);
            DocumentImpl doc = (DocumentImpl)this.documents.get(uri.getRawCollectionPath());
            if (doc != null) {
                doc.getUpdateLock().acquire(lockMode);
            }
            DocumentImpl documentImpl = doc;
            return documentImpl;
        }
        finally {
            this.getLock().release(0);
        }
    }

    public DocumentImpl getDocumentNoLock(String rawPath) {
        return (DocumentImpl)this.documents.get(rawPath);
    }

    public void releaseDocument(DocumentImpl doc) {
        if (doc != null) {
            doc.getUpdateLock().release(0);
        }
    }

    public void releaseDocument(DocumentImpl doc, int mode) {
        if (doc != null) {
            doc.getUpdateLock().release(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDocumentCount() {
        try {
            this.getLock().acquire(0);
            int n = this.documents.size();
            return n;
        }
        catch (LockException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            this.getLock().release(0);
        }
    }

    public int getId() {
        return this.collectionId;
    }

    public XmldbURI getURI() {
        return this.path;
    }

    public XmldbURI getParentURI() {
        if (this.path.equals(XmldbURI.ROOT_COLLECTION_URI)) {
            return null;
        }
        return this.path.removeLastSegment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Permission getPermissions() {
        try {
            this.getLock().acquire(0);
            Permission permission = this.permissions;
            return permission;
        }
        catch (LockException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            Permission permission = this.permissions;
            return permission;
        }
        finally {
            this.getLock().release(0);
        }
    }

    public Permission getPermissionsNoLock() {
        return this.permissions;
    }

    public boolean hasDocument(XmldbURI uri) {
        return this.documents.containsKey(uri.getRawCollectionPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSubcollection(XmldbURI name) {
        try {
            this.getLock().acquire(0);
            boolean bl = this.subcollections.contains(name);
            return bl;
        }
        catch (LockException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            boolean bl = this.subcollections.contains(name);
            return bl;
        }
        finally {
            this.getLock().release(0);
        }
    }

    public boolean hasSubcollectionNoLock(XmldbURI name) {
        return this.subcollections.contains(name);
    }

    public Iterator iterator(DBBroker broker) {
        return this.getDocuments(broker, new DocumentSet(), false).iterator();
    }

    public void read(DBBroker broker, VariableByteInput istream) throws IOException {
        this.collectionId = istream.readInt();
        int collLen = istream.readInt();
        this.subcollections = new ObjectHashSet(collLen == 0 ? 19 : collLen);
        for (int i = 0; i < collLen; ++i) {
            this.subcollections.add(XmldbURI.create(istream.readUTF()));
        }
        int uid = istream.readInt();
        int gid = istream.readInt();
        int perm = istream.readInt();
        this.created = istream.readLong();
        SecurityManager secman = broker.getBrokerPool().getSecurityManager();
        if (secman == null) {
            this.permissions.setOwner("admin");
            this.permissions.setGroup("dba");
        } else {
            this.permissions.setOwner(secman.getUser(uid));
            Group group = secman.getGroup(gid);
            if (group != null) {
                this.permissions.setGroup(group.getName());
            }
        }
        this.permissions.setPermissions(perm & 0x1FF);
        broker.getCollectionResources(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCollection(XmldbURI name) throws LockException {
        try {
            this.getLock().acquire(1);
            this.subcollections.remove(name);
        }
        finally {
            this.getLock().release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeXMLResource(Txn transaction, DBBroker broker, XmldbURI docUri) throws PermissionDeniedException, TriggerException, LockException {
        DocumentImpl doc = null;
        try {
            this.getLock().acquire(0);
            doc = (DocumentImpl)this.documents.get(docUri.getRawCollectionPath());
            if (doc == null) {
                return;
            }
            doc.getUpdateLock().acquire(1);
            if (!this.getPermissions().validate(broker.getUser(), 2)) {
                throw new PermissionDeniedException("Write access to collection denied; user=" + broker.getUser().getName());
            }
            if (!doc.getPermissions().validate(broker.getUser(), 2)) {
                throw new PermissionDeniedException("Permission to remove document denied");
            }
            DocumentTrigger trigger = null;
            if (!CollectionConfiguration.DEFAULT_COLLECTION_CONFIG_FILE_URI.equals(docUri)) {
                CollectionConfiguration config;
                if (this.triggersEnabled && (config = this.getConfiguration(broker)) != null) {
                    try {
                        trigger = (DocumentTrigger)config.newTrigger(2, broker, this);
                    }
                    catch (CollectionConfigurationException e) {
                        LOG.debug((Object)("An error occurred while initializing a trigger for collection " + this.getURI() + ": " + e.getMessage()), (Throwable)e);
                    }
                }
            } else {
                CollectionConfigurationManager confMgr = broker.getBrokerPool().getConfigurationManager();
                confMgr.invalidateAll(this.getURI());
            }
            if (trigger != null) {
                trigger.prepare(2, broker, transaction, this.getURI().append(docUri), doc);
            }
            broker.removeXMLResource(transaction, doc);
            this.documents.remove(docUri.getRawCollectionPath());
            if (trigger != null) {
                trigger.finish(2, broker, transaction, this.getURI().append(docUri), null);
            }
            broker.getBrokerPool().getNotificationService().notifyUpdate(doc, 2);
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            this.getLock().release(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBinaryResource(Txn transaction, DBBroker broker, XmldbURI uri) throws PermissionDeniedException, LockException, TriggerException {
        try {
            this.getLock().acquire(1);
            DocumentImpl doc = this.getDocument(broker, uri);
            if (doc.isLockedForWrite()) {
                throw new PermissionDeniedException("Document " + doc.getFileURI() + " is locked for write");
            }
            if (!this.getPermissions().validate(broker.getUser(), 2)) {
                throw new PermissionDeniedException("write access to collection denied; user=" + broker.getUser().getName());
            }
            if (!doc.getPermissions().validate(broker.getUser(), 2)) {
                throw new PermissionDeniedException("permission to remove document denied");
            }
            this.removeBinaryResource(transaction, broker, doc);
        }
        finally {
            this.getLock().release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBinaryResource(Txn transaction, DBBroker broker, DocumentImpl doc) throws PermissionDeniedException, LockException, TriggerException {
        if (doc == null) {
            return;
        }
        try {
            CollectionConfiguration config;
            this.getLock().acquire(1);
            if (doc.getResourceType() != 1) {
                throw new PermissionDeniedException("document " + doc.getFileURI() + " is not a binary object");
            }
            if (doc.isLockedForWrite()) {
                throw new PermissionDeniedException("Document " + doc.getFileURI() + " is locked for write");
            }
            if (!this.getPermissions().validate(broker.getUser(), 2)) {
                throw new PermissionDeniedException("write access to collection denied; user=" + broker.getUser().getName());
            }
            if (!doc.getPermissions().validate(broker.getUser(), 2)) {
                throw new PermissionDeniedException("permission to remove document denied");
            }
            DocumentTrigger trigger = null;
            if (this.triggersEnabled && (config = this.getConfiguration(broker)) != null) {
                try {
                    trigger = (DocumentTrigger)config.newTrigger(2, broker, this);
                }
                catch (CollectionConfigurationException e) {
                    LOG.debug((Object)("An error occurred while initializing a trigger for collection " + this.getURI() + ": " + e.getMessage()), (Throwable)e);
                }
            }
            if (trigger != null) {
                trigger.prepare(2, broker, transaction, doc.getURI(), doc);
            }
            broker.removeBinaryResource(transaction, (BinaryDocument)doc);
            this.documents.remove(doc.getFileURI().getRawCollectionPath());
            if (trigger != null) {
                trigger.finish(2, broker, transaction, doc.getURI(), null);
            }
        }
        finally {
            this.getLock().release(1);
        }
    }

    public void store(Txn transaction, final DBBroker broker, final IndexInfo info, final InputSource source, boolean privileged) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException {
        this.storeXMLInternal(transaction, broker, info, privileged, new StoreBlock(){

            public void run() throws EXistException, SAXException {
                try {
                    InputStream is = source.getByteStream();
                    if (is != null) {
                        is.reset();
                    } else {
                        Reader cs = source.getCharacterStream();
                        if (cs != null) {
                            cs.reset();
                        }
                    }
                }
                catch (IOException e) {
                    LOG.debug((Object)"could not reset input source", (Throwable)e);
                }
                XMLReader reader = Collection.this.getReader(broker, info.getCollectionConfig());
                info.setReader(reader, null);
                try {
                    reader.parse(source);
                }
                catch (IOException e) {
                    throw new EXistException(e);
                }
                finally {
                    Collection.this.releaseReader(broker, reader);
                }
            }
        });
    }

    public void store(Txn transaction, final DBBroker broker, final IndexInfo info, final String data, boolean privileged) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException {
        this.storeXMLInternal(transaction, broker, info, privileged, new StoreBlock(){

            public void run() throws SAXException, EXistException {
                CollectionConfiguration colconf = info.getDocument().getCollection().getConfiguration(broker);
                XMLReader reader = Collection.this.getReader(broker, colconf);
                info.setReader(reader, null);
                try {
                    reader.parse(new InputSource(new StringReader(data)));
                }
                catch (IOException e) {
                    throw new EXistException(e);
                }
                finally {
                    Collection.this.releaseReader(broker, reader);
                }
            }
        });
    }

    public void store(Txn transaction, DBBroker broker, final IndexInfo info, final Node node, boolean privileged) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException {
        this.storeXMLInternal(transaction, broker, info, privileged, new StoreBlock(){

            public void run() throws EXistException, SAXException {
                info.getDOMStreamer().serialize(node, true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeXMLInternal(Txn transaction, DBBroker broker, IndexInfo info, boolean privileged, StoreBlock doParse) throws EXistException, SAXException {
        DocumentImpl document = info.getIndexer().getDocument();
        LOG.debug((Object)("storing document " + document.getDocId() + " ..."));
        if (!document.getUpdateLock().isLockedForWrite()) {
            LOG.warn((Object)"document is not locked for write !");
        }
        try {
            doParse.run();
            broker.storeXMLResource(transaction, document);
            broker.flush();
            broker.closeDocument();
            LOG.debug((Object)"document stored.");
            if (this.getURI().equals(XmldbURI.SYSTEM_COLLECTION_URI) && document.getFileURI().equals(XMLSecurityManager.ACL_FILE_URI) && !privileged) {
                LOG.debug((Object)"users.xml changed");
                broker.getBrokerPool().reloadSecurityManager(broker);
            }
        }
        finally {
            document.getUpdateLock().release(1);
        }
        this.collectionConfEnabled = true;
        broker.deleteObservers();
        info.finishTrigger(broker, transaction, document.getURI(), document);
        broker.getBrokerPool().getNotificationService().notifyUpdate(document, info.getEvent() == 1 ? 1 : 0);
        XmldbURI docName = document.getFileURI();
        if (this.getURI().startsWith(XmldbURI.CONFIG_COLLECTION_URI) && docName.endsWith(CollectionConfiguration.COLLECTION_CONFIG_SUFFIX_URI)) {
            broker.sync(1);
            CollectionConfigurationManager manager = broker.getBrokerPool().getConfigurationManager();
            if (manager != null) {
                try {
                    manager.invalidateAll(this.getURI());
                    manager.loadConfiguration(broker, this);
                }
                catch (CollectionConfigurationException e) {
                    throw new EXistException("Error while reading new collection configuration: " + e.getMessage(), e);
                }
            }
        }
    }

    public IndexInfo validateXMLResource(Txn transaction, DBBroker broker, XmldbURI docUri, String data) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException, IOException {
        return this.validateXMLResource(transaction, broker, docUri, new InputSource(new StringReader(data)));
    }

    public IndexInfo validateXMLResource(Txn transaction, final DBBroker broker, XmldbURI docUri, final InputSource source) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException, IOException {
        final CollectionConfiguration colconf = this.getConfiguration(broker);
        return this.validateXMLResourceInternal(transaction, broker, docUri, colconf, new ValidateBlock(){

            public void run(IndexInfo info) throws SAXException, EXistException {
                XMLReader reader = Collection.this.getReader(broker, colconf);
                info.setReader(reader, null);
                try {
                    reader.parse(source);
                }
                catch (IOException e) {
                    throw new EXistException(e);
                }
                finally {
                    Collection.this.releaseReader(broker, reader);
                }
            }
        });
    }

    public IndexInfo validateXMLResource(Txn transaction, DBBroker broker, XmldbURI docUri, final Node node) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException, IOException {
        return this.validateXMLResourceInternal(transaction, broker, docUri, this.getConfiguration(broker), new ValidateBlock(){

            public void run(IndexInfo info) throws SAXException {
                info.setDOMStreamer(new DOMStreamer());
                info.getDOMStreamer().serialize(node, true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexInfo validateXMLResourceInternal(Txn transaction, DBBroker broker, XmldbURI docUri, CollectionConfiguration config, ValidateBlock doValidate) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException, IOException {
        this.checkConfigurationDocument(transaction, broker, docUri);
        if (broker.isReadOnly()) {
            throw new PermissionDeniedException("Database is read-only");
        }
        DocumentImpl oldDoc = null;
        boolean oldDocLocked = false;
        try {
            this.getLock().acquire(1);
            DocumentImpl document = new DocumentImpl(broker, this, docUri);
            oldDoc = (DocumentImpl)this.documents.get(docUri.getRawCollectionPath());
            if (oldDoc == null) {
                if (config != null) {
                    document.setPermissions(config.getDefResPermissions());
                }
            } else {
                document.setPermissions(oldDoc.getPermissions().getPermissions());
            }
            this.checkPermissions(transaction, broker, oldDoc);
            this.manageDocumentInformation(broker, oldDoc, document);
            Indexer indexer = new Indexer(broker, transaction);
            IndexInfo info = new IndexInfo(indexer, config);
            indexer.setDocument(document, config);
            this.addObserversToIndexer(broker, indexer);
            indexer.setValidating(true);
            info.setTrigger(this.setupTriggers(broker, docUri, oldDoc != null, config), oldDoc == null ? 0 : 1);
            info.prepareTrigger(broker, transaction, this.getURI().append(docUri), oldDoc);
            LOG.debug((Object)("Scanning document " + this.getURI().append(docUri)));
            doValidate.run(info);
            if (oldDoc != null) {
                LOG.debug((Object)("removing old document " + oldDoc.getFileURI()));
                oldDoc.getUpdateLock().acquire(1);
                oldDocLocked = true;
                if (oldDoc.getResourceType() == 1) {
                    broker.removeBinaryResource(transaction, (BinaryDocument)oldDoc);
                    this.documents.remove(oldDoc.getFileURI().getRawCollectionPath());
                    document.getUpdateLock().acquire(1);
                    document.setDocId(broker.getNextResourceId(transaction, this));
                    this.addDocument(transaction, broker, document);
                } else {
                    broker.removeXMLResource(transaction, oldDoc, false);
                    oldDoc.copyOf(document);
                    indexer.setDocumentObject(oldDoc);
                    document = oldDoc;
                    oldDocLocked = false;
                }
                LOG.debug((Object)("removed old document " + oldDoc.getFileURI()));
            } else {
                document.getUpdateLock().acquire(1);
                document.setDocId(broker.getNextResourceId(transaction, this));
                this.addDocument(transaction, broker, document);
            }
            indexer.setValidating(false);
            info.postValidateTrigger();
            IndexInfo indexInfo = info;
            return indexInfo;
        }
        finally {
            if (oldDocLocked) {
                oldDoc.getUpdateLock().release(1);
            }
            this.getLock().release(1);
        }
    }

    private void checkConfigurationDocument(Txn transaction, DBBroker broker, XmldbURI docUri) throws EXistException, PermissionDeniedException, IOException {
        if (!this.getURI().startsWith(XmldbURI.CONFIG_COLLECTION_URI)) {
            return;
        }
        if (!docUri.endsWith(CollectionConfiguration.COLLECTION_CONFIG_SUFFIX_URI)) {
            return;
        }
        Iterator i = this.iterator(broker);
        while (i.hasNext()) {
            DocumentImpl confDoc = (DocumentImpl)i.next();
            XmldbURI currentConfDocName = confDoc.getFileURI();
            if (currentConfDocName == null || currentConfDocName.equals(docUri)) continue;
            throw new EXistException("Could not store configuration '" + docUri + "': A configuration document with a different name (" + currentConfDocName + ") already exists in this collection (" + this.getURI() + ")");
        }
    }

    private void addObserversToIndexer(DBBroker broker, Indexer indexer) {
        broker.deleteObservers();
        if (this.observers != null) {
            for (int i = 0; i < this.observers.length; ++i) {
                indexer.addObserver(this.observers[i]);
                broker.addObserver(this.observers[i]);
            }
        }
    }

    private void manageDocumentInformation(DBBroker broker, DocumentImpl oldDoc, DocumentImpl document) {
        DocumentMetadata metadata = new DocumentMetadata();
        if (oldDoc != null) {
            metadata = oldDoc.getMetadata();
            metadata.setCreated(oldDoc.getMetadata().getCreated());
            metadata.setLastModified(System.currentTimeMillis());
            document.setPermissions(oldDoc.getPermissions());
        } else {
            metadata.setCreated(System.currentTimeMillis());
            document.getPermissions().setOwner(broker.getUser());
            document.getPermissions().setGroup(broker.getUser().getPrimaryGroup());
        }
        document.setMetadata(metadata);
    }

    private void checkPermissions(Txn transaction, DBBroker broker, DocumentImpl oldDoc) throws LockException, PermissionDeniedException {
        if (oldDoc != null) {
            LOG.debug((Object)("Found old doc " + oldDoc.getDocId()));
            User lockUser = oldDoc.getUserLock();
            if (lockUser != null && !lockUser.equals(broker.getUser())) {
                throw new PermissionDeniedException("The document is locked by user " + lockUser.getName());
            }
            if (!oldDoc.getPermissions().validate(broker.getUser(), 1)) {
                throw new PermissionDeniedException("Document exists and update is not allowed");
            }
            if (!this.getPermissions().validate(broker.getUser(), 1) && !this.getPermissions().validate(broker.getUser(), 2)) {
                throw new PermissionDeniedException("Document exists and update is not allowed for the collection");
            }
        } else if (!this.getPermissions().validate(broker.getUser(), 2)) {
            throw new PermissionDeniedException("User '" + broker.getUser().getName() + "' not allowed to write to collection '" + this.getURI() + "'");
        }
    }

    private DocumentTrigger setupTriggers(DBBroker broker, XmldbURI docUri, boolean update, CollectionConfiguration config) {
        if (CollectionConfiguration.DEFAULT_COLLECTION_CONFIG_FILE_URI.equals(docUri)) {
            this.collectionConfEnabled = false;
            return null;
        }
        if (!this.triggersEnabled) {
            return null;
        }
        if (config == null) {
            return null;
        }
        DocumentTrigger trigger = null;
        try {
            trigger = update ? (DocumentTrigger)config.newTrigger(1, broker, this) : (DocumentTrigger)config.newTrigger(0, broker, this);
        }
        catch (CollectionConfigurationException e) {
            LOG.debug((Object)("An error occurred while initializing a trigger for collection " + this.getURI() + ": " + e.getMessage()), (Throwable)e);
        }
        if (trigger == null) {
            return null;
        }
        if (update) {
            LOG.debug((Object)("Using update trigger '" + trigger.getClass().getName() + "'"));
        } else {
            LOG.debug((Object)("Using store trigger '" + trigger.getClass().getName() + "'"));
        }
        return trigger;
    }

    public BinaryDocument addBinaryResource(Txn transaction, DBBroker broker, XmldbURI docUri, byte[] data, String mimeType) throws EXistException, PermissionDeniedException, LockException, TriggerException {
        return this.addBinaryResource(transaction, broker, docUri, data, mimeType, null, null);
    }

    public BinaryDocument addBinaryResource(Txn transaction, DBBroker broker, XmldbURI docUri, byte[] data, String mimeType, Date created, Date modified) throws EXistException, PermissionDeniedException, LockException, TriggerException {
        return this.addBinaryResource(transaction, broker, docUri, new ByteArrayInputStream(data), mimeType, data.length, created, modified);
    }

    public BinaryDocument addBinaryResource(Txn transaction, DBBroker broker, XmldbURI docUri, InputStream is, String mimeType, int size) throws EXistException, PermissionDeniedException, LockException, TriggerException {
        return this.addBinaryResource(transaction, broker, docUri, is, mimeType, size, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryDocument addBinaryResource(Txn transaction, DBBroker broker, XmldbURI docUri, InputStream is, String mimeType, int size, Date created, Date modified) throws EXistException, PermissionDeniedException, LockException, TriggerException {
        if (broker.isReadOnly()) {
            throw new PermissionDeniedException("Database is read-only");
        }
        BinaryDocument blob = new BinaryDocument(broker, this, docUri);
        DocumentImpl oldDoc = this.getDocument(broker, docUri);
        try {
            CollectionConfiguration config;
            this.getLock().acquire(1);
            this.checkPermissions(transaction, broker, oldDoc);
            DocumentTrigger trigger = null;
            int event = 0;
            if (this.triggersEnabled && (config = this.getConfiguration(broker)) != null) {
                event = oldDoc != null ? 1 : 0;
                try {
                    trigger = (DocumentTrigger)config.newTrigger(event, broker, this);
                }
                catch (CollectionConfigurationException e) {
                    LOG.debug((Object)("An error occurred while initializing a trigger for collection " + this.getURI() + ": " + e.getMessage()), (Throwable)e);
                }
                if (trigger != null) {
                    trigger.prepare(event, broker, transaction, blob.getURI(), blob);
                }
            }
            this.manageDocumentInformation(broker, oldDoc, blob);
            DocumentMetadata metadata = blob.getMetadata();
            metadata.setMimeType(mimeType == null ? MimeType.BINARY_TYPE.getName() : mimeType);
            if (oldDoc != null) {
                LOG.debug((Object)("removing old document " + oldDoc.getFileURI()));
                if (oldDoc instanceof BinaryDocument) {
                    broker.removeBinaryResource(transaction, (BinaryDocument)oldDoc);
                } else {
                    broker.removeXMLResource(transaction, oldDoc);
                }
            }
            if (created != null) {
                metadata.setCreated(created.getTime());
            }
            if (modified != null) {
                metadata.setLastModified(modified.getTime());
            }
            blob.setContentLength(size);
            broker.storeBinaryResource(transaction, blob, is);
            this.addDocument(transaction, broker, blob);
            broker.storeXMLResource(transaction, blob);
            broker.closeDocument();
            if (trigger != null) {
                trigger.finish(event, broker, transaction, blob.getURI(), blob);
            }
            BinaryDocument binaryDocument = blob;
            return binaryDocument;
        }
        finally {
            this.getLock().release(1);
        }
    }

    public void setId(int id) {
        this.collectionId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermissions(int mode) throws LockException {
        try {
            this.getLock().acquire(1);
            this.permissions.setPermissions(mode);
        }
        finally {
            this.getLock().release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermissions(String mode) throws SyntaxException, LockException {
        try {
            this.getLock().acquire(1);
            this.permissions.setPermissions(mode);
        }
        finally {
            this.getLock().release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermissions(Permission permissions) throws LockException {
        try {
            this.getLock().acquire(1);
            this.permissions = permissions;
        }
        finally {
            this.getLock().release(1);
        }
    }

    public void write(DBBroker broker, VariableByteOutputStream ostream) throws IOException {
        ostream.writeInt(this.collectionId);
        ostream.writeInt(this.subcollections.size());
        Iterator i = this.subcollections.iterator();
        while (i.hasNext()) {
            XmldbURI childColl = (XmldbURI)i.next();
            ostream.writeUTF(childColl.toString());
        }
        SecurityManager secman = broker.getBrokerPool().getSecurityManager();
        if (secman == null) {
            ostream.writeInt(1);
            ostream.writeInt(1);
        } else {
            User user = secman.getUser(this.permissions.getOwner());
            Group group = secman.getGroup(this.permissions.getOwnerGroup());
            if (user == null) {
                throw new IllegalStateException("The user " + this.permissions.getOwner() + " for the collection cannot be found.");
            }
            if (group == null) {
                group = secman.getGroup("guest");
            }
            ostream.writeInt(user.getUID());
            ostream.writeInt(group.getId());
        }
        ostream.writeInt(this.permissions.getPermissions());
        ostream.writeLong(this.created);
    }

    public CollectionConfiguration getConfiguration(DBBroker broker) {
        if (!this.collectionConfEnabled) {
            return null;
        }
        if ("/db/system".equals(this.getURI().getRawCollectionPath())) {
            return null;
        }
        CollectionConfigurationManager manager = broker.getBrokerPool().getConfigurationManager();
        if (manager == null) {
            return null;
        }
        CollectionConfiguration configuration = null;
        this.collectionConfEnabled = false;
        try {
            configuration = manager.getConfiguration(broker, this);
            this.collectionConfEnabled = true;
        }
        catch (CollectionConfigurationException e) {
            LOG.warn((Object)("Failed to load collection configuration for '" + this.getURI() + "'"), (Throwable)e);
        }
        return configuration;
    }

    public void setConfigEnabled(boolean enabled) {
        this.collectionConfEnabled = enabled;
    }

    public void setAddress(long addr) {
        this.address = addr;
    }

    public long getAddress() {
        return this.address;
    }

    public void setCreationTime(long ms) {
        this.created = ms;
    }

    public long getCreationTime() {
        return this.created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTriggersEnabled(boolean enabled) {
        try {
            this.getLock().acquire(1);
            this.triggersEnabled = enabled;
        }
        catch (LockException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            this.triggersEnabled = enabled;
        }
        finally {
            this.getLock().release(1);
        }
    }

    public void setReader(XMLReader reader) {
        this.userReader = reader;
    }

    private XMLReader getReader(DBBroker broker, CollectionConfiguration colconfig) throws EXistException, SAXException {
        if (this.userReader != null) {
            return this.userReader;
        }
        XMLReader reader = broker.getBrokerPool().getParserPool().borrowXMLReader();
        if (colconfig != null) {
            int mode = colconfig.getValidationMode();
            XMLReaderObjectFactory.setReaderValidationMode(mode, reader);
        }
        return reader;
    }

    private void releaseReader(DBBroker broker, XMLReader reader) {
        if (this.userReader != null) {
            return;
        }
        Configuration config = broker.getConfiguration();
        String optionValue = (String)config.getProperty("validation.mode");
        int validationMode = XMLReaderObjectFactory.convertValidationMode(optionValue);
        XMLReaderObjectFactory.setReaderValidationMode(validationMode, reader);
        broker.getBrokerPool().getParserPool().returnXMLReader(reader);
    }

    public void addObserver(Observer o) {
        if (this.hasObserver(o)) {
            return;
        }
        if (this.observers == null) {
            this.observers = new Observer[1];
            this.observers[0] = o;
        } else {
            Observer[] n = new Observer[this.observers.length + 1];
            System.arraycopy(this.observers, 0, n, 0, this.observers.length);
            n[this.observers.length] = o;
            this.observers = n;
        }
    }

    private boolean hasObserver(Observer o) {
        if (this.observers == null) {
            return false;
        }
        for (int i = 0; i < this.observers.length; ++i) {
            if (this.observers[i] != o) continue;
            return true;
        }
        return false;
    }

    public void deleteObservers() {
        if (this.observers != null) {
            this.observers = null;
        }
    }

    public long getKey() {
        return this.collectionId;
    }

    public int getReferenceCount() {
        return this.refCount;
    }

    public int incReferenceCount() {
        return ++this.refCount;
    }

    public int decReferenceCount() {
        return this.refCount > 0 ? (this.refCount = this.refCount - 1) : 0;
    }

    public void setReferenceCount(int count) {
        this.refCount = count;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public boolean sync(boolean syncJournal) {
        return false;
    }

    public boolean isDirty() {
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getURI());
        buf.append("[");
        Iterator i = this.documents.keySet().iterator();
        while (i.hasNext()) {
            buf.append(i.next());
            if (!i.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public IndexSpec getIndexConfiguration(DBBroker broker) {
        CollectionConfiguration conf = this.getConfiguration(broker);
        if (conf == null) {
            return broker.getIndexConfiguration();
        }
        return conf.getIndexConfiguration();
    }

    public GeneralRangeIndexSpec getIndexByPathConfiguration(DBBroker broker, NodePath path) {
        IndexSpec idxSpec = this.getIndexConfiguration(broker);
        return idxSpec == null ? null : idxSpec.getIndexByPath(path);
    }

    public QNameRangeIndexSpec getIndexByQNameConfiguration(DBBroker broker, QName qname) {
        IndexSpec idxSpec = this.getIndexConfiguration(broker);
        return idxSpec == null ? null : idxSpec.getIndexByQName(qname);
    }

    public FulltextIndexSpec getFulltextIndexConfiguration(DBBroker broker) {
        IndexSpec idxSpec = this.getIndexConfiguration(broker);
        return idxSpec == null ? null : idxSpec.getFulltextIndexSpec();
    }

    private static interface ValidateBlock {
        public void run(IndexInfo var1) throws SAXException, EXistException;
    }

    private static interface StoreBlock {
        public void run() throws EXistException, SAXException;
    }
}

