/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections.triggers;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.exist.collections.Collection;
import org.exist.collections.CollectionConfigurationException;
import org.exist.collections.triggers.FilteringTrigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.collections.triggers.TriggerStatePerThread;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.dom.NodeSet;
import org.exist.memtree.SAXAdapter;
import org.exist.security.xacml.AccessContext;
import org.exist.source.Source;
import org.exist.source.SourceFactory;
import org.exist.source.StringSource;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Base64Binary;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XQueryTrigger
extends FilteringTrigger {
    private static final String EVENT_TYPE_PREPARE = "prepare";
    private static final String EVENT_TYPE_FINISH = "finish";
    private static final String DEFAULT_BINDING_PREFIX = "local:";
    private SAXAdapter adapter;
    private Collection collection = null;
    private String strQuery = null;
    private String urlQuery = null;
    private Properties userDefinedVariables = new Properties();
    private String bindingPrefix = null;
    private XQuery service;
    private ContentHandler originalOutputHandler;

    public XQueryTrigger() {
        this.adapter = new SAXAdapter();
    }

    public void configure(DBBroker broker, Collection parent, Map parameters) throws CollectionConfigurationException {
        this.collection = parent;
        if (parameters != null) {
            this.urlQuery = (String)parameters.get("url");
            this.strQuery = (String)parameters.get("query");
            Iterator itParamName = parameters.keySet().iterator();
            while (itParamName.hasNext()) {
                String paramName = (String)itParamName.next();
                if (paramName.equals("bindingPrefix")) {
                    String bindingPrefix = (String)parameters.get("bindingPrefix");
                    if (bindingPrefix == null || "".equals(bindingPrefix.trim())) continue;
                    this.bindingPrefix = bindingPrefix.trim() + ":";
                    continue;
                }
                if (paramName.equals("url")) {
                    this.urlQuery = (String)parameters.get("url");
                    continue;
                }
                if (paramName.equals("query")) {
                    this.strQuery = (String)parameters.get("query");
                    continue;
                }
                this.userDefinedVariables.put(paramName, parameters.get(paramName));
            }
            if (this.bindingPrefix == null) {
                this.bindingPrefix = DEFAULT_BINDING_PREFIX;
            }
            if (this.urlQuery != null || this.strQuery != null) {
                this.service = broker.getXQueryService();
                return;
            }
        }
        this.LOG.error((Object)("XQuery Trigger for: '" + parent.getURI() + "' is missing its XQuery parameter"));
    }

    private Source getQuerySource(DBBroker broker) {
        Source querySource = null;
        if (this.urlQuery != null) {
            try {
                querySource = SourceFactory.getSource(broker, null, this.urlQuery, false);
            }
            catch (Exception e) {
                this.LOG.error((Object)e);
            }
        } else if (this.strQuery != null) {
            querySource = new StringSource(this.strQuery);
        }
        return querySource;
    }

    public void prepare(int event, DBBroker broker, Txn transaction, XmldbURI documentPath, DocumentImpl existingDocument) throws TriggerException {
        CompiledXQuery compiledQuery;
        this.LOG.debug((Object)("Preparing " + XQueryTrigger.eventToString(event) + "XQuery trigger for document: '" + documentPath + "'"));
        Source query = this.getQuerySource(broker);
        if (query == null) {
            return;
        }
        if (!TriggerStatePerThread.verifyUniqueTriggerPerThreadBeforePrepare(this, documentPath)) {
            return;
        }
        TriggerStatePerThread.setTransaction(transaction);
        XQueryContext context = this.service.newContext(AccessContext.TRIGGER);
        try {
            compiledQuery = this.service.compile(context, query);
            context.declareVariable(this.bindingPrefix + "eventType", EVENT_TYPE_PREPARE);
            context.declareVariable(this.bindingPrefix + "collectionName", new AnyURIValue(this.collection.getURI()));
            context.declareVariable(this.bindingPrefix + "documentName", new AnyURIValue(documentPath));
            context.declareVariable(this.bindingPrefix + "triggerEvent", new StringValue(XQueryTrigger.eventToString(event)));
            Iterator<Object> itUserVarName = this.userDefinedVariables.keySet().iterator();
            while (itUserVarName.hasNext()) {
                String varName = (String)itUserVarName.next();
                String varValue = this.userDefinedVariables.getProperty(varName);
                context.declareVariable(this.bindingPrefix + varName, new StringValue(varValue));
            }
            if (existingDocument == null) {
                context.declareVariable(this.bindingPrefix + "document", Sequence.EMPTY_SEQUENCE);
            } else if (existingDocument instanceof BinaryDocument) {
                BinaryDocument bin = (BinaryDocument)existingDocument;
                byte[] data = context.getBroker().getBinaryResource(bin);
                context.declareVariable(this.bindingPrefix + "document", new Base64Binary(data));
            } else {
                context.declareVariable(this.bindingPrefix + "document", existingDocument);
            }
        }
        catch (XPathException e) {
            throw new TriggerException("Error during trigger prepare", e);
        }
        catch (IOException e) {
            throw new TriggerException("Error during trigger prepare", e);
        }
        try {
            NodeSet contextSet = NodeSet.EMPTY_SET;
            this.service.execute(compiledQuery, contextSet);
            this.LOG.debug((Object)"Trigger fired for prepare");
        }
        catch (XPathException e) {
            throw new TriggerException("Error during trigger prepare", e);
        }
    }

    public void finish(int event, DBBroker broker, Txn transaction, XmldbURI documentPath, DocumentImpl document) {
        this.LOG.debug((Object)("Finishing " + XQueryTrigger.eventToString(event) + " XQuery trigger for document : '" + documentPath + "'"));
        Source query = this.getQuerySource(broker);
        if (query == null) {
            return;
        }
        if (!TriggerStatePerThread.verifyUniqueTriggerPerThreadBeforeFinish(this, documentPath)) {
            return;
        }
        XQueryContext context = this.service.newContext(AccessContext.TRIGGER);
        CompiledXQuery compiledQuery = null;
        try {
            compiledQuery = this.service.compile(context, query);
            context.declareVariable(this.bindingPrefix + "eventType", EVENT_TYPE_FINISH);
            context.declareVariable(this.bindingPrefix + "collectionName", new AnyURIValue(this.collection.getURI()));
            context.declareVariable(this.bindingPrefix + "documentName", new AnyURIValue(documentPath));
            context.declareVariable(this.bindingPrefix + "triggerEvent", new StringValue(XQueryTrigger.eventToString(event)));
            Iterator<Object> itUserVarName = this.userDefinedVariables.keySet().iterator();
            while (itUserVarName.hasNext()) {
                String varName = (String)itUserVarName.next();
                String varValue = this.userDefinedVariables.getProperty(varName);
                context.declareVariable(this.bindingPrefix + varName, new StringValue(varValue));
            }
            if (event == 2) {
                context.declareVariable(this.bindingPrefix + "document", Sequence.EMPTY_SEQUENCE);
            } else if (document instanceof BinaryDocument) {
                BinaryDocument bin = (BinaryDocument)document;
                byte[] data = context.getBroker().getBinaryResource(bin);
                context.declareVariable(this.bindingPrefix + "document", new Base64Binary(data));
            } else {
                context.declareVariable(this.bindingPrefix + "document", document);
            }
        }
        catch (XPathException e) {
            this.LOG.error((Object)e);
        }
        catch (IOException e) {
            this.LOG.error((Object)e);
        }
        try {
            NodeSet contextSet = NodeSet.EMPTY_SET;
            this.service.execute(compiledQuery, contextSet);
            TriggerStatePerThread.setTriggerRunningState(0, this, null);
            TriggerStatePerThread.setTransaction(null);
            this.LOG.debug((Object)"Trigger fired for finish");
        }
        catch (XPathException e) {
            this.LOG.error((Object)("Error during trigger finish " + e));
        }
    }

    public void startDocument() throws SAXException {
        this.originalOutputHandler = this.getOutputHandler();
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.setOutputHandler(this.originalOutputHandler);
    }

    public static String eventToString(int event) {
        switch (event) {
            case 0: {
                return "STORE";
            }
            case 1: {
                return "UPDATE";
            }
            case 2: {
                return "REMOVE";
            }
            case 3: {
                return "CREATE";
            }
            case 4: {
                return "RENAME";
            }
            case 5: {
                return "DELETE";
            }
        }
        return null;
    }
}

