/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import org.exist.dom.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.storage.btree.Value;
import org.exist.util.UTF8;
import org.exist.util.XMLString;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;

public class CharacterDataImpl
extends StoredNode
implements CharacterData {
    protected XMLString cdata = null;

    public CharacterDataImpl(short nodeType) {
        super(nodeType);
    }

    public CharacterDataImpl(short nodeType, NodeId nodeId) {
        super(nodeType, nodeId);
    }

    public CharacterDataImpl(short nodeType, NodeId nodeId, String data) {
        super(nodeType, nodeId);
        this.cdata = new XMLString(data.toCharArray());
    }

    public CharacterDataImpl(short nodeType, String data) {
        super(nodeType);
        this.cdata = new XMLString(data.toCharArray());
    }

    public CharacterDataImpl(short nodeType, char[] data, int start, int howmany) {
        super(nodeType);
        this.cdata = new XMLString(data, start, howmany);
    }

    public void clear() {
        super.clear();
        this.cdata.reset();
    }

    public void appendData(String arg) throws DOMException {
        if (this.cdata == null) {
            this.cdata = new XMLString(arg.toCharArray());
        } else {
            this.cdata.append(arg);
        }
    }

    public void appendData(char[] data, int start, int howmany) throws DOMException {
        if (this.cdata == null) {
            this.cdata = new XMLString(data, start, howmany);
        } else {
            this.cdata.append(data, start, howmany);
        }
    }

    public void deleteData(int offset, int count) throws DOMException {
        if (this.cdata != null) {
            this.cdata.delete(offset, count);
        }
    }

    public String getData() throws DOMException {
        if (this.cdata == null) {
            return null;
        }
        return this.cdata.toString();
    }

    public XMLString getXMLString() {
        return this.cdata;
    }

    public String getLowerCaseData() throws DOMException {
        if (this.cdata == null) {
            return null;
        }
        return this.cdata.toString().toLowerCase();
    }

    public int getLength() {
        return this.cdata.length();
    }

    public String getNodeValue() {
        return this.cdata.toString();
    }

    public void insertData(int offset, String arg) throws DOMException {
        if (this.cdata == null) {
            this.cdata = new XMLString(arg.toCharArray());
        } else {
            this.cdata.insert(offset, arg);
        }
    }

    public void replaceData(int offset, int count, String arg) throws DOMException {
        if (this.cdata == null) {
            throw new DOMException(2, "string index out of bounds");
        }
        this.cdata.replace(offset, count, arg);
    }

    public void setData(String data) throws DOMException {
        if (this.cdata == null) {
            this.cdata = new XMLString(data.toCharArray());
        } else {
            this.cdata.setData(data.toCharArray(), 0, data.length());
        }
    }

    public void setData(XMLString data) throws DOMException {
        this.cdata = data;
    }

    public void setData(char[] data, int start, int howmany) throws DOMException {
        if (this.cdata == null) {
            this.cdata = new XMLString(data, start, howmany);
        } else {
            this.cdata.setData(data, start, howmany);
        }
    }

    public String substringData(int offset, int count) throws DOMException {
        if (this.cdata == null) {
            throw new DOMException(2, "string index out of bounds");
        }
        return this.cdata.substring(offset, count);
    }

    public String toString() {
        if (this.cdata == null) {
            return null;
        }
        return this.cdata.toString();
    }

    public void release() {
        this.cdata.release();
        super.release();
    }

    public static XMLString readData(NodeId nodeId, Value value, XMLString string) {
        int nodeIdLen = nodeId.size();
        UTF8.decode(value.data(), value.start() + 3 + nodeIdLen, value.getLength() - 3 - nodeIdLen, string);
        return string;
    }
}

